/*
 * Decompiled with CFR 0.152.
 */
package er.ajax;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSNumberFormatter;
import er.ajax.AjaxComponent;
import er.ajax.AjaxDragResize;
import er.ajax.AjaxOption;
import er.ajax.AjaxResponse;
import er.ajax.AjaxUtils;
import er.extensions.appserver.ERXWOContext;

public class AjaxDragResizeContainer
extends AjaxComponent {
    public static final String EVENT_BLUR = "dragblur";
    public static final String EVENT_FOCUS = "dragfocus";
    public static final String EVENT_DRAG_END = "dragend";
    private String _dragResizeContainerID;
    private String _actionUrl;

    public AjaxDragResizeContainer(WOContext context) {
        super(context);
    }

    public boolean synchronizesVariablesWithBindings() {
        return false;
    }

    public void appendToResponse(WOResponse response, WOContext context) {
        this._dragResizeContainerID = (String)this.valueForBinding("id", ERXWOContext.safeIdentifierName((WOContext)this.context(), (boolean)true) + "_DragResizeContainer");
        this._actionUrl = AjaxUtils.ajaxComponentActionUrl(context);
        super.appendToResponse(response, context);
    }

    public String dragResizeContainerID() {
        return this._dragResizeContainerID;
    }

    public String style() {
        StringBuffer sb = new StringBuffer();
        sb.append("position: relative;");
        if (this.canGetValueForBinding("style")) {
            sb.append(this.valueForBinding("style"));
        }
        return sb.toString();
    }

    public NSDictionary createAjaxOptions() {
        NSMutableDictionary options = new NSMutableDictionary();
        options.takeValueForKey((Object)this.jsForElementOrHandle(this.drsElementClass()), "isElement");
        options.takeValueForKey((Object)this.jsForElementOrHandle(this.drsMoveHandleClass()), "isHandle");
        options.takeValueForKey((Object)this.jsForEvent(EVENT_DRAG_END), "ondragend");
        options.takeValueForKey((Object)this.jsForEvent(EVENT_FOCUS), "ondragfocus");
        options.takeValueForKey((Object)this.jsForEvent(EVENT_BLUR), "ondragblur");
        NSMutableArray ajaxOptionsArray = new NSMutableArray();
        ajaxOptionsArray.addObject((Object)new AjaxOption("minWidth", AjaxOption.NUMBER));
        ajaxOptionsArray.addObject((Object)new AjaxOption("minHeight", AjaxOption.NUMBER));
        ajaxOptionsArray.addObject((Object)new AjaxOption("minLeft", AjaxOption.NUMBER));
        ajaxOptionsArray.addObject((Object)new AjaxOption("minTop", AjaxOption.NUMBER));
        ajaxOptionsArray.addObject((Object)new AjaxOption("maxLeft", AjaxOption.NUMBER));
        ajaxOptionsArray.addObject((Object)new AjaxOption("maxTop", AjaxOption.NUMBER));
        ajaxOptionsArray.addObject((Object)new AjaxOption("ondragfocus", AjaxOption.SCRIPT));
        ajaxOptionsArray.addObject((Object)new AjaxOption("ondragstart", AjaxOption.SCRIPT));
        ajaxOptionsArray.addObject((Object)new AjaxOption("ondragend", AjaxOption.SCRIPT));
        ajaxOptionsArray.addObject((Object)new AjaxOption("ondragmove", AjaxOption.SCRIPT));
        ajaxOptionsArray.addObject((Object)new AjaxOption("ondragblur", AjaxOption.SCRIPT));
        ajaxOptionsArray.addObject((Object)new AjaxOption("enabled", AjaxOption.BOOLEAN));
        options.addEntriesFromDictionary(AjaxOption.createAjaxOptionsDictionary((NSArray<AjaxOption>)ajaxOptionsArray, this));
        return options;
    }

    private String jsForElementOrHandle(String cssClass) {
        return "function(elm){ if (elm.className && elm.className.indexOf('" + cssClass + "') > -1) return true; }";
    }

    private String drsElementClass() {
        return (String)this.valueForBinding("drsElement", "drsElement");
    }

    private String drsMoveHandleClass() {
        return (String)this.valueForBinding("drsMoveHandle", this.drsElementClass());
    }

    private String jsForEvent(String event) {
        return "function(isResize){ this.reqNum += 1; new Ajax.Request('" + this._actionUrl + "', {method: 'get', parameters: " + "'id='+this.element.id+'&" + "event=" + event + "&" + "w='+this.elmW+'&" + "h='+this.elmH+'&" + "x='+this.elmX+'&" + "y='+this.elmY+'&" + "resized='+isResize+'&" + "reqNum='+this.reqNum" + " })}";
    }

    protected void addRequiredWebResources(WOResponse response) {
        this.addScriptResourceInHead(response, "prototype.js");
        this.addScriptResourceInHead(response, "dragresize.js");
    }

    public WOActionResults handleRequest(WORequest request, WOContext context) {
        WOActionResults results;
        AjaxResponse result = AjaxUtils.createResponse(request, context);
        result.setHeader("text/javascript", "content-type");
        if (this.canSetValueForBinding("report")) {
            Object o = AjaxDragResize.resizableObjectForPage(context.page(), request.stringFormValueForKey("id"));
            NSNumberFormatter formatter = new NSNumberFormatter("0");
            ResizeReport report = new ResizeReport(this.dragResizeContainerID(), request.stringFormValueForKey("event"), request.stringFormValueForKey("id"), request.numericFormValueForKey("x", formatter).intValue(), request.numericFormValueForKey("y", formatter).intValue(), request.numericFormValueForKey("w", formatter).intValue(), request.numericFormValueForKey("h", formatter).intValue(), "true".equals(request.stringFormValueForKey("resized")), o);
            this.setValueForBinding(report, "report");
        }
        if (this.canGetValueForBinding("action") && (results = (WOActionResults)this.valueForBinding("action")) != null) {
            System.out.println("AjaxDragResize.handleRequest: Not quite sure what to do with non-null results yet ...");
        }
        return result;
    }

    public class ResizeReport {
        private int _x;
        private int _y;
        private int _width;
        private int _height;
        private boolean _resized;
        private Object _object;
        private String _id;
        private String _event;
        private String _container;

        public ResizeReport(String container, String event, String id, int x, int y, int width, int height, boolean resized, Object object) {
            this._x = x;
            this._y = y;
            this._width = width;
            this._height = height;
            this._resized = resized;
            this._object = object;
            this._id = id;
            this._event = event;
            this._container = container;
        }

        public int height() {
            return this._height;
        }

        public boolean resize() {
            return this._resized;
        }

        public Object object() {
            return this._object;
        }

        public int width() {
            return this._width;
        }

        public int x() {
            return this._x;
        }

        public int y() {
            return this._y;
        }

        public String id() {
            return this._id;
        }

        public String event() {
            return this._event;
        }

        public String container() {
            return this._container;
        }

        public String toString() {
            return "ResizeReport: {container: " + this._container + ", event: " + this._event + ", id: " + this._id + ", geometry: " + this._width + "x" + this._height + "+" + this._x + "+" + this._y + ", resized: " + this._resized + ", " + (this._object == null ? "" : "objectClass: " + this._object.getClass().getName() + ", ") + "object: " + this._object + "}";
        }

        public boolean isBlur() {
            return AjaxDragResizeContainer.EVENT_BLUR.equals(this.event());
        }

        public boolean isDragEnd() {
            return AjaxDragResizeContainer.EVENT_DRAG_END.equals(this.event());
        }

        public boolean isFocus() {
            return AjaxDragResizeContainer.EVENT_FOCUS.equals(this.event());
        }
    }
}

