/*
 * Decompiled with CFR 0.152.
 */
package er.ajax;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import er.ajax.AjaxComponent;
import er.ajax.AjaxDraggable;
import er.ajax.AjaxOption;
import er.ajax.AjaxOptions;
import er.ajax.AjaxSubmitButton;
import er.ajax.AjaxUpdateContainer;
import er.ajax.AjaxUtils;
import er.ajax.AjaxValue;
import er.extensions.components.ERXComponentUtilities;
import er.extensions.components._private.ERXWOForm;

public class AjaxDroppable
extends AjaxComponent {
    private String _draggableIDKeyName;
    private String _actionUrl;
    private String _elementID;

    public AjaxDroppable(WOContext _context) {
        super(_context);
    }

    public void awake() {
        super.awake();
        this._draggableIDKeyName = this.safeElementID() + "_draggableID";
    }

    public boolean isStateless() {
        return true;
    }

    public boolean synchronizesVariablesWithBindings() {
        return false;
    }

    public void appendToResponse(WOResponse response, WOContext context) {
        this._actionUrl = AjaxUtils.ajaxComponentActionUrl(this.context());
        this._elementID = context.elementID();
        super.appendToResponse(response, context);
    }

    public NSDictionary createAjaxOptions() {
        NSMutableArray ajaxOptionsArray = new NSMutableArray();
        ajaxOptionsArray.addObject((Object)new AjaxOption("accept", AjaxOption.STRING_ARRAY));
        ajaxOptionsArray.addObject((Object)new AjaxOption("containment", AjaxOption.STRING_ARRAY));
        ajaxOptionsArray.addObject((Object)new AjaxOption("hoverclass", AjaxOption.STRING));
        ajaxOptionsArray.addObject((Object)new AjaxOption("overlap", AjaxOption.STRING));
        ajaxOptionsArray.addObject((Object)new AjaxOption("greedy", AjaxOption.BOOLEAN));
        ajaxOptionsArray.addObject((Object)new AjaxOption("onHover", AjaxOption.SCRIPT));
        ajaxOptionsArray.addObject((Object)new AjaxOption("evalScripts", AjaxOption.BOOLEAN));
        NSMutableDictionary<String, String> options = AjaxOption.createAjaxOptionsDictionary((NSArray<AjaxOption>)ajaxOptionsArray, this);
        if (options.objectForKey((Object)"evalScripts") == null) {
            options.setObjectForKey((Object)"true", (Object)"evalScripts");
        }
        return options;
    }

    public String elementName() {
        return (String)this.valueForBinding("elementName", "div");
    }

    public String onDrop() {
        boolean submit = ERXComponentUtilities.booleanValueForBinding((WOComponent)this, (String)"submit", (boolean)false);
        String contextID = AjaxUtils.quote(this.context().contextID());
        String elementID = AjaxUtils.quote(this._elementID);
        String droppableElementID = AjaxUtils.quote((String)this.valueForBinding("id"));
        String draggableKeyName = AjaxUtils.quote(this._draggableIDKeyName);
        String updateContainerID = AjaxUtils.quote((String)this.valueForBinding("updateContainerID"));
        String actionUrl = submit && updateContainerID == null ? null : AjaxUtils.quote(this._actionUrl);
        String form = (String)this.valueForBinding("formName");
        if (submit) {
            if (form == null && (form = ERXWOForm.formName((WOContext)this.context(), null)) == null) {
                throw new IllegalArgumentException("If submit is true, you must provide either a formName or your containing form must have a name.");
            }
            form = "document." + form;
        }
        String onbeforedrop = (String)this.valueForBinding("onBeforeDrop");
        String ondrop = (String)this.valueForBinding("onDrop");
        NSMutableDictionary options = new NSMutableDictionary();
        if (this.canGetValueForBinding("onComplete")) {
            options.setObjectForKey(this.valueForBinding("onComplete"), (Object)"onComplete");
        }
        if (this.canGetValueForBinding("confirmMessage")) {
            options.setObjectForKey((Object)new AjaxValue(AjaxOption.STRING, this.valueForBinding("confirmMessage")).javascriptValue(), (Object)"confirmMessage");
        }
        if (submit) {
            AjaxSubmitButton.fillInAjaxOptions(this, this, this._elementID, options);
        }
        StringBuffer onDropBuffer = new StringBuffer();
        onDropBuffer.append("ADP.droppedFunc(" + contextID + "," + elementID + "," + droppableElementID + "," + draggableKeyName + "," + updateContainerID + "," + actionUrl + "," + form + "," + onbeforedrop + "," + ondrop + ",");
        AjaxOptions.appendToBuffer((NSDictionary)options, onDropBuffer, this.context());
        onDropBuffer.append(")");
        return onDropBuffer.toString();
    }

    protected void addRequiredWebResources(WOResponse res) {
        this.addScriptResourceInHead(res, "prototype.js");
        this.addScriptResourceInHead(res, "effects.js");
        this.addScriptResourceInHead(res, "dragdrop.js");
        this.addScriptResourceInHead(res, "wonder.js");
    }

    public WOActionResults handleRequest(WORequest request, WOContext context) {
        WOActionResults results;
        AjaxUpdateContainer.setUpdateContainerID(request, (String)this.valueForBinding("updateContainerID"));
        String droppedDraggableID = request.stringFormValueForKey(this._draggableIDKeyName);
        if (this.canSetValueForBinding("droppedDraggableID")) {
            this.setValueForBinding(droppedDraggableID, "droppedDraggableID");
        }
        if (this.canSetValueForBinding("droppedObject")) {
            WOComponent page = context.page();
            Object droppedObject = AjaxDraggable.draggableObjectForPage(page, droppedDraggableID);
            this.setValueForBinding(droppedObject, "droppedObject");
        }
        if (this.canGetValueForBinding("action") && (results = (WOActionResults)this.valueForBinding("action")) != null) {
            System.out.println("AjaxDroppable.handleRequest: Not quite sure what to do with non-null results yet ...");
        }
        return null;
    }
}

