/*
 * Decompiled with CFR 0.152.
 */
package er.ajax;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOMultipartIterator;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WORequestHandler;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver.WOSession;
import com.webobjects.foundation.NSArray;
import er.ajax.AjaxProgressBar;
import er.ajax.AjaxUploadProgress;
import er.extensions.formatters.ERXUnitAwareDecimalFormat;
import er.extensions.foundation.ERXProperties;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;

public class AjaxFileUploadRequestHandler
extends WORequestHandler {
    public static final String UPLOAD_FINISHED_KEY = "ajaxFileUploadFinished";
    public static final String REQUEST_HANDLER_KEY = "upload";
    public static final Logger log = Logger.getLogger(AjaxFileUploadRequestHandler.class);
    private File _tempFileFolder;
    private long _maxUploadSize;

    public AjaxFileUploadRequestHandler() {
        this(ERXProperties.stringForKey((String)"er.ajax.AjaxFileRequestHandler.tempFileFolder"), ERXProperties.longForKeyWithDefault((String)"er.ajax.AjaxFileRequestHandler.maxUploadSize", (long)-1L));
    }

    protected AjaxFileUploadRequestHandler(String tempFilePath, long maxUploadSize) {
        this(tempFilePath == null ? null : new File(tempFilePath), maxUploadSize);
    }

    public AjaxFileUploadRequestHandler(File tempFileFolder, long maxUploadSize) {
        this._tempFileFolder = tempFileFolder;
        this._maxUploadSize = maxUploadSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WOResponse handleRequest(WORequest request) {
        WOApplication application = WOApplication.application();
        application.awake();
        try {
            WOResponse response;
            block23: {
                WOContext context = application.createContextForRequest(request);
                response = application.createResponseInContext(context);
                String uploadIdentifier = null;
                String uploadFileName = null;
                InputStream uploadInputStream = null;
                int streamLength = -1;
                try {
                    String wosid = request.cookieValueForKey("wosid");
                    WOMultipartIterator multipartIterator = request.multipartIterator();
                    if (multipartIterator == null) {
                        response.appendContentString("Already Consumed!");
                        break block23;
                    }
                    WOMultipartIterator.WOFormData formData = null;
                    while ((formData = multipartIterator.nextFormData()) != null) {
                        String name = formData.name();
                        if ("wosid".equals(name)) {
                            wosid = formData.formValue();
                            continue;
                        }
                        if ("id".equals(name)) {
                            uploadIdentifier = formData.formValue();
                            continue;
                        }
                        if (!formData.isFileUpload()) continue;
                        uploadFileName = request.stringFormValueForKey(name + ".filename");
                        streamLength = multipartIterator.contentLengthRemaining();
                        uploadInputStream = formData.formDataInputStream();
                        break;
                    }
                    context._setRequestSessionID(wosid);
                    WOSession session = null;
                    if (context._requestSessionID() != null) {
                        session = WOApplication.application().restoreSessionWithID(wosid, context);
                    }
                    File tempFile = File.createTempFile("AjaxFileUpload", ".tmp", this._tempFileFolder);
                    tempFile.deleteOnExit();
                    AjaxUploadProgress progress = new AjaxUploadProgress(uploadIdentifier, tempFile, uploadFileName, streamLength);
                    try {
                        AjaxProgressBar.registerProgress(session, progress);
                    }
                    finally {
                        if (context._requestSessionID() != null) {
                            WOApplication.application().saveSessionForContext(context);
                        }
                    }
                    NSArray contentType = (NSArray)formData.headers().valueForKey("content-type");
                    if (contentType != null) {
                        progress.setContentType((String)contentType.objectAtIndex(0));
                    }
                    try {
                        if (this._maxUploadSize >= 0L && (long)streamLength > this._maxUploadSize) {
                            IOException e = new IOException("You attempted to upload a file larger than the maximum allowed size of " + new ERXUnitAwareDecimalFormat("byte").format(this._maxUploadSize) + ".");
                            progress.setFailure(e);
                            progress.dispose();
                            throw e;
                        }
                        FileOutputStream fos = new FileOutputStream(progress.tempFile());
                        try {
                            progress.copyAndTrack(uploadInputStream, fos, this._maxUploadSize);
                        }
                        finally {
                            fos.flush();
                            fos.close();
                        }
                        if (!progress.isCanceled() && !progress.shouldReset()) {
                            this.downloadFinished(progress);
                        }
                    }
                    finally {
                        progress.setDone(true);
                    }
                }
                catch (Throwable t) {
                    log.error((Object)t);
                    response.appendContentString("Failed: " + t.getMessage());
                }
            }
            WOResponse wOResponse = response;
            return wOResponse;
        }
        finally {
            application.sleep();
        }
    }

    protected void downloadFinished(AjaxUploadProgress progress) {
    }

    public static AjaxUploadProgress ajaxUploadProgress(WOSession session, String id) {
        return (AjaxUploadProgress)AjaxProgressBar.progress(session, id);
    }
}

