/*
 * Decompiled with CFR 0.152.
 */
package er.ajax;

import com.webobjects.appserver.WOAssociation;
import com.webobjects.appserver.WOComponent;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableDictionary;
import er.ajax.AjaxValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxOption {
    public static final Type DEFAULT = new Type(0);
    public static final Type STRING = new Type(1);
    public static final Type SCRIPT = new Type(2);
    public static final Type NUMBER = new Type(3);
    public static final Type ARRAY = new Type(4);
    public static final Type STRING_ARRAY = new Type(5);
    public static final Type BOOLEAN = new Type(6);
    public static final Type STRING_OR_ARRAY = new Type(7);
    public static final Type DICTIONARY = new Type(8);
    public static final Type FUNCTION = new Type(9);
    public static final Type FUNCTION_1 = new Type(9);
    public static final Type FUNCTION_2 = new Type(9);
    private String _name;
    private String _bindingName;
    private Object _defaultValue;
    private Type _type;

    public AjaxOption(String name) {
        this(name, DEFAULT);
    }

    public AjaxOption(String name, Type type) {
        this(name, name, null, type);
    }

    public AjaxOption(String name, Object defaultValue, Type type) {
        this(name, name, defaultValue, type);
    }

    public AjaxOption(String name, String bindingName, Object defaultValue, Type type) {
        this._name = name;
        this._bindingName = bindingName;
        this._type = type;
        this._defaultValue = defaultValue;
    }

    public String name() {
        return this._name;
    }

    public Type type() {
        return this._type;
    }

    public AjaxValue valueForObject(Object obj) {
        return new AjaxValue(this._type, obj);
    }

    public Object defaultValue() {
        return this._defaultValue;
    }

    protected Object valueInComponent(WOComponent component) {
        Object value = component.valueForBinding(this._bindingName);
        if (value instanceof WOAssociation) {
            WOAssociation association = (WOAssociation)value;
            value = association.valueInComponent(component);
        }
        if (value == null) {
            value = this._defaultValue;
        }
        return value;
    }

    protected Object valueInComponent(WOComponent component, NSDictionary<String, ? extends WOAssociation> associations) {
        Object value = null;
        if (associations != null && (value = associations.objectForKey((Object)this._bindingName)) instanceof WOAssociation) {
            WOAssociation association = (WOAssociation)value;
            value = association.valueInComponent(component);
        }
        if (value == null) {
            value = this._defaultValue;
        }
        return value;
    }

    public void addToDictionary(WOComponent component, NSMutableDictionary<String, String> dictionary) {
        Object value = this.valueInComponent(component);
        String strValue = this.valueForObject(value).javascriptValue();
        if (strValue != null) {
            dictionary.setObjectForKey((Object)strValue, (Object)this._name);
        }
    }

    protected void addToDictionary(WOComponent component, NSDictionary<String, ? extends WOAssociation> associations, NSMutableDictionary<String, String> dictionary) {
        Object value = this.valueInComponent(component, associations);
        String strValue = this.valueForObject(value).javascriptValue();
        if (strValue != null) {
            dictionary.setObjectForKey((Object)strValue, (Object)this._name);
        }
    }

    public static NSMutableDictionary<String, String> createAjaxOptionsDictionary(NSArray<AjaxOption> ajaxOptions, WOComponent component) {
        NSMutableDictionary optionsDictionary = new NSMutableDictionary();
        for (AjaxOption ajaxOption : ajaxOptions) {
            ajaxOption.addToDictionary(component, (NSMutableDictionary<String, String>)optionsDictionary);
        }
        return optionsDictionary;
    }

    public static NSMutableDictionary<String, String> createAjaxOptionsDictionary(NSArray<AjaxOption> ajaxOptions, WOComponent component, NSDictionary<String, ? extends WOAssociation> associations) {
        NSMutableDictionary optionsDictionary = new NSMutableDictionary();
        for (AjaxOption ajaxOption : ajaxOptions) {
            ajaxOption.addToDictionary(component, associations, (NSMutableDictionary<String, String>)optionsDictionary);
        }
        return optionsDictionary;
    }

    public static class Type {
        private int _number;

        public Type(int number) {
            this._number = number;
        }
    }
}

