/*
 * Decompiled with CFR 0.152.
 */
package er.ajax;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOMessage;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import er.ajax.Ajax;
import er.ajax.AjaxResponseAppender;
import er.ajax.AjaxUpdateContainer;
import er.ajax.AjaxUtils;
import er.extensions.appserver.ERXResponse;
import er.extensions.appserver.ajax.ERXAjaxApplication;
import er.extensions.foundation.ERXKeyValueCodingUtilities;
import java.util.Enumeration;

public class AjaxResponse
extends ERXResponse {
    public static final String AJAX_UPDATE_PASS = "_ajaxUpdatePass";
    private static NSMutableArray _responseAppenders;
    private WORequest _request;
    private WOContext _context;

    public static void addAjaxResponseAppender(AjaxResponseAppender responseAppender) {
        if (_responseAppenders == null) {
            _responseAppenders = new NSMutableArray();
        }
        _responseAppenders.addObject((Object)responseAppender);
    }

    public AjaxResponse(WORequest request, WOContext context) {
        super(context);
        this._request = request;
        this._context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WOResponse generateResponse() {
        if (AjaxUpdateContainer.hasUpdateContainerID(this._request)) {
            String originalSenderID = this._context.senderID();
            this._context._setSenderID("");
            try {
                int length;
                AbstractStringBuilder content;
                if (this._content instanceof StringBuffer) {
                    content = this._content;
                    ERXKeyValueCodingUtilities.takePrivateValueForKey((Object)((Object)this), (Object)new StringBuffer(), (String)"_content");
                } else {
                    content = (StringBuilder)((Object)this._content);
                    ERXKeyValueCodingUtilities.takePrivateValueForKey((Object)((Object)this), (Object)new StringBuilder(), (String)"_content");
                }
                NSMutableDictionary userInfo = AjaxUtils.mutableUserInfo((WOMessage)this._request);
                userInfo.setObjectForKey((Object)Boolean.TRUE, (Object)AJAX_UPDATE_PASS);
                WOActionResults woactionresults = WOApplication.application().invokeAction(this._request, this._context);
                this._content.append((CharSequence)content);
                if (_responseAppenders != null) {
                    Enumeration responseAppendersEnum = _responseAppenders.objectEnumerator();
                    while (responseAppendersEnum.hasMoreElements()) {
                        AjaxResponseAppender responseAppender = (AjaxResponseAppender)responseAppendersEnum.nextElement();
                        responseAppender.appendToResponse((WOResponse)this, this._context);
                    }
                }
                if (this._content instanceof StringBuffer) {
                    StringBuffer buffer = this._content;
                    length = buffer.length();
                } else {
                    StringBuilder builder = (StringBuilder)((Object)this._content);
                    length = builder.length();
                }
                if (length == 0) {
                    this.setStatus(500);
                    Ajax.log.warn((Object)("You performed an Ajax update, but no response was generated. A common cause of this is that you spelled your updateContainerID wrong.  You specified a container ID '" + AjaxUpdateContainer.updateContainerID(this._request) + "'."));
                }
            }
            finally {
                this._context._setSenderID(originalSenderID);
            }
        }
        return this;
    }

    public static boolean isAjaxUpdatePass(WORequest request) {
        NSMutableDictionary userInfo = AjaxUtils.mutableUserInfo((WOMessage)request);
        return userInfo != null && userInfo.valueForKey(AJAX_UPDATE_PASS) != null;
    }

    public void appendScriptHeaderIfNecessary() {
        AjaxUtils.appendScriptHeaderIfNecessary(this._request, (WOResponse)this);
    }

    public void appendScriptFooterIfNecessary() {
        AjaxUtils.appendScriptFooterIfNecessary(this._request, (WOResponse)this);
    }

    public void updateDomElement(String id, Object value, String numberFormat, String dateFormat, String valueWhenEmpty) {
        AjaxUtils.updateDomElement((WOResponse)this, id, value, numberFormat, dateFormat, valueWhenEmpty);
    }

    public void updateDomElement(String id, Object value) {
        this.updateDomElement(id, value, null, null, null);
    }

    public static class AjaxResponseDelegate
    implements ERXAjaxApplication.ERXAjaxResponseDelegate {
        public WOActionResults handleNullActionResults(WORequest request, WOResponse response, WOContext context) {
            String updateContainerID;
            String contentLength;
            Object finalActionResults = response;
            if (!(response instanceof AjaxResponse) && (contentLength = response.headerForKey((Object)"content-length")) == null && (updateContainerID = request.stringFormValueForKey("_u")) != null) {
                AjaxUpdateContainer.setUpdateContainerID(request, updateContainerID);
                finalActionResults = AjaxUtils.createResponse(request, context);
            }
            return finalActionResults;
        }
    }
}

