/*
 * Decompiled with CFR 0.152.
 */
package er.ajax;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.eocontrol.EOKeyValueQualifier;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSRange;
import er.ajax.AjaxComponent;
import er.ajax.AjaxOption;
import er.ajax.AjaxUtils;
import java.util.NoSuchElementException;

public class AjaxSortableList
extends AjaxComponent {
    private String _id;
    private String _actionUrl;
    private String _sortOrderKeyName;

    public AjaxSortableList(WOContext context) {
        super(context);
    }

    public String id() {
        return this._id;
    }

    public String listElementName() {
        String elementName = "ul";
        if (this.hasBinding("listElementName")) {
            elementName = (String)this.valueForBinding("listElementName");
        }
        return elementName;
    }

    public String listItemElementName() {
        String elementName = "li";
        if (this.hasBinding("listItemElementName")) {
            elementName = (String)this.valueForBinding("listItemElementName");
        }
        return elementName;
    }

    public String listItemID(String itemID) {
        String listID = (String)this.valueForBinding("id");
        String listItemIDWithoutIndex = listID + "_" + itemID;
        return listItemIDWithoutIndex;
    }

    public String listItemID() {
        Object item = this.valueForBinding("item");
        String listItemIDKeyPath = (String)this.valueForBinding("listItemIDKeyPath");
        String itemID = String.valueOf(NSKeyValueCodingAdditions.Utility.valueForKeyPath((Object)item, (String)listItemIDKeyPath));
        String listItemID = this.listItemID(itemID);
        return listItemID;
    }

    public boolean synchronizesVariablesWithBindings() {
        return false;
    }

    public void appendToResponse(WOResponse response, WOContext context) {
        this._actionUrl = AjaxUtils.ajaxComponentActionUrl(context);
        this._id = this.hasBinding("id") ? (String)this.valueForBinding("id") : this.safeElementID();
        this._sortOrderKeyName = this.safeElementID();
        super.appendToResponse(response, context);
    }

    protected void addRequiredWebResources(WOResponse res) {
        this.addScriptResourceInHead(res, "prototype.js");
        this.addScriptResourceInHead(res, "effects.js");
        this.addScriptResourceInHead(res, "dragdrop.js");
    }

    public NSDictionary createAjaxOptions() {
        NSMutableArray ajaxOptionsArray = new NSMutableArray();
        ajaxOptionsArray.addObject((Object)new AjaxOption("tag", AjaxOption.STRING));
        ajaxOptionsArray.addObject((Object)new AjaxOption("treeTag", AjaxOption.STRING));
        ajaxOptionsArray.addObject((Object)new AjaxOption("only", AjaxOption.STRING_ARRAY));
        ajaxOptionsArray.addObject((Object)new AjaxOption("overlap", AjaxOption.STRING));
        ajaxOptionsArray.addObject((Object)new AjaxOption("constraint", AjaxOption.STRING));
        ajaxOptionsArray.addObject((Object)new AjaxOption("containment", AjaxOption.STRING_ARRAY));
        ajaxOptionsArray.addObject((Object)new AjaxOption("handle", AjaxOption.STRING));
        ajaxOptionsArray.addObject((Object)new AjaxOption("hoverclass", AjaxOption.STRING));
        ajaxOptionsArray.addObject((Object)new AjaxOption("ghosting", AjaxOption.BOOLEAN));
        ajaxOptionsArray.addObject((Object)new AjaxOption("dropOnEmpty", AjaxOption.BOOLEAN));
        ajaxOptionsArray.addObject((Object)new AjaxOption("scroll", AjaxOption.BOOLEAN));
        ajaxOptionsArray.addObject((Object)new AjaxOption("onChange", AjaxOption.SCRIPT));
        NSMutableDictionary<String, String> options = AjaxOption.createAjaxOptionsDictionary((NSArray<AjaxOption>)ajaxOptionsArray, this);
        return options;
    }

    public String onUpdate() {
        StringBuffer onUpdateBuffer = new StringBuffer();
        onUpdateBuffer.append("function(container) {");
        String containerID = (String)this.valueForBinding("id");
        onUpdateBuffer.append("var data = Sortable.serialize('" + containerID + "', { name:'" + this._sortOrderKeyName + "'});");
        onUpdateBuffer.append("var ajaxRequest = new Ajax.Request('" + this._actionUrl + "', {method: 'get', parameters: data});");
        if (this.canGetValueForBinding("onUpdate")) {
            String onUpdate = (String)this.valueForBinding("onUpdate");
            onUpdateBuffer.append(" var parentOnUpdate = ");
            onUpdateBuffer.append(onUpdate);
            onUpdateBuffer.append(";");
            onUpdateBuffer.append("parentOnUpdate(container);");
        }
        onUpdateBuffer.append("}");
        return onUpdateBuffer.toString();
    }

    public WOActionResults handleRequest(WORequest request, WOContext context) {
        WOActionResults results;
        NSArray listItemIDArray;
        if (!this.canGetValueForBinding("list")) {
            throw new IllegalArgumentException("You must specify a readable 'list'.");
        }
        if (!this.canGetValueForBinding("listItemIDKeyPath")) {
            throw new IllegalArgumentException("You must specify 'listItemIDKeyPath' if you specify 'list'.");
        }
        String listItemIDKeyPath = (String)this.valueForBinding("listItemIDKeyPath");
        Object listItemIDArrayObj = request.formValues().objectForKey((Object)(this._sortOrderKeyName + "[]"));
        if (listItemIDArrayObj instanceof NSArray) {
            listItemIDArray = (NSArray)listItemIDArrayObj;
        } else if (listItemIDArrayObj instanceof String) {
            String listItemIDStr = (String)listItemIDArrayObj;
            listItemIDArray = new NSArray((Object)listItemIDStr);
        } else {
            throw new IllegalArgumentException("Unknown list item ID array " + listItemIDArrayObj);
        }
        NSArray list = (NSArray)this.valueForBinding("list");
        boolean mutableList = list instanceof NSMutableArray;
        NSMutableArray reorderedList = mutableList ? (NSMutableArray)list : new NSMutableArray();
        int startIndex = 0;
        if (this.canGetValueForBinding("startIndex")) {
            Number startIndexNumber = (Number)this.valueForBinding("startIndex");
            startIndex = startIndexNumber.intValue();
            if (!mutableList) {
                for (int i = 0; i < startIndex; ++i) {
                    reorderedList.addObject(list.objectAtIndex(i));
                }
            }
        }
        int listItemIDCount = listItemIDArray.count();
        for (int listItemIDIndex = 0; listItemIDIndex < listItemIDCount; ++listItemIDIndex) {
            EOKeyValueQualifier itemIDQualifier;
            String itemID = (String)listItemIDArray.objectAtIndex(listItemIDIndex);
            NSRange itemPageRange = mutableList ? new NSRange(startIndex + listItemIDIndex, listItemIDCount - listItemIDIndex) : new NSRange(startIndex, listItemIDCount);
            NSArray itemPageArray = list.subarrayWithRange(itemPageRange);
            NSArray matchingItems = EOQualifier.filteredArrayWithQualifier((NSArray)itemPageArray, (EOQualifier)(itemIDQualifier = new EOKeyValueQualifier(listItemIDKeyPath, EOQualifier.QualifierOperatorEqual, (Object)itemID)));
            if (matchingItems.count() == 0) {
                throw new NoSuchElementException("There was no item that matched the ID '" + itemID + "' in " + list + ".");
            }
            if (matchingItems.count() > 1) {
                throw new IllegalStateException("There was more than one item that matched the ID '" + itemID + "' in " + list + ".");
            }
            Object replacingItem = matchingItems.objectAtIndex(0);
            if (mutableList) {
                int replacedItemIndex = itemPageRange.location();
                Object replacedItem = reorderedList.objectAtIndex(replacedItemIndex);
                if (replacedItem == replacingItem) continue;
                int replacingItemIndex = replacedItemIndex + itemPageArray.indexOfObject(replacingItem);
                reorderedList.replaceObjectAtIndex(replacingItem, replacedItemIndex);
                reorderedList.replaceObjectAtIndex(replacedItem, replacingItemIndex);
                continue;
            }
            reorderedList.addObject(replacingItem);
        }
        if (!mutableList) {
            int listCount = list.count();
            for (int i = startIndex + reorderedList.count(); i < listCount; ++i) {
                reorderedList.addObject(list.objectAtIndex(i));
            }
            this.setValueForBinding(reorderedList, "list");
        }
        if (this.canGetValueForBinding("action") && (results = (WOActionResults)this.valueForBinding("action")) != null) {
            System.out.println("AjaxDroppable.handleRequest: Not quite sure what to do with non-null results yet ...");
        }
        return null;
    }
}

