/*
 * Decompiled with CFR 0.152.
 */
package er.ajax;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOAssociation;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOElement;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver._private.WODynamicElementCreationException;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import er.ajax.AjaxDynamicElement;
import er.ajax.AjaxOption;
import er.ajax.AjaxOptions;
import er.ajax.AjaxResponse;
import er.ajax.AjaxUpdateContainer;
import er.ajax.AjaxUpdateLink;
import er.ajax.AjaxUtils;
import er.ajax.IAjaxElement;
import er.extensions.appserver.ajax.ERXAjaxApplication;
import er.extensions.components._private.ERXWOForm;
import er.extensions.foundation.ERXProperties;

public class AjaxSubmitButton
extends AjaxDynamicElement {
    public static final String KEY_AJAX_SUBMIT_BUTTON_NAME = "AJAX_SUBMIT_BUTTON_NAME";
    public static final String KEY_PARTIAL_FORM_SENDER_ID = "_partialSenderID";

    public AjaxSubmitButton(String name, NSDictionary associations, WOElement children) {
        super(name, associations, children);
    }

    public static boolean isAjaxSubmit(WORequest request) {
        return request.formValueForKey(KEY_AJAX_SUBMIT_BUTTON_NAME) != null;
    }

    public boolean disabledInComponent(WOComponent component) {
        return this.booleanValueForBinding("disabled", false, component);
    }

    public String nameInContext(WOContext context, WOComponent component) {
        return (String)this.valueForBinding("name", context.elementID(), component);
    }

    public NSMutableDictionary createAjaxOptions(WOComponent component) {
        NSMutableArray ajaxOptionsArray = new NSMutableArray();
        ajaxOptionsArray.addObject((Object)new AjaxOption("onComplete", AjaxOption.SCRIPT));
        ajaxOptionsArray.addObject((Object)new AjaxOption("onSuccess", AjaxOption.SCRIPT));
        ajaxOptionsArray.addObject((Object)new AjaxOption("onFailure", AjaxOption.SCRIPT));
        ajaxOptionsArray.addObject((Object)new AjaxOption("onLoading", AjaxOption.SCRIPT));
        ajaxOptionsArray.addObject((Object)new AjaxOption("evalScripts", AjaxOption.BOOLEAN));
        ajaxOptionsArray.addObject((Object)new AjaxOption("insertion", AjaxOption.SCRIPT));
        ajaxOptionsArray.addObject((Object)new AjaxOption("asynchronous", AjaxOption.BOOLEAN));
        String name = this.nameInContext(component.context(), component);
        NSMutableDictionary<String, String> options = AjaxOption.createAjaxOptionsDictionary((NSArray<AjaxOption>)ajaxOptionsArray, component, (NSDictionary<String, ? extends WOAssociation>)this.associations());
        AjaxSubmitButton.fillInAjaxOptions(this, component, name, options);
        return options;
    }

    public static void fillInAjaxOptions(IAjaxElement element, WOComponent component, String submitButtonName, NSMutableDictionary options) {
        String systemDefaultFormSerializer = "Form.serializeWithoutSubmits";
        String defaultFormSerializer = ERXProperties.stringForKeyWithDefault((String)"er.ajax.formSerializer", (String)systemDefaultFormSerializer);
        String formSerializer = (String)element.valueForBinding("formSerializer", defaultFormSerializer, component);
        if (!defaultFormSerializer.equals(systemDefaultFormSerializer)) {
            options.setObjectForKey((Object)formSerializer, (Object)"_fs");
        }
        options.setObjectForKey((Object)("'" + submitButtonName + "'"), (Object)"_asbn");
        if ("true".equals(options.objectForKey((Object)"asynchronous"))) {
            options.removeObjectForKey((Object)"asynchronous");
        }
        if ("true".equals(options.objectForKey((Object)"evalScripts"))) {
            options.removeObjectForKey((Object)"evalScripts");
        }
        AjaxUpdateContainer.expandInsertionFromOptions((NSMutableDictionary<String, String>)options, element, component);
    }

    public void appendToResponse(WOResponse response, WOContext context) {
        String id;
        boolean showButton;
        WOComponent component = context.component();
        String functionName = (String)this.valueForBinding("functionName", null, component);
        String formName = (String)this.valueForBinding("formName", component);
        boolean showUI = functionName == null || this.booleanValueForBinding("showUI", false, component);
        boolean bl = showButton = showUI && this.booleanValueForBinding("button", true, component);
        if (!(showButton && functionName == null || formName != null || (formName = ERXWOForm.formName((WOContext)context, null)) != null)) {
            throw new WODynamicElementCreationException("If button = false or functionName is not null, the containing form must have an explicit name.");
        }
        String formReference = formName == null ? "this.form" : "document." + formName;
        StringBuffer onClickBuffer = new StringBuffer();
        String onClickBefore = (String)this.valueForBinding("onClickBefore", component);
        if (onClickBefore != null) {
            onClickBuffer.append("if (");
            onClickBuffer.append(onClickBefore);
            onClickBuffer.append(") {");
        }
        String updateContainerID = AjaxUpdateContainer.updateContainerID(this, component);
        String beforeEffect = (String)this.valueForBinding("beforeEffect", component);
        if (beforeEffect != null) {
            onClickBuffer.append("new ");
            onClickBuffer.append(AjaxUpdateLink.fullEffectName(beforeEffect));
            onClickBuffer.append("('");
            String beforeEffectID = (String)this.valueForBinding("beforeEffectID", component);
            if (beforeEffectID == null && (beforeEffectID = AjaxUpdateContainer.currentUpdateContainerID()) == null) {
                beforeEffectID = updateContainerID;
            }
            onClickBuffer.append(beforeEffectID);
            onClickBuffer.append("', { ");
            String beforeEffectDuration = (String)this.valueForBinding("beforeEffectDuration", component);
            if (beforeEffectDuration != null) {
                onClickBuffer.append("duration: ");
                onClickBuffer.append(beforeEffectDuration);
                onClickBuffer.append(", ");
            }
            onClickBuffer.append("queue:'end', afterFinish: function() {");
        }
        String replaceID = (String)this.valueForBinding("replaceID", component);
        String string = id = updateContainerID == null ? replaceID : updateContainerID;
        if (id != null) {
            onClickBuffer.append("ASB.update('" + id + "',");
        } else {
            onClickBuffer.append("ASB.request(");
        }
        onClickBuffer.append(formReference);
        if (this.valueForBinding("functionName", component) != null) {
            onClickBuffer.append(",additionalParams");
        } else {
            onClickBuffer.append(",null");
        }
        onClickBuffer.append(",");
        NSMutableDictionary options = this.createAjaxOptions(component);
        if (replaceID != null) {
            options.setObjectForKey((Object)"true", (Object)"_r");
        }
        AjaxUpdateLink.addEffect(options, (String)this.valueForBinding("effect", component), id, (String)this.valueForBinding("effectDuration", component));
        String afterEffectID = (String)this.valueForBinding("afterEffectID", component);
        if (afterEffectID == null && (afterEffectID = AjaxUpdateContainer.currentUpdateContainerID()) == null) {
            afterEffectID = id;
        }
        AjaxUpdateLink.addEffect(options, (String)this.valueForBinding("afterEffect", component), afterEffectID, (String)this.valueForBinding("afterEffectDuration", component));
        AjaxOptions.appendToBuffer((NSDictionary)options, onClickBuffer, context);
        onClickBuffer.append(")");
        String onClick = (String)this.valueForBinding("onClick", component);
        if (onClick != null) {
            onClickBuffer.append(";");
            onClickBuffer.append(onClick);
        }
        if (beforeEffect != null) {
            onClickBuffer.append("}});");
        }
        if (onClickBefore != null) {
            onClickBuffer.append("}");
        }
        if (functionName != null) {
            AjaxUtils.appendScriptHeader(response);
            response.appendContentString(functionName + " = function(additionalParams) { " + onClickBuffer + " }\n");
            AjaxUtils.appendScriptFooter(response);
        }
        if (showUI) {
            boolean disabled = this.disabledInComponent(component);
            String elementName = (String)this.valueForBinding("elementName", "a", component);
            boolean useButtonTag = ERXProperties.booleanForKeyWithDefault((String)"er.extensions.foundation.ERXPatcher.DynamicElementsPatches.SubmitButton.useButtonTag", (boolean)false);
            if (showButton) {
                elementName = useButtonTag ? "button" : "input";
                response.appendContentString("<" + elementName + " ");
                this.appendTagAttributeToResponse(response, "type", "button");
                String name = this.nameInContext(context, component);
                this.appendTagAttributeToResponse(response, "name", name);
                this.appendTagAttributeToResponse(response, "value", this.valueForBinding("value", component));
                this.appendTagAttributeToResponse(response, "accesskey", this.valueForBinding("accesskey", component));
                if (disabled) {
                    this.appendTagAttributeToResponse(response, "disabled", "disabled");
                }
            } else {
                boolean isATag = "a".equalsIgnoreCase(elementName);
                if (isATag) {
                    response.appendContentString("<a href = \"javascript:void(0)\" ");
                } else {
                    response.appendContentString("<" + elementName + " ");
                }
            }
            this.appendTagAttributeToResponse(response, "class", this.valueForBinding("class", component));
            this.appendTagAttributeToResponse(response, "style", this.valueForBinding("style", component));
            this.appendTagAttributeToResponse(response, "id", this.valueForBinding("id", component));
            this.appendTagAttributeToResponse(response, "title", this.valueForBinding("title", component));
            if (functionName == null) {
                this.appendTagAttributeToResponse(response, "onclick", onClickBuffer.toString());
            } else {
                this.appendTagAttributeToResponse(response, "onclick", functionName + "()");
            }
            if (showButton && !useButtonTag) {
                response.appendContentString(" />");
            } else {
                response.appendContentString(">");
                if (this.hasChildrenElements()) {
                    this.appendChildrenToResponse(response, context);
                } else {
                    response.appendContentString((String)this.valueForBinding("value", component));
                }
                response.appendContentString("</" + elementName + ">");
            }
        }
        super.appendToResponse(response, context);
    }

    protected void addRequiredWebResources(WOResponse res, WOContext context) {
        this.addScriptResourceInHead(context, res, "prototype.js");
        this.addScriptResourceInHead(context, res, "effects.js");
        this.addScriptResourceInHead(context, res, "wonder.js");
    }

    public WOActionResults invokeAction(WORequest worequest, WOContext wocontext) {
        boolean shouldHandleRequest;
        WOActionResults result = null;
        WOComponent wocomponent = wocontext.component();
        String nameInContext = this.nameInContext(wocontext, wocomponent);
        boolean bl = shouldHandleRequest = !this.disabledInComponent(wocomponent) && wocontext._wasFormSubmitted() && (wocontext._isMultipleSubmitForm() && nameInContext.equals(worequest.formValueForKey(KEY_AJAX_SUBMIT_BUTTON_NAME)) || !wocontext._isMultipleSubmitForm());
        if (shouldHandleRequest) {
            String updateContainerID = AjaxUpdateContainer.updateContainerID(this, wocomponent);
            AjaxUpdateContainer.setUpdateContainerID(worequest, updateContainerID);
            wocontext._setActionInvoked(true);
            result = this.handleRequest(worequest, wocontext);
            AjaxUtils.updateMutableUserInfoWithAjaxInfo(wocontext);
        }
        return result;
    }

    public WOActionResults handleRequest(WORequest request, WOContext context) {
        WOComponent component = context.component();
        Object result = (WOActionResults)this.valueForBinding("action", component);
        if (ERXAjaxApplication.isAjaxReplacement((WORequest)request)) {
            AjaxUtils.setPageReplacementCacheKey(context, (String)this.valueForBinding("replaceID", component));
        } else if (result == null || this.booleanValueForBinding("ignoreActionResponse", false, component)) {
            AjaxResponse response = AjaxUtils.createResponse(request, context);
            String onClickServer = (String)this.valueForBinding("onClickServer", component);
            if (onClickServer != null) {
                AjaxUtils.appendScriptHeaderIfNecessary(request, (WOResponse)response);
                response.appendContentString(onClickServer);
                AjaxUtils.appendScriptFooterIfNecessary(request, (WOResponse)response);
            }
            result = response;
        } else {
            String updateContainerID = AjaxUpdateContainer.updateContainerID(this, component);
            if (updateContainerID != null) {
                AjaxUtils.setPageReplacementCacheKey(context, updateContainerID);
            }
        }
        return result;
    }
}

