/*
 * Decompiled with CFR 0.152.
 */
package er.ajax;

import com.webobjects.appserver.WOAssociation;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOElement;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSDictionary;
import er.ajax.AjaxUtils;
import er.extensions.appserver.ERXWOContext;
import er.extensions.components._private.ERXWOTextField;

public class FocusTextField
extends ERXWOTextField {
    protected WOAssociation _id;
    protected WOAssociation _selectAll;
    protected WOAssociation _focus;
    protected WOAssociation _onEnter;
    protected WOAssociation _onKeyPress;

    public FocusTextField(String tagname, NSDictionary nsdictionary, WOElement woelement) {
        super(tagname, nsdictionary, woelement);
        this._id = (WOAssociation)nsdictionary.valueForKey("id");
        this._selectAll = (WOAssociation)this._associations.removeObjectForKey((Object)"selectAll");
        this._focus = (WOAssociation)this._associations.removeObjectForKey((Object)"focus");
        this._onEnter = (WOAssociation)this._associations.removeObjectForKey((Object)"onEnter");
        this._onKeyPress = (WOAssociation)this._associations.removeObjectForKey((Object)"onkeypress");
    }

    public String id(WOComponent component, WOContext context) {
        String id = null;
        if (this._id != null) {
            id = (String)this._id.valueInComponent(component);
        }
        if (id == null) {
            id = ERXWOContext.safeIdentifierName((WOContext)context, (boolean)false);
        }
        return id;
    }

    public void appendToResponse(WOResponse response, WOContext context) {
        AjaxUtils.addScriptResourceInHead(context, response, "prototype.js");
        super.appendToResponse(response, context);
        WOComponent component = context.component();
        boolean focus = this._focus == null || this._focus.booleanValueInComponent(component);
        boolean selectAll = this._selectAll != null && this._selectAll.booleanValueInComponent(component);
        String id = this.id(component, context);
        String onEnterScript = this._onEnter != null ? (String)this._onEnter.valueInComponent(component) : null;
        FocusTextField.appendJavascriptToResponse(response, context, id, focus, selectAll, onEnterScript);
    }

    protected void _appendAttributesFromAssociationsToResponse(WOResponse response, WOContext wocontext, NSDictionary nsdictionary) {
        super._appendAttributesFromAssociationsToResponse(response, wocontext, nsdictionary);
        WOComponent component = wocontext.component();
        String onKeyPress = this._onKeyPress != null ? (String)this._onKeyPress.valueInComponent(component) : null;
        String onEnterScript = this._onEnter != null ? (String)this._onEnter.valueInComponent(component) : null;
        String id = this.id(component, wocontext);
        if (this._id == null) {
            response.appendContentString(" id = \"" + id + "\"");
        }
        FocusTextField._appendAttributesFromAssociationsToResponse(response, wocontext, id, onKeyPress, onEnterScript);
    }

    public static void _appendAttributesFromAssociationsToResponse(WOResponse response, WOContext wocontext, String id, String onKeyPress, String onEnterScript) {
        WOComponent component = wocontext.component();
        if (onKeyPress != null || onEnterScript != null) {
            response.appendContentString(" onkeypress = \"");
            if (onKeyPress != null) {
                response.appendContentString(onKeyPress);
            }
            if (onEnterScript != null) {
                if (onKeyPress != null) {
                    response.appendContentString("; ");
                }
                response.appendContentString(id + "SubmitOnEnter(event);");
            }
            response.appendContentString("\"");
        }
    }

    public static void appendJavascriptToResponse(WOResponse response, WOContext context, String id, boolean focus, boolean selectAll, String onEnterScript) {
        WOComponent component = context.component();
        AjaxUtils.appendScriptHeader(response);
        if (focus || selectAll) {
            response.appendContentString("setTimeout(function() { ");
        }
        if (selectAll) {
            response.appendContentString("Field.select('" + id + "');");
        }
        if (focus) {
            response.appendContentString("Field.focus('" + id + "');");
        }
        if (focus || selectAll) {
            response.appendContentString(" }, 10);");
        }
        if (onEnterScript != null) {
            response.appendContentString(id + "SubmitOnEnter = function(e) { var keynum = Event.keyValue(e); if (keynum == 13 || keynum == 3) { ");
            response.appendContentString(onEnterScript);
            response.appendContentString("; Event.stop(e); } }");
        }
        AjaxUtils.appendScriptFooter(response);
    }
}

