/*
 * Decompiled with CFR 0.152.
 */
package er.ajax.look.components;

import com.webobjects.appserver.WOContext;
import com.webobjects.directtoweb.D2WContext;
import com.webobjects.eocontrol.EOKeyValueCodingAdditions;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSSelector;
import er.ajax.look.interfaces.PropertyChangedDelegate;
import er.directtoweb.components.ERDCustomComponent;
import er.extensions.appserver.ERXWOContext;
import er.extensions.eof.ERXConstant;
import er.extensions.eof.ERXKey;
import er.extensions.foundation.ERXArrayUtilities;
import er.extensions.foundation.ERXStringUtilities;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxNotificationCenter
extends ERDCustomComponent {
    public static final ERXKey<String> AJAX_NOTIFICATION_CENTER_ID = new ERXKey("ajaxNotificationCenterID");
    public static final ERXKey<String> PROPERTY_OBSERVER_ID = new ERXKey("propertyObserverID");
    public static final ERXKey<String> PROPERTY_KEY = new ERXKey("propertyKey");
    public static final ERXKey<PropertyChangedDelegate> PROPERTY_CHANGED_DELEGATE = new ERXKey("propertyChangedDelegate");
    public static final String PropertyChangedNotification = "PropertyChangedNotification";
    public static final String RegisterPropertyObserverIDNotification = "RegisterPropertyObserverIDNotification";
    private static final NSSelector propertyChanged = new NSSelector("propertyChanged", ERXConstant.NotificationClassArray);
    private static final NSSelector registerPropertyObserverID = new NSSelector("registerPropertyObserverID", ERXConstant.NotificationClassArray);
    private String id;
    private NSMutableDictionary<String, String> propertyObserverIDs = new NSMutableDictionary();
    private NSMutableArray<String> updateContainerIDs = new NSMutableArray();
    private static final Logger log = Logger.getLogger(AjaxNotificationCenter.class);

    public String id() {
        if (this.id == null) {
            this.id = ERXWOContext.safeIdentifierName((WOContext)this.context(), (boolean)true);
            AJAX_NOTIFICATION_CENTER_ID.takeValueInObject((Object)this.id, (Object)this.d2wContext());
        }
        return this.id;
    }

    public AjaxNotificationCenter(WOContext context) {
        super(context);
    }

    public void setD2wContext(D2WContext context) {
        if (context != null && !context.equals(this.d2wContext())) {
            log.debug((Object)"Removing observers for old context");
            NSNotificationCenter.defaultCenter().removeObserver((Object)this, PropertyChangedNotification, null);
            NSNotificationCenter.defaultCenter().removeObserver((Object)this, RegisterPropertyObserverIDNotification, null);
        }
        NSNotificationCenter.defaultCenter().addObserver((Object)this, propertyChanged, PropertyChangedNotification, (Object)context);
        NSNotificationCenter.defaultCenter().addObserver((Object)this, registerPropertyObserverID, RegisterPropertyObserverIDNotification, (Object)context);
        log.debug((Object)("Notifications registered for context: " + context));
        super.setD2wContext(context);
    }

    public NSMutableArray<String> updateContainerIDs() {
        log.debug((Object)("Updating container IDs: " + this.updateContainerIDs.componentsJoinedByString(", ")));
        return this.updateContainerIDs;
    }

    public void propertyChanged(NSNotification n) {
        log.debug((Object)("Property changed for property key: " + (String)PROPERTY_KEY.valueInObject(n.object())));
        PropertyChangedDelegate delegate = (PropertyChangedDelegate)PROPERTY_CHANGED_DELEGATE.valueInObject(n.object());
        if (delegate != null) {
            log.debug((Object)"Updating container id list with propertyChangedDelegate");
            NSArray<String> updateProps = delegate.propertyChanged((D2WContext)n.object());
            NSArray updateIDs = EOKeyValueCodingAdditions.Utility.valuesForKeys(this.propertyObserverIDs, updateProps).allValues();
            updateIDs = ERXArrayUtilities.removeNullValues((NSArray)updateIDs);
            this.updateContainerIDs.addObjectsFromArray(updateIDs);
            log.debug((Object)("Container ids to be updated: " + this.updateContainerIDs.componentsJoinedByString(", ")));
        }
    }

    public void registerPropertyObserverID(NSNotification n) {
        String propKey = (String)PROPERTY_KEY.valueInObject(n.object());
        String propID = (String)PROPERTY_OBSERVER_ID.valueInObject(n.object());
        if (!ERXStringUtilities.stringIsNullOrEmpty((String)propKey) && !ERXStringUtilities.stringIsNullOrEmpty((String)propID)) {
            this.propertyObserverIDs.setObjectForKey((Object)propID, (Object)propKey);
            log.debug((Object)("ID registered for property: (" + propKey + ", " + propID + ")"));
        }
    }

    public Object handleQueryWithUnboundKey(String key) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Handling unbound key: " + key));
        }
        return this.dynamicBindings().objectForKey((Object)key);
    }

    public void handleTakeValueForUnboundKey(Object value, String key) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Take value: " + value + " for unbound key: " + key));
        }
        this.dynamicBindings().setObjectForKey(value, (Object)key);
    }
}

