/*
 * Decompiled with CFR 0.152.
 */
package er.grouping;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation.NSTimestampFormatter;
import er.grouping.DRMasterCriteria;
import er.grouping.DRSubMasterCriteria;
import er.grouping.DRValueConverter;
import java.text.Format;
import org.apache.log4j.Logger;

public class DRCriteria {
    private static final Logger log = Logger.getLogger(DRCriteria.class);
    protected NSDictionary _valueDict;
    protected DRMasterCriteria _masterCriteria;
    protected String _label = null;
    public static final double MAXNUMBER = 9.9999999999E10;
    public static final String MAXSTRING = "zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz";
    public static String _defaultCalendarFormatString = "%m/%d/%Y";
    protected boolean _isTotal = false;
    protected boolean _isOther = false;
    protected Object _score = null;
    private String _keyDesc = null;
    private static NSMutableDictionary _calFormatDict = new NSMutableDictionary();

    public boolean isTotal() {
        return this._isTotal;
    }

    public void setIsTotal(boolean v) {
        this._isTotal = v;
    }

    public boolean isOther() {
        return this._isOther;
    }

    public void setIsOther(boolean v) {
        this._isOther = v;
    }

    public static DRCriteria asOtherWithMasterCriteria(DRMasterCriteria mc) {
        DRCriteria aVal = new DRCriteria();
        String lb = (String)mc.userInfo().objectForKey((Object)"OTHER_LABEL");
        aVal.setMasterCriteria(mc);
        NSArray subMcs = aVal.masterCriteria().subCriteriaList();
        DRSubMasterCriteria smc = (DRSubMasterCriteria)subMcs.objectAtIndex(0);
        aVal.setValueDict(new NSDictionary(new Object[]{"*", "|Other|", "OTHER"}, new Object[]{"OTHER", "lookupKey", smc.keyDesc()}));
        if (lb != null) {
            aVal.setLabel(lb);
        } else {
            aVal.setLabel("Other");
        }
        aVal.setIsTotal(false);
        aVal.setIsOther(true);
        return aVal;
    }

    public static DRCriteria asTotalWithMasterCriteria(DRMasterCriteria mc) {
        DRCriteria aVal = new DRCriteria();
        String lb = (String)mc.userInfo().objectForKey((Object)"TOTAL_LABEL");
        aVal.setMasterCriteria(mc);
        NSArray subMcs = aVal.masterCriteria().subCriteriaList();
        DRSubMasterCriteria smc = (DRSubMasterCriteria)subMcs.objectAtIndex(0);
        aVal.setValueDict(new NSDictionary(new Object[]{"*", "|Total|", "TOTAL"}, new Object[]{"TOTAL", "lookupKey", smc.keyDesc()}));
        if (lb != null) {
            aVal.setLabel(lb);
        } else {
            aVal.setLabel("Total");
        }
        aVal.setIsTotal(true);
        return aVal;
    }

    public static DRCriteria withMasterCriteriaValueDict(DRMasterCriteria mc, NSDictionary valD) {
        DRCriteria aVal = new DRCriteria();
        aVal.setMasterCriteria(mc);
        aVal.setValueDict(valD);
        return aVal;
    }

    public void setMasterCriteria(DRMasterCriteria val) {
        this._masterCriteria = val;
    }

    public DRMasterCriteria masterCriteria() {
        return this._masterCriteria;
    }

    public void setValueDict(NSDictionary val) {
        this._valueDict = val;
    }

    public NSDictionary valueDict() {
        return this._valueDict;
    }

    public String toString() {
        return "<DRCriteria valueDict: " + this._valueDict + "; >";
    }

    public String keyDesc() {
        if (this._keyDesc == null) {
            this._keyDesc = super.toString();
        }
        return this._keyDesc;
    }

    public String calendarFormatForDates() {
        NSMutableDictionary info = this._masterCriteria.userInfo();
        String v = (String)info.objectForKey((Object)"calendarFormat");
        if (v != null) {
            return v;
        }
        return _defaultCalendarFormatString;
    }

    public String rangeSeparator() {
        NSMutableDictionary info = this._masterCriteria.userInfo();
        String v = (String)info.objectForKey((Object)"rangeSeparator");
        if (v != null) {
            return v;
        }
        return " to ";
    }

    public String compoundSeparator() {
        NSMutableDictionary info = this._masterCriteria.userInfo();
        String calFrmt = (String)info.objectForKey((Object)"compoundSeparator");
        if (calFrmt != null) {
            return calFrmt;
        }
        return "|";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Format formatterForFormat(String calFormat) {
        NSMutableDictionary nSMutableDictionary = _calFormatDict;
        synchronized (nSMutableDictionary) {
            NSTimestampFormatter v;
            if (calFormat == null) {
                calFormat = _defaultCalendarFormatString;
            }
            if ((v = (NSTimestampFormatter)_calFormatDict.objectForKey((Object)calFormat)) == null) {
                v = new NSTimestampFormatter(calFormat);
                DRCriteria.setFormatterForFormat((Format)v, calFormat);
            }
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setFormatterForFormat(Format formatter, String calFormat) {
        NSMutableDictionary nSMutableDictionary = _calFormatDict;
        synchronized (nSMutableDictionary) {
            _calFormatDict.setObjectForKey((Object)formatter, (Object)calFormat);
        }
    }

    public String labelForDict(NSDictionary dict) {
        String lbl = "";
        Object high = dict.objectForKey((Object)"H");
        Object low = dict.objectForKey((Object)"L");
        String calFormat = this.calendarFormatForDates();
        Format formatter = DRCriteria.formatterForFormat(calFormat);
        String highString = high instanceof NSTimestamp ? formatter.format(high) : high.toString();
        String lowString = low instanceof NSTimestamp ? formatter.format(low) : low.toString();
        lbl = lbl + lowString + this.rangeSeparator() + highString;
        return lbl;
    }

    public String label() {
        if (this._label == null) {
            NSArray subMcs = this._masterCriteria.subCriteriaList();
            int cnt = subMcs.count();
            String lbl = "";
            for (int i = 0; i < cnt; ++i) {
                DRSubMasterCriteria smc = (DRSubMasterCriteria)subMcs.objectAtIndex(i);
                Object rawVal = this._valueDict.objectForKey((Object)smc.keyDesc());
                lbl = rawVal instanceof NSDictionary ? lbl.concat(this.labelForDict((NSDictionary)rawVal)) : lbl.concat(smc.lookUpKeyForValue(rawVal));
                if (i == cnt - 1) continue;
                lbl = lbl.concat(this.compoundSeparator());
            }
            this._label = lbl;
        }
        return this._label;
    }

    public void setLabel(String lbl) {
        this._label = lbl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object score() {
        if (this._score == null) {
            DRCriteria dRCriteria = this;
            synchronized (dRCriteria) {
                Object scr;
                block15: {
                    scr = null;
                    NSArray subMcs = this._masterCriteria.subCriteriaList();
                    DRSubMasterCriteria smc = (DRSubMasterCriteria)subMcs.objectAtIndex(0);
                    Object rawVal = this._valueDict.objectForKey((Object)smc.keyDesc());
                    if (this._valueDict.objectForKey((Object)"OTHER") != null) {
                        scr = subMcs.count() > 1 || this._masterCriteria.isString() ? MAXSTRING : new Double(1.0E11);
                    } else if (this._valueDict.objectForKey((Object)"TOTAL") != null) {
                        scr = subMcs.count() > 1 || this._masterCriteria.isString() ? MAXSTRING.concat("z") : new Double(1.00000000001E11);
                    } else if (subMcs.count() > 1) {
                        scr = this.label().toLowerCase();
                    } else if (rawVal instanceof NSDictionary) {
                        Object v = ((NSDictionary)rawVal).objectForKey((Object)"L");
                        try {
                            if (v instanceof String) {
                                scr = new Double((String)v);
                                break block15;
                            }
                            scr = DRValueConverter.converter().numberForValue(v);
                        }
                        catch (NumberFormatException e) {
                            scr = new Double(-9.9999999999E10);
                        }
                    } else {
                        scr = rawVal instanceof String ? ((String)rawVal).toLowerCase() : DRValueConverter.converter().numberForValue(rawVal);
                    }
                }
                this._score = scr;
            }
        }
        return this._score;
    }
}

