/*
 * Decompiled with CFR 0.152.
 */
package er.grouping;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import com.webobjects.foundation.NSMutableArray;
import er.grouping.DRAttribute;
import er.grouping.DRReportModel;
import er.grouping.DRValue;
import er.grouping.DRValueGroup;
import java.util.Enumeration;

public class DRRecord {
    protected NSKeyValueCodingAdditions _rawRecord;
    protected DRReportModel _model;
    protected NSMutableArray _valueList;
    protected NSMutableArray _flatValueList;

    public static DRRecord withRawRecordModel(NSKeyValueCodingAdditions rawr, DRReportModel aMod) {
        DRRecord drr = new DRRecord();
        drr.initWithRawRecord(rawr, aMod);
        return drr;
    }

    public void populateValueList() {
        this._valueList.removeAllObjects();
        this._flatValueList.removeAllObjects();
        if (this.attributeList() != null) {
            Enumeration anEnum = this.attributeList().objectEnumerator();
            while (anEnum.hasMoreElements()) {
                DRAttribute att = (DRAttribute)anEnum.nextElement();
                DRValue val = this.valueForAttributeRecord(att, this);
                this._valueList.addObject((Object)val);
            }
        }
    }

    public DRValue valueForAttributeRecord(DRAttribute att, DRRecord rec) {
        DRValue vl;
        if (!att.isGroup()) {
            vl = DRValue.withRecordAttribute(rec, att);
            this._flatValueList.addObject((Object)vl);
        } else {
            vl = DRValueGroup.withRecordAttribute(rec, att);
            NSArray subvls = vl.flatValues();
            this._flatValueList.addObjectsFromArray(subvls);
        }
        return vl;
    }

    public DRRecord initWithRawRecord(NSKeyValueCodingAdditions rawr, DRReportModel aMod) {
        this._rawRecord = rawr;
        this._model = aMod;
        this._valueList = new NSMutableArray();
        this._flatValueList = new NSMutableArray();
        this.populateValueList();
        return this;
    }

    public NSKeyValueCodingAdditions rawRecord() {
        return this._rawRecord;
    }

    public Object valueForKey(String key) {
        return NSKeyValueCoding.DefaultImplementation.valueForKey((Object)this._rawRecord, (String)key);
    }

    public NSArray valueList() {
        return this._valueList;
    }

    public NSArray flatValueList() {
        return this._flatValueList;
    }

    public DRReportModel model() {
        return this._model;
    }

    public NSArray attributeList() {
        return this.model().attributeList();
    }
}

