/*
 * Decompiled with CFR 0.152.
 */
package er.grouping;

import com.webobjects.eocontrol.EOSortOrdering;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import er.grouping.DRCriteria;
import er.grouping.DRGroup;
import er.grouping.DRMasterCriteria;
import er.grouping.DRRecord;
import er.grouping.DRValue;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public class DRRecordGroup {
    private Logger log = Logger.getLogger(DRRecordGroup.class);
    protected DRCriteria _criteria;
    protected DRGroup _group;
    protected NSMutableDictionary _totals = new NSMutableDictionary();
    protected NSMutableDictionary _totalsByKey;
    protected NSMutableArray _recordList = new NSMutableArray();
    protected NSMutableDictionary _recordGroupDict = new NSMutableDictionary();
    protected DRRecordGroup _parent;
    protected boolean _staleTotal = true;
    protected boolean _pregroupedListFound = false;
    protected NSMutableDictionary _lookUpCoordinates;
    protected NSArray _totalList;
    protected NSArray _sortedRecordList = null;
    protected NSArray _rawRecordList;

    public static DRRecordGroup withCriteriaGroupParent(DRCriteria c, DRGroup grp, DRRecordGroup recGrp) {
        DRRecordGroup aVal = new DRRecordGroup();
        aVal.initWithCriteria(c, grp, recGrp);
        return aVal;
    }

    private void coordsFromRecGroupDictionary(DRRecordGroup prnt, NSMutableDictionary dict) {
        DRRecordGroup nextParent = prnt.parent();
        DRCriteria crit = prnt.criteria();
        dict.setObjectForKey((Object)crit, (Object)crit.masterCriteria().keyDesc());
        if (nextParent != null) {
            this.coordsFromRecGroupDictionary(nextParent, dict);
        }
    }

    private NSMutableDictionary buildLookUpCoordinates() {
        NSMutableDictionary dict = new NSMutableDictionary();
        if (this._criteria == null) {
            return dict;
        }
        if (this._parent != null) {
            this.coordsFromRecGroupDictionary(this._parent, dict);
        }
        dict.setObjectForKey((Object)this._criteria, (Object)this._criteria.masterCriteria().keyDesc());
        return dict;
    }

    public DRRecordGroup initWithCriteria(DRCriteria c, DRGroup grp, DRRecordGroup recGrp) {
        this._criteria = c;
        this._group = grp;
        this._parent = recGrp;
        this._lookUpCoordinates = this.buildLookUpCoordinates();
        DRRecordGroup preexistrg = null;
        if (this._group != null) {
            preexistrg = this._group.reportModel().recordGroupForCoordinates((NSDictionary)this._lookUpCoordinates);
            if (preexistrg != null) {
                this._recordList = preexistrg.recordList();
                this._pregroupedListFound = true;
            } else {
                this._group.reportModel().registerRecordGroupWithCoordinates(this, (NSDictionary)this._lookUpCoordinates);
            }
        }
        return this;
    }

    public DRRecordGroup() {
        this._totalsByKey = new NSMutableDictionary();
    }

    public NSMutableDictionary recordGroupDict() {
        return this._recordGroupDict;
    }

    public DRCriteria criteria() {
        return this._criteria;
    }

    public DRGroup group() {
        return this._group;
    }

    public DRValue totalForKey(String totalKey) {
        DRValue value = (DRValue)this._totalsByKey.objectForKey((Object)totalKey);
        return value;
    }

    public NSDictionary totals() {
        if (this._staleTotal) {
            Enumeration en = this.recordList().objectEnumerator();
            while (en.hasMoreElements()) {
                int i = 0;
                DRRecord rec = (DRRecord)en.nextElement();
                NSArray flatlist = rec.flatValueList();
                Enumeration en2 = flatlist.objectEnumerator();
                while (en2.hasMoreElements()) {
                    DRValue val = (DRValue)en2.nextElement();
                    boolean isComputed = val.attribute().isComputed();
                    Integer indexNum = new Integer(i);
                    DRValue totalValue = (DRValue)this._totals.objectForKey((Object)indexNum);
                    if (totalValue == null) {
                        if (val.shouldTotal()) {
                            if (!isComputed) {
                                totalValue = DRValue.withTotalAttribute(0.0, val.attribute());
                            } else {
                                final NSArray rawRecords = this.rawRecordList();
                                totalValue = new DRValue(0.0, val.attribute()){
                                    private Double total;

                                    public double total() {
                                        if (this.total == null) {
                                            this.total = new Double(this.attribute().computeFromRawRecords(rawRecords));
                                        }
                                        return this.total;
                                    }
                                };
                            }
                            this._totalsByKey.setObjectForKey((Object)totalValue, (Object)totalValue.key());
                        } else {
                            totalValue = DRValue.nullTotal();
                        }
                        this._totals.setObjectForKey((Object)totalValue, (Object)indexNum);
                    }
                    if (!isComputed) {
                        double lastTot = totalValue.total();
                        double subTot = val.total();
                        double newTot = lastTot + subTot;
                        totalValue.setTotal(newTot);
                    }
                    ++i;
                }
            }
            this._staleTotal = false;
        }
        return this._totals;
    }

    public NSArray totalList() {
        if (this._totalList == null) {
            int cnt = this.totals().allKeys().count();
            NSMutableArray totList = new NSMutableArray();
            for (int i = 0; i < cnt; ++i) {
                totList.addObject(this.totals().objectForKey((Object)new Integer(i)));
            }
            this._totalList = new NSArray((NSArray)totList);
        }
        return this._totalList;
    }

    public NSArray sortedRecordList() {
        if (this._sortedRecordList == null) {
            NSArray ords = null;
            if (this._group != null) {
                ords = this._group.reportModel().orderings();
            }
            this._sortedRecordList = EOSortOrdering.sortedArrayUsingKeyOrderArray((NSArray)this._recordList, (NSArray)ords);
        }
        return this._sortedRecordList;
    }

    public NSArray rawRecordList() {
        if (this._rawRecordList == null) {
            NSMutableArray rawRecs = new NSMutableArray();
            NSArray recs = this.sortedRecordList();
            Enumeration en = recs.objectEnumerator();
            while (en.hasMoreElements()) {
                DRRecord rec = (DRRecord)en.nextElement();
                NSKeyValueCodingAdditions rawRec = rec.rawRecord();
                rawRecs.addObject((Object)rawRec);
            }
            this._rawRecordList = new NSArray((NSArray)rawRecs);
        }
        return this._rawRecordList;
    }

    public NSMutableArray recordList() {
        return this._recordList;
    }

    public boolean pregroupedListFound() {
        return this._pregroupedListFound;
    }

    public NSDictionary lookUpCoordinates() {
        return this._lookUpCoordinates;
    }

    public NSArray children() {
        return this._recordGroupDict.allValues();
    }

    public DRRecordGroup parent() {
        return this._parent;
    }

    public boolean childrenFromGroupCriteriaList(DRGroup grp) {
        boolean listFound = false;
        NSArray crits = grp.criteriaList();
        Enumeration anEnum = crits.objectEnumerator();
        while (anEnum.hasMoreElements()) {
            DRCriteria crit = (DRCriteria)anEnum.nextElement();
            DRRecordGroup recGrp = DRRecordGroup.withCriteriaGroupParent(crit, grp, this);
            listFound = recGrp.pregroupedListFound();
            this._recordGroupDict.setObjectForKey((Object)recGrp, (Object)crit.keyDesc());
        }
        return listFound;
    }

    public void groupSubRecordGroupGroupLookUpDict(NSArray groupList, NSDictionary groupLookUpDict) {
        int cnt = groupList.count();
        if (cnt > 0) {
            DRMasterCriteria mc = (DRMasterCriteria)groupList.objectAtIndex(0);
            DRGroup grp = (DRGroup)groupLookUpDict.objectForKey((Object)mc.keyDesc());
            if (!this.childrenFromGroupCriteriaList(grp)) {
                this.groupByInto(this.recordList(), grp.masterCriteria(), this.recordGroupDict());
            }
            Enumeration anEnum = this.children().objectEnumerator();
            while (anEnum.hasMoreElements()) {
                DRRecordGroup rg = (DRRecordGroup)anEnum.nextElement();
                NSMutableArray arr = new NSMutableArray(groupList);
                arr.removeObjectAtIndex(0);
                rg.groupSubRecordGroupGroupLookUpDict((NSArray)arr, groupLookUpDict);
            }
        }
    }

    public void groupByInto(NSMutableArray recs, DRMasterCriteria amc, NSMutableDictionary recGrpDict) {
        Enumeration anEnum = recs.objectEnumerator();
        while (anEnum.hasMoreElements()) {
            DRRecord rec = (DRRecord)anEnum.nextElement();
            amc.groupRecordRecordGroupsDictGroupParent(rec, recGrpDict, this.group(), this);
        }
    }

    public String toString() {
        return "" + super.toString() + "-lc:" + this._lookUpCoordinates + "-" + this.recordList().count() + "-" + this._recordGroupDict.toString();
    }

    public boolean staleTotal() {
        return this._staleTotal;
    }

    public void makeStale() {
        this._staleTotal = true;
        this._totals.removeAllObjects();
        this._totalList = null;
    }
}

