/*
 * Decompiled with CFR 0.152.
 */
package er.grouping;

import com.webobjects.appserver.xml.WOXMLCoder;
import com.webobjects.appserver.xml.WOXMLDecoder;
import com.webobjects.eocontrol.EOSortOrdering;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSPropertyListSerialization;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation._NSStringUtilities;
import er.extensions.eof.ERXConstant;
import er.extensions.foundation.ERXStringUtilities;
import er.extensions.foundation.ERXValueUtilities;
import er.grouping.DRAttribute;
import er.grouping.DRAttributeGroup;
import er.grouping.DRCriteria;
import er.grouping.DRGroup;
import er.grouping.DRMasterCriteria;
import er.grouping.DRRecord;
import er.grouping.DRRecordGroup;
import er.grouping.DRSubMasterCriteria;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.Enumeration;
import org.apache.log4j.Logger;
import org.xml.sax.InputSource;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class DRReportModel {
    private static Logger log = Logger.getLogger(DRReportModel.class);
    public static final String DRReportModelUpdateNotification = "DRReportModelUpdate";
    public static final String DRReportModelRebuildNotification = "DRReportModelRebuild";
    public static final String GROUP_DEF_KEY = "GroupDef";
    public static final String ATTRIBUTE_DEF_KEY = "AttributeDef";
    protected NSMutableArray _vList;
    protected NSMutableArray _hList;
    protected NSMutableArray _zList;
    protected NSArray _records;
    protected NSArray _groups;
    protected NSDictionary _groupDict;
    protected NSArray _rawRecords;
    protected NSArray _attributeList;
    protected NSArray _criteriaList;
    protected NSMutableDictionary _registeredRecordGroups;
    protected NSMutableDictionary _flatAttributeDepthDict;
    protected NSMutableArray _flatAttributeList;
    protected NSMutableArray _flatAttributeListTotal;
    protected NSMutableDictionary _flatAttributeListTotalDict;
    protected int _attributeListDepth;
    protected NSArray _orderings;

    public void resetDefaults() {
    }

    public NSArray orderings() {
        return this._orderings;
    }

    public void setOrderings(NSArray v) {
        this._orderings = v;
    }

    public void buildOrderings() {
        NSMutableArray arr = new NSMutableArray();
        if (this.attributeList() != null) {
            Enumeration en = this.attributeList().objectEnumerator();
            while (en.hasMoreElements()) {
                DRAttribute att = (DRAttribute)en.nextElement();
                if (att.isGroup() || !att.shouldSort()) continue;
                String attName = att.keyPath();
                EOSortOrdering ord = new EOSortOrdering(attName, EOSortOrdering.CompareAscending);
                arr.addObject((Object)ord);
            }
        }
        this.setOrderings((NSArray)arr);
    }

    public static NSArray masterCriteriaForKey(String akey) {
        NSMutableArray mcrits = new NSMutableArray();
        NSMutableArray smcs = new NSMutableArray();
        DRSubMasterCriteria smc = DRSubMasterCriteria.withKeyUseMethodUseTimeFormatFormatPossibleValuesUseTypeGroupEdgesPossibleValues(akey, false, false, null, null, false, null);
        smcs.addObject((Object)smc);
        DRMasterCriteria mc = DRMasterCriteria.withSubMasterCriteriaUserInfo((NSArray)smcs, null);
        mcrits.addObject((Object)mc);
        return mcrits;
    }

    public static boolean writeStringToDiskPathAtomically(String string, String path, boolean flag) {
        _NSStringUtilities.writeToFile((File)new File(path), (String)string);
        return true;
    }

    public static String stringContentsOfFile(String path) {
        return ERXStringUtilities.stringWithContentsOfFile((String)path);
    }

    public static boolean boolForString(String s) {
        return ERXValueUtilities.booleanValue((Object)s);
    }

    public static String stringForBool(boolean b) {
        if (b) {
            return "true";
        }
        return "false";
    }

    public static NSArray possibleValues(NSDictionary smcdict) {
        Object rawpossVals = smcdict.objectForKey((Object)"possibleValues");
        String non = (String)smcdict.objectForKey((Object)"nonNumberOrDate");
        if (rawpossVals == null) {
            return null;
        }
        NSArray possVals = null;
        if (rawpossVals instanceof String) {
            WOXMLDecoder decoder = WOXMLDecoder.decoder();
            BASE64Decoder base64 = new BASE64Decoder();
            String xmlString = "";
            try {
                xmlString = new String(base64.decodeBuffer((String)rawpossVals));
            }
            catch (IOException ex) {
                // empty catch block
            }
            log.info((Object)("xmlString: " + xmlString));
            StringReader stringReader = new StringReader(xmlString);
            InputSource is = new InputSource(stringReader);
            try {
                possVals = (NSArray)decoder.decodeRootObject(is);
            }
            catch (Exception e) {}
        } else if (rawpossVals instanceof NSArray) {
            possVals = (NSArray)rawpossVals;
        }
        return possVals;
    }

    public static NSArray subMasterCriteriaList(NSArray smcList) {
        NSMutableArray arr = new NSMutableArray();
        Enumeration en = smcList.objectEnumerator();
        while (en.hasMoreElements()) {
            NSDictionary smcdict = (NSDictionary)en.nextElement();
            NSArray possVals = DRReportModel.possibleValues(smcdict);
            DRSubMasterCriteria smc = new DRSubMasterCriteria(smcdict, possVals);
            arr.addObject((Object)smc);
        }
        return arr;
    }

    public static NSArray masterCriteriaList(NSArray mcList) {
        NSMutableArray arr = new NSMutableArray();
        Enumeration en = mcList.objectEnumerator();
        while (en.hasMoreElements()) {
            NSDictionary mcdict = (NSDictionary)en.nextElement();
            NSArray smcList = DRReportModel.subMasterCriteriaList((NSArray)mcdict.objectForKey((Object)"subCriteriaList"));
            DRMasterCriteria mc = DRMasterCriteria.withSubMasterCriteriaUserInfo(smcList, (NSDictionary)mcdict.objectForKey((Object)"userInfo"));
            arr.addObject((Object)mc);
        }
        return arr;
    }

    public static NSArray attributeList(NSArray attList) {
        NSMutableArray arr = new NSMutableArray();
        Enumeration en = attList.objectEnumerator();
        while (en.hasMoreElements()) {
            DRAttribute att;
            NSDictionary attDict = (NSDictionary)en.nextElement();
            if ("YES".equals(attDict.objectForKey((Object)"disabled"))) continue;
            NSArray subAttList = (NSArray)attDict.objectForKey((Object)"attributes");
            if (subAttList != null) {
                NSArray subAttListObjects = DRReportModel.attributeList(subAttList);
                att = DRAttributeGroup.withKeyPathFormatLabelTotalListUserInfo((String)attDict.objectForKey((Object)"keyPath"), (String)attDict.objectForKey((Object)"format"), (String)attDict.objectForKey((Object)"label"), ERXValueUtilities.booleanValue((Object)attDict.objectForKey((Object)"total")), subAttListObjects, (NSDictionary)attDict.objectForKey((Object)"userInfo"));
            } else {
                att = DRAttribute.withKeyPathFormatLabelTotalUserInfo((String)attDict.objectForKey((Object)"keyPath"), (String)attDict.objectForKey((Object)"format"), (String)attDict.objectForKey((Object)"label"), ERXValueUtilities.booleanValue((Object)attDict.objectForKey((Object)"total")), (NSDictionary)attDict.objectForKey((Object)"userInfo"));
            }
            arr.addObject((Object)att);
        }
        return arr;
    }

    public static NSDictionary modelDictWithPListString(String plistString) {
        NSMutableDictionary dict = new NSMutableDictionary();
        NSDictionary rawdict = (NSDictionary)NSPropertyListSerialization.propertyListFromString((String)plistString);
        NSArray mcList = DRReportModel.masterCriteriaList((NSArray)rawdict.objectForKey((Object)GROUP_DEF_KEY));
        NSArray attList = DRReportModel.attributeList((NSArray)rawdict.objectForKey((Object)ATTRIBUTE_DEF_KEY));
        dict.setObjectForKey((Object)mcList, (Object)GROUP_DEF_KEY);
        dict.setObjectForKey((Object)attList, (Object)ATTRIBUTE_DEF_KEY);
        return dict;
    }

    public static NSDictionary modelFromPlistString(String plistString) {
        return DRReportModel.modelDictWithPListString(plistString);
    }

    public static NSArray masterSubCriteriaListString(NSArray smcList) {
        NSMutableArray arr = new NSMutableArray();
        Enumeration en = smcList.objectEnumerator();
        while (en.hasMoreElements()) {
            DRSubMasterCriteria smc = (DRSubMasterCriteria)en.nextElement();
            NSMutableDictionary smcDict = new NSMutableDictionary();
            smcDict.setObjectForKey((Object)smc.key(), (Object)"key");
            smcDict.setObjectForKey((Object)DRReportModel.stringForBool(smc.useMethod()), (Object)"useMethod");
            smcDict.setObjectForKey((Object)DRReportModel.stringForBool(smc.useTimeFormat()), (Object)"useTimeFormat");
            if (smc.format() != null) {
                smcDict.setObjectForKey((Object)smc.format(), (Object)"format");
            }
            if (smc.possibleValuesUseType() != null) {
                smcDict.setObjectForKey((Object)smc.possibleValuesUseType(), (Object)"possibleValuesUseType");
            }
            smcDict.setObjectForKey((Object)DRReportModel.stringForBool(smc.groupEdges()), (Object)"groupEdges");
            if (smc.rawPossibleValues() != null) {
                if (smc.nonNumberOrDate()) {
                    smcDict.setObjectForKey((Object)"true", (Object)"nonNumberOrDate");
                    String passValsXMLString = WOXMLCoder.coder().encodeRootObjectForKey((Object)smc.rawPossibleValues(), "XML");
                    BASE64Encoder base64 = new BASE64Encoder();
                    String base64XML = base64.encodeBuffer(passValsXMLString.getBytes());
                    smcDict.setObjectForKey((Object)base64XML, (Object)"possibleValues");
                } else {
                    smcDict.setObjectForKey((Object)smc.rawPossibleValues(), (Object)"possibleValues");
                }
            }
            arr.addObject((Object)smcDict);
        }
        return arr;
    }

    public static NSArray masterCriteriaListString(NSArray mcList) {
        NSMutableArray arr = new NSMutableArray();
        Enumeration en = mcList.objectEnumerator();
        while (en.hasMoreElements()) {
            DRMasterCriteria mc = (DRMasterCriteria)en.nextElement();
            NSMutableDictionary mcDict = new NSMutableDictionary();
            if (mc.userInfo() != null) {
                mcDict.setObjectForKey((Object)mc.userInfo(), (Object)"userInfo");
            }
            mcDict.setObjectForKey((Object)DRReportModel.masterSubCriteriaListString(mc.subCriteriaList()), (Object)"subCriteriaList");
            arr.addObject((Object)mcDict);
        }
        return arr;
    }

    public static NSDictionary stringForAttribute(DRAttribute att) {
        NSMutableDictionary dict = new NSMutableDictionary();
        if (att.keyPath() != null) {
            dict.setObjectForKey((Object)att.keyPath(), (Object)"keyPath");
        }
        if (att.format() != null) {
            dict.setObjectForKey((Object)att.format(), (Object)"format");
        }
        if (att.label() != null) {
            dict.setObjectForKey((Object)att.label(), (Object)"label");
        }
        if (att.shouldTotal()) {
            dict.setObjectForKey((Object)DRReportModel.stringForBool(att.shouldTotal()), (Object)"total");
        }
        if (att.userInfo() != null) {
            dict.setObjectForKey((Object)att.userInfo(), (Object)"userInfo");
        }
        if (att.isGroup()) {
            dict.setObjectForKey((Object)DRReportModel.attributeListString((NSArray)att.attributes()), (Object)"attributes");
        }
        return dict;
    }

    public static NSArray attributeListString(NSArray attList) {
        NSMutableArray arr = new NSMutableArray();
        Enumeration en = attList.objectEnumerator();
        while (en.hasMoreElements()) {
            DRAttribute att = (DRAttribute)en.nextElement();
            NSDictionary attString = DRReportModel.stringForAttribute(att);
            arr.addObject((Object)attString);
        }
        return arr;
    }

    public static String pListStringAttributeListMasterCriteriaList(NSArray attList, NSArray mcList) {
        NSMutableDictionary dict = new NSMutableDictionary();
        NSArray mcListString = DRReportModel.masterCriteriaListString(mcList);
        NSArray attListString = DRReportModel.attributeListString(attList);
        dict.setObjectForKey((Object)mcListString, (Object)GROUP_DEF_KEY);
        dict.setObjectForKey((Object)attListString, (Object)ATTRIBUTE_DEF_KEY);
        return dict.toString();
    }

    public static DRReportModel withRawRecordsCriteriaListAttributeList(NSArray rawr, NSArray aCritArray, NSArray aAttribList) {
        DRReportModel rmod = new DRReportModel();
        rmod.initWithRawRecords(rawr, aCritArray, aAttribList);
        return rmod;
    }

    public void buildGrandTotal() {
        DRRecordGroup rg = DRRecordGroup.withCriteriaGroupParent(null, null, null);
        this.registerRecordGroupWithCoordinates(rg, new NSDictionary());
        rg.recordList().addObjectsFromArray(this._records);
    }

    public DRReportModel initWithRawRecords(NSArray rawr, NSArray aCritArray, NSArray aAttribList) {
        this._attributeListDepth = 0;
        this._rawRecords = rawr;
        this._attributeList = aAttribList;
        this._criteriaList = aCritArray;
        this._registeredRecordGroups = new NSMutableDictionary();
        this._records = this.recordsForRawRecords(this._rawRecords);
        this._vList = new NSMutableArray();
        this._hList = new NSMutableArray();
        this._zList = new NSMutableArray();
        this._flatAttributeList = new NSMutableArray();
        this._flatAttributeListTotal = new NSMutableArray();
        this._flatAttributeDepthDict = new NSMutableDictionary();
        this._flatAttributeListTotalDict = new NSMutableDictionary();
        NSDictionary dict = this.groupsWithCriteriaArray(aCritArray);
        this._groups = (NSArray)dict.objectForKey((Object)"groups");
        this._groupDict = (NSDictionary)dict.objectForKey((Object)"lookup");
        this._vList.addObjectsFromArray(this._groups);
        this.groupAllRecordGroups();
        log.debug((Object)"ABOUT TO GET flatListForAttributeList");
        this.flatListForAttributeList();
        log.debug((Object)"ABOUT TO GET flatListForAttributeListTotals");
        this.flatListForAttributeListTotals();
        log.debug((Object)("flatAttributeList: " + this._flatAttributeList));
        log.debug((Object)("flatAttributeListTotal: " + this._flatAttributeListTotal));
        this.buildGrandTotal();
        this.buildOrderings();
        NSSelector synchModelSelector = new NSSelector("synchModel", ERXConstant.NotificationClassArray);
        NSNotificationCenter.defaultCenter().addObserver((Object)this, synchModelSelector, DRReportModelUpdateNotification, (Object)this);
        NSNotificationCenter.defaultCenter().addObserver((Object)this, synchModelSelector, DRReportModelRebuildNotification, (Object)this);
        return this;
    }

    public void synchModel() {
        log.info((Object)"synchModel()");
        this.computeRecordValuesForRecords(this.records());
        this.makeRecordGroupsStaleTotal();
        this.flatListForAttributeList();
        this.flatListForAttributeListTotals();
        this.buildGrandTotal();
        this.buildOrderings();
    }

    public void synchModel(NSNotification notification) {
        this.synchModel();
    }

    public void groupAllRecordGroups() {
        Enumeration anEnum = this._groups.objectEnumerator();
        while (anEnum.hasMoreElements()) {
            DRGroup grp = (DRGroup)anEnum.nextElement();
            grp.groupSubRecordGroupsWithMasterCriteriaLookupDict(this._groupDict);
        }
    }

    public NSArray recordsForRawRecords(NSArray rawr) {
        NSMutableArray recs = new NSMutableArray();
        Enumeration anEnum = rawr.objectEnumerator();
        while (anEnum.hasMoreElements()) {
            NSKeyValueCodingAdditions rawrec = (NSKeyValueCodingAdditions)anEnum.nextElement();
            recs.addObject((Object)DRRecord.withRawRecordModel(rawrec, this));
        }
        return new NSArray((NSArray)recs);
    }

    public int attributeListDepth() {
        return this._attributeListDepth;
    }

    public NSArray flatAttributeList() {
        return this._flatAttributeList;
    }

    public void flatListForAttribute(DRAttribute att) {
        if (!att.isGroup()) {
            this._flatAttributeList.addObject((Object)att);
        } else {
            NSArray subvls = att.flatAttributesWithDepthDictionary(this._attributeListDepth, this._flatAttributeDepthDict);
            this._flatAttributeList.addObjectsFromArray(subvls);
            if (att.shouldTotal()) {
                this._flatAttributeList.addObject((Object)att);
            }
        }
        Integer dpthKey = new Integer(this._attributeListDepth);
        NSMutableArray lst = (NSMutableArray)this._flatAttributeDepthDict.objectForKey((Object)dpthKey);
        if (lst == null) {
            lst = new NSMutableArray();
            this._flatAttributeDepthDict.setObjectForKey((Object)lst, (Object)dpthKey);
        }
        lst.addObject((Object)att);
    }

    public void flatListForAttributeList() {
        this._flatAttributeList.removeAllObjects();
        this._flatAttributeDepthDict.removeAllObjects();
        this._attributeListDepth = 0;
        if (this._attributeList != null) {
            Enumeration anEnum = this._attributeList.objectEnumerator();
            while (anEnum.hasMoreElements()) {
                DRAttribute att = (DRAttribute)anEnum.nextElement();
                this.flatListForAttribute(att);
            }
        }
    }

    private void getFlatAttributeDepthDictTotals() {
        NSArray depthKeys = this._flatAttributeDepthDict.allKeys();
        int cnt = depthKeys.count();
        for (int i = 0; i < cnt; ++i) {
            Integer ky = new Integer(i);
            NSArray attsForDepth = (NSArray)this._flatAttributeDepthDict.objectForKey((Object)ky);
            Enumeration anEnum = attsForDepth.objectEnumerator();
            while (anEnum.hasMoreElements()) {
                DRAttribute att = (DRAttribute)anEnum.nextElement();
                if (!att.shouldTotal()) continue;
                NSMutableArray lst = (NSMutableArray)this._flatAttributeListTotalDict.objectForKey((Object)ky);
                if (lst == null) {
                    lst = new NSMutableArray();
                    this._flatAttributeListTotalDict.setObjectForKey((Object)lst, (Object)ky);
                }
                lst.addObject((Object)att);
            }
        }
    }

    public void flatListForAttributeListTotals() {
        this._flatAttributeListTotal.removeAllObjects();
        this._flatAttributeListTotalDict.removeAllObjects();
        Enumeration anEnum = this._flatAttributeList.objectEnumerator();
        while (anEnum.hasMoreElements()) {
            DRAttribute att = (DRAttribute)anEnum.nextElement();
            if (!att.shouldTotal()) continue;
            this._flatAttributeListTotal.addObject((Object)att);
        }
        this.getFlatAttributeDepthDictTotals();
    }

    public NSDictionary flatAttributeDepthDict() {
        return this._flatAttributeDepthDict;
    }

    public NSDictionary flatAttributeListTotalDict() {
        return this._flatAttributeListTotalDict;
    }

    public NSArray flatAttributeListTotal() {
        return this._flatAttributeListTotal;
    }

    private void computeRecordValuesForRecords(NSArray recs) {
        Enumeration anEnum = recs.objectEnumerator();
        while (anEnum.hasMoreElements()) {
            DRRecord rec = (DRRecord)anEnum.nextElement();
            rec.populateValueList();
        }
    }

    public NSDictionary groupsWithCriteriaArray(NSArray aCritArray) {
        NSMutableDictionary grpDict = new NSMutableDictionary();
        NSMutableArray grps = new NSMutableArray();
        Enumeration anEnum = aCritArray.objectEnumerator();
        while (anEnum.hasMoreElements()) {
            DRMasterCriteria amc = (DRMasterCriteria)anEnum.nextElement();
            DRGroup grp = DRGroup.withReportModelMasterCriteria(this, amc);
            grps.addObject((Object)grp);
            grpDict.setObjectForKey((Object)grp, (Object)amc.keyDesc());
        }
        NSDictionary dict = new NSDictionary(new Object[]{grps, grpDict}, new Object[]{"groups", "lookup"});
        return dict;
    }

    public int spanForVListIndexAsCellsShowHeadingShowTotals(boolean forVlist, int indx, boolean asCells, boolean showHeading, boolean showTotals) {
        NSMutableArray lst = !forVlist ? this._hList : this._vList;
        int cnt = lst.count();
        int span = 1;
        int startIndex = indx + 1;
        if (startIndex < cnt) {
            for (int i = startIndex; i < cnt; ++i) {
                DRGroup grp = (DRGroup)lst.objectAtIndex(i);
                span *= grp.sortedCriteriaList().count();
            }
        }
        if (!forVlist) {
            if (asCells) {
                if (showTotals && this._flatAttributeListTotal.count() > 0) {
                    span *= this._flatAttributeListTotal.count();
                } else if (this._flatAttributeList.count() > 0) {
                    span *= this._flatAttributeListTotal.count();
                }
            }
        } else if (asCells) {
            // empty if block
        }
        return span;
    }

    public NSArray dimensionForName(String dim) {
        if (dim == null) {
            return this.vList();
        }
        if (dim.equals("H")) {
            return this.hList();
        }
        if (dim.equals("Z")) {
            return this.zList();
        }
        if (dim.equals("V")) {
            return this.vList();
        }
        return this.vList();
    }

    public void moveUpDimension(DRGroup vGroup, boolean up, String dim) {
        NSMutableArray dims = (NSMutableArray)this.dimensionForName(dim);
        int cur = dims.indexOfObject((Object)vGroup);
        dims.removeObject((Object)vGroup);
        int cnt = dims.count();
        if (up) {
            int newdex = cur - 1;
            if (newdex < 0) {
                dims.addObject((Object)vGroup);
            } else {
                dims.insertObjectAtIndex((Object)vGroup, newdex);
            }
        } else {
            int newdex = cur + 1;
            if (newdex > cnt) {
                dims.insertObjectAtIndex((Object)vGroup, 0);
            } else {
                dims.insertObjectAtIndex((Object)vGroup, newdex);
            }
        }
    }

    public NSArray zList() {
        return this._zList;
    }

    public NSArray hList() {
        return this._hList;
    }

    public NSArray vList() {
        return this._vList;
    }

    public void addToVList(DRGroup drg) {
        if (!this._vList.containsObject((Object)drg)) {
            this._vList.addObject((Object)drg);
        }
        if (this._hList.containsObject((Object)drg)) {
            this._hList.removeObject((Object)drg);
        }
        if (this._zList.containsObject((Object)drg)) {
            this._zList.removeObject((Object)drg);
        }
    }

    public void addToHList(DRGroup drg) {
        if (!this._hList.containsObject((Object)drg)) {
            this._hList.addObject((Object)drg);
        }
        if (this._vList.containsObject((Object)drg)) {
            this._vList.removeObject((Object)drg);
        }
        if (this._zList.containsObject((Object)drg)) {
            this._zList.removeObject((Object)drg);
        }
    }

    public void addToZList(DRGroup drg) {
        if (!this._zList.containsObject((Object)drg)) {
            this._zList.addObject((Object)drg);
        }
        if (this._vList.containsObject((Object)drg)) {
            this._vList.removeObject((Object)drg);
        }
        if (this._hList.containsObject((Object)drg)) {
            this._hList.removeObject((Object)drg);
        }
    }

    public NSArray records() {
        return this._records;
    }

    public NSArray groups() {
        return this._groups;
    }

    public DRGroup groupForMasterCriteria(DRMasterCriteria mc) {
        return (DRGroup)this._groupDict.objectForKey((Object)mc.keyDesc());
    }

    public DRMasterCriteria masterCriteriaForKeyPath(String keypath) {
        Enumeration anEnum = this.criteriaList().objectEnumerator();
        while (anEnum.hasMoreElements()) {
            DRMasterCriteria amc = (DRMasterCriteria)anEnum.nextElement();
            if (!amc.label().startsWith(keypath)) continue;
            return amc;
        }
        return null;
    }

    public NSArray rawRecords() {
        return this._rawRecords;
    }

    public NSArray criteriaList() {
        return this._criteriaList;
    }

    public void setCriteriaList(NSArray arr) {
        this._criteriaList = arr;
    }

    public NSArray attributeList() {
        return this._attributeList;
    }

    public void setAttributeList(NSArray arr) {
        this._attributeList = new NSArray(arr);
        this.synchModel();
    }

    public String toString() {
        return this._groups.toString();
    }

    public String coordinateKey(NSDictionary coordDict) {
        String lookupCoordKey = "/";
        Enumeration criterias = this._criteriaList.objectEnumerator();
        while (criterias.hasMoreElements()) {
            DRMasterCriteria mc = (DRMasterCriteria)criterias.nextElement();
            DRCriteria c = (DRCriteria)coordDict.objectForKey((Object)mc.keyDesc());
            String lookupkey = c == null || c.isTotal() ? "*" : (String)c.valueDict().objectForKey((Object)"lookupKey");
            lookupCoordKey = lookupCoordKey + lookupkey + "/";
        }
        return lookupCoordKey;
    }

    public void registerRecordGroupWithCoordinates(DRRecordGroup recGrp, NSDictionary coordDict) {
        String coordKey = this.coordinateKey(coordDict);
        this._registeredRecordGroups.setObjectForKey((Object)recGrp, (Object)coordKey);
    }

    public void makeRecordGroupsStaleTotal() {
        Enumeration recordGroups = this._registeredRecordGroups.allValues().objectEnumerator();
        while (recordGroups.hasMoreElements()) {
            DRRecordGroup recordGroup = (DRRecordGroup)recordGroups.nextElement();
            recordGroup.makeStale();
        }
    }

    public DRRecordGroup recordGroupForCoordinates(NSDictionary coordDict) {
        String coordKey = this.coordinateKey(coordDict);
        DRRecordGroup recordGroup = (DRRecordGroup)this._registeredRecordGroups.objectForKey((Object)coordKey);
        return recordGroup;
    }
}

