/*
 * Decompiled with CFR 0.152.
 */
package er.indexing.example;

import com.webobjects.eoaccess.EOAdaptorChannel;
import com.webobjects.eoaccess.EODatabaseContext;
import com.webobjects.eoaccess.EOModel;
import com.webobjects.eoaccess.EOModelGroup;
import com.webobjects.eoaccess.EOSQLExpression;
import com.webobjects.eoaccess.EOSynchronizationFactory;
import com.webobjects.eoaccess.EOUtilities;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSTimestamp;
import er.extensions.eof.ERXEC;
import er.extensions.foundation.ERXFileUtilities;
import er.extensions.foundation.ERXProperties;
import er.extensions.jdbc.ERXJDBCUtilities;
import er.extensions.jdbc.ERXSQLHelper;
import er.indexing.ERIndexing;
import er.indexing.example.eof.Asset;
import er.indexing.example.eof.AssetGroup;
import er.indexing.example.eof.Tag;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Random;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataCreator {
    private EOEditingContext ec;
    private static final Logger log = Logger.getLogger(DataCreator.class);
    NSMutableArray<Asset> assets = new NSMutableArray();
    NSMutableArray<AssetGroup> groups = new NSMutableArray();
    NSMutableArray<Tag> tags = new NSMutableArray();
    NSArray<String> words = new NSArray();

    public static void main(String[] args) {
        new DataCreator().createAll();
    }

    private NSDictionary optionsWithPrimaryKeySupportDisabled(NSDictionary options) {
        NSMutableDictionary mutableOptions = options.mutableClone();
        mutableOptions.setObjectForKey((Object)"NO", (Object)"createPrimaryKeySupport");
        mutableOptions.setObjectForKey((Object)"NO", (Object)"dropPrimaryKeySupport");
        return mutableOptions.immutableClone();
    }

    private void createPrimaryKeySupportForModel(EOModel eomodel, EOAdaptorChannel channel, EOSynchronizationFactory syncFactory) {
        try {
            NSArray pkSupportExpressions = syncFactory.primaryKeySupportStatementsForEntityGroups(new NSArray((Object)eomodel.entities()));
            Enumeration enumeration = pkSupportExpressions.objectEnumerator();
            while (enumeration.hasMoreElements()) {
                EOSQLExpression expression = (EOSQLExpression)enumeration.nextElement();
                channel.evaluateExpression(expression);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTables(boolean dropTables) {
        Enumeration e = EOModelGroup.defaultGroup().models().objectEnumerator();
        while (e.hasMoreElements()) {
            EOModel eomodel = (EOModel)e.nextElement();
            EODatabaseContext dbc = EOUtilities.databaseContextForModelNamed((EOEditingContext)this.ec, (String)eomodel.name());
            dbc.lock();
            try {
                EOAdaptorChannel channel = dbc.availableChannel().adaptorChannel();
                if (!eomodel.adaptorName().contains("JDBC")) continue;
                EOSynchronizationFactory syncFactory = (EOSynchronizationFactory)channel.adaptorContext().adaptor().synchronizationFactory();
                ERXSQLHelper helper = ERXSQLHelper.newSQLHelper((EOAdaptorChannel)channel);
                NSMutableDictionary options = helper.defaultOptionDictionary(true, dropTables);
                options = this.optionsWithPrimaryKeySupportDisabled((NSDictionary)options);
                this.createPrimaryKeySupportForModel(eomodel, channel, syncFactory);
                String sqlScript = syncFactory.schemaCreationScriptForEntities(eomodel.entities(), (NSDictionary)options);
                log.info((Object)("Creating tables: " + eomodel.name()));
                ERXJDBCUtilities.executeUpdateScriptIgnoringErrors((EOAdaptorChannel)channel, (String)sqlScript);
            }
            catch (SQLException ex) {
                log.error((Object)("Can't update: " + ex), (Throwable)ex);
            }
            finally {
                dbc.unlock();
            }
        }
    }

    public void createAll() {
        this.createTables();
        this.clearIndex();
        this.createDummyData();
    }

    public void clearIndex() {
        ERIndexing.indexing().clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTables() {
        this.ec = ERXEC.newEditingContext();
        this.ec.lock();
        try {
            boolean dropTables = ERXProperties.booleanForKeyWithDefault((String)"dropTables", (boolean)true);
            this.createTables(dropTables);
        }
        finally {
            this.ec.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDummyData() {
        this.ec = ERXEC.newEditingContext();
        this.ec.lock();
        try {
            this.doCreateDummyData();
        }
        finally {
            this.ec.unlock();
        }
    }

    private int randomInt(int max) {
        return new Random().nextInt(max);
    }

    private <T> T randomObject(NSArray<T> array) {
        return (T)array.objectAtIndex(this.randomInt(array.count()));
    }

    private String randomWord() {
        return this.randomObject(this.words);
    }

    private String randomText(int max) {
        StringBuilder content = new StringBuilder();
        while (true) {
            String nextWord = this.randomWord();
            if (content.length() + nextWord.length() + 1 >= max) break;
            content.append(nextWord).append(' ');
        }
        return content.toString();
    }

    private Tag randomTag() {
        return this.randomObject((NSArray)this.tags);
    }

    private AssetGroup randomAssetGroup() {
        return this.randomObject((NSArray)this.groups);
    }

    private BigDecimal randomPrice() {
        return BigDecimal.valueOf((double)this.randomInt(10000) / 100.0).setScale(2, 1);
    }

    private NSTimestamp randomTime() {
        return new NSTimestamp((long)(this.randomInt((int)(System.currentTimeMillis() / 1000L)) * 1000));
    }

    private void doCreateDummyData() {
        try {
            int i;
            log.info((Object)"load");
            String wordFile = ERXFileUtilities.stringFromFile((File)new File("/usr/share/dict/words"));
            this.words = NSArray.componentsSeparatedByString((String)wordFile, (String)"\n");
            log.info((Object)("loaded words: " + this.words.count()));
            int MAX = 100;
            int MAX_ASSETS = MAX * 10;
            for (i = 0; i < MAX; ++i) {
                Tag tag = (Tag)Tag.clazz.createAndInsertObject(this.ec);
                tag.setName(this.randomWord());
                this.tags.addObject((Object)tag);
            }
            log.info((Object)("created tags: " + this.tags.count()));
            for (i = 0; i < MAX; ++i) {
                AssetGroup group = (AssetGroup)AssetGroup.clazz.createAndInsertObject(this.ec);
                group.setName(this.randomWord());
                this.groups.addObject((Object)group);
            }
            log.info((Object)("created groups: " + this.groups.count()));
            for (i = 0; i < MAX_ASSETS; ++i) {
                Asset asset = (Asset)Asset.clazz.createAndInsertObject(this.ec);
                asset.setAssetGroup(this.randomAssetGroup());
                asset.setCreationDate(this.randomTime());
                asset.setUserCount(Long.valueOf(this.randomInt(10000)));
                asset.setPrice(this.randomPrice());
                for (int j = 0; j < 10; ++j) {
                    asset.addToTags(this.randomTag());
                }
                asset.setContent(this.randomText(1000));
                asset.setGenericInfo(this.randomText(1000));
                this.assets.addObject((Object)asset);
            }
            log.info((Object)("created assets: " + this.assets.count()));
            this.ec.saveChanges();
            log.info((Object)("fin: " + this.words.count()));
        }
        catch (IOException e) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
        }
    }
}

