/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.monitor.application;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WODirectAction;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSSet;
import com.webobjects.monitor._private.MApplication;
import com.webobjects.monitor._private.MInstance;
import com.webobjects.monitor._private.MObject;
import com.webobjects.monitor._private.MSiteConfig;
import com.webobjects.monitor.application.AdminApplicationsPage;
import com.webobjects.monitor.application.AppDetailPage;
import com.webobjects.monitor.application.Session;
import com.webobjects.monitor.application.WOTaskdHandler;
import java.util.Enumeration;

public class AdminAction
extends WODirectAction {
    protected static NSArray supportedActionNames = new NSArray((Object[])new String[]{"running", "bounce", "stopped", "start", "stop", "forceQuit", "turnAutoRecoverOn", "turnAutoRecoverOff", "turnRefuseNewSessionsOn", "turnRefuseNewSessionsOff", "turnScheduledOn", "turnScheduledOff", "turnAutoRecoverOn", "turnAutoRecoverOff", "clearDeaths", "info"});
    protected AdminApplicationsPage applicationsPage;
    protected NSMutableArray instances = new NSMutableArray();
    protected NSMutableArray applications = new NSMutableArray();
    private WOTaskdHandler _handler = new WOTaskdHandler(this.mySession());

    public AdminAction(WORequest worequest) {
        super(worequest);
    }

    public WOComponent MainAction() {
        return this.pageWithName("Main");
    }

    protected AdminApplicationsPage applicationsPage() {
        if (this.applicationsPage == null) {
            this.applicationsPage = new AdminApplicationsPage(this.context());
        }
        return this.applicationsPage;
    }

    public WOActionResults infoAction() {
        WOResponse woresponse = new WOResponse();
        woresponse.setStatus(200);
        String result = "";
        Enumeration enumeration = this.instances.objectEnumerator();
        while (enumeration.hasMoreElements()) {
            MInstance minstance = (MInstance)enumeration.nextElement();
            result = result + (result.length() == 0 ? "" : ", \n");
            result = result + "{";
            result = result + "\"name\": \"" + minstance.applicationName() + "\", ";
            result = result + "\"id\": \"" + minstance.id() + "\", ";
            result = result + "\"host\": \"" + minstance.hostName() + "\", ";
            result = result + "\"port\": \"" + minstance.port() + "\", ";
            result = result + "\"state\": \"" + MObject.stateArray[minstance.state] + "\", ";
            result = result + "\"deaths\": \"" + minstance.deathCount() + "\", ";
            result = result + "\"refusingNewSessions\": " + minstance.isRefusingNewSessions() + ", ";
            result = result + "\"scheduled\": " + minstance.isScheduled() + ", ";
            result = result + "\"transactions\": \"" + minstance.transactions() + "\", ";
            result = result + "\"activeSessions\": \"" + minstance.activeSessions() + "\", ";
            result = result + "\"averageIdlePeriod\": \"" + minstance.averageIdlePeriod() + "\", ";
            result = result + "\"avgTransactionTime\": \"" + minstance.avgTransactionTime() + "\",";
            result = result + "\"autoRecover\": \"" + minstance.isAutoRecovering() + "\"";
            String infoMode = (String)this.context().request().formValueForKey("info");
            if ("full".equalsIgnoreCase(infoMode)) {
                result = result + ", \"additionalArgs\": \"";
                if (minstance.additionalArgs() != null) {
                    result = result + minstance.additionalArgs().replace("\"", "\\\"");
                }
                result = result + "\"";
            }
            result = result + "}";
        }
        woresponse.appendContentString("[" + result + "]");
        return woresponse;
    }

    public WOActionResults runningAction() {
        WOResponse woresponse = new WOResponse();
        woresponse.setContent("YES");
        woresponse.setStatus(200);
        String num = (String)this.context().request().formValueForKey("num");
        int numberOfInstancesRequested = -1;
        if (num != null && !num.equals("") && !num.equalsIgnoreCase("all")) {
            try {
                numberOfInstancesRequested = Integer.valueOf(num);
                if (numberOfInstancesRequested > this.instances.count()) {
                    numberOfInstancesRequested = -1;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        int instancesAlive = 0;
        Enumeration enumeration = this.instances.objectEnumerator();
        while (enumeration.hasMoreElements()) {
            MInstance minstance = (MInstance)enumeration.nextElement();
            if (minstance.state != MObject.ALIVE) continue;
            ++instancesAlive;
        }
        if (numberOfInstancesRequested == -1 && instancesAlive < this.instances.count() || instancesAlive < numberOfInstancesRequested) {
            woresponse.setContent("NO");
            woresponse.setStatus(417);
        }
        return woresponse;
    }

    public WOActionResults stoppedAction() {
        WOResponse woresponse = new WOResponse();
        woresponse.setContent("YES");
        woresponse.setStatus(200);
        Enumeration enumeration = this.instances.objectEnumerator();
        while (enumeration.hasMoreElements()) {
            MInstance minstance = (MInstance)enumeration.nextElement();
            if (minstance.state == MObject.DEAD) continue;
            woresponse.setContent("NO");
            woresponse.setStatus(417);
            break;
        }
        return woresponse;
    }

    public WOActionResults bounceAction() {
        WOResponse woresponse = new WOResponse();
        woresponse.setContent("OK");
        woresponse.setStatus(200);
        String bouncetype = (String)this.context().request().formValueForKey("bouncetype");
        String maxwaitString = (String)this.context().request().formValueForKey("maxwait");
        if (bouncetype == null || bouncetype == "" || bouncetype.equalsIgnoreCase("graceful")) {
            this.applicationsPage().bounceGraceful((NSArray<MApplication>)this.applications);
        } else if (bouncetype.equalsIgnoreCase("shutdown")) {
            int maxwait = 30;
            if (maxwaitString != null) {
                try {
                    maxwait = Integer.valueOf(maxwaitString);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            this.applicationsPage().bounceShutdown((NSArray<MApplication>)this.applications, maxwait);
        } else {
            woresponse.setContent("Unknown bouncetype");
            woresponse.setStatus(406);
        }
        return woresponse;
    }

    public void clearDeathsAction() {
        this.applicationsPage().clearDeaths((NSArray)this.instances);
    }

    public void turnScheduledOnAction() {
        this.applicationsPage().turnScheduledOn((NSArray)this.instances);
    }

    public void turnScheduledOffAction() {
        this.applicationsPage().turnScheduledOff((NSArray)this.instances);
    }

    public void turnRefuseNewSessionsOnAction() {
        this.applicationsPage().turnRefuseNewSessionsOn((NSArray)this.instances);
    }

    public void turnRefuseNewSessionsOffAction() {
        this.applicationsPage().turnRefuseNewSessionsOff((NSArray)this.instances);
    }

    public void turnAutoRecoverOnAction() {
        this.applicationsPage().turnAutoRecoverOn((NSArray)this.instances);
    }

    public void turnAutoRecoverOffAction() {
        this.applicationsPage().turnAutoRecoverOff((NSArray)this.instances);
    }

    public void forceQuitAction() {
        this.applicationsPage().forceQuit((NSArray)this.instances);
    }

    public void stopAction() {
        this.applicationsPage().stop((NSArray)this.instances);
    }

    public void startAction() {
        this.applicationsPage().start((NSArray)this.instances);
    }

    protected void prepareApplications(NSArray nsarray) {
        if (nsarray == null) {
            throw new DirectActionException("at least one application name needs to be specified for type app", 406);
        }
        Enumeration enumeration = nsarray.objectEnumerator();
        while (enumeration.hasMoreElements()) {
            String s = (String)enumeration.nextElement();
            MApplication mapplication = this.siteConfig().applicationWithName(s);
            if (mapplication != null) {
                this.applications.addObject((Object)mapplication);
                this.addInstancesForApplication(mapplication);
                continue;
            }
            throw new DirectActionException("Unknown application " + s, 404);
        }
    }

    protected void prepareInstances(NSArray nsarray) {
        if (nsarray == null) {
            throw new DirectActionException("at least one instance name needs to be specified for type ins", 406);
        }
        Enumeration enumeration = nsarray.objectEnumerator();
        while (enumeration.hasMoreElements()) {
            String s = (String)enumeration.nextElement();
            MInstance minstance = this.siteConfig().instanceWithName(s);
            if (minstance != null) {
                this.instances.addObject((Object)minstance);
                continue;
            }
            throw new DirectActionException("Unknown instance " + s, 404);
        }
    }

    protected void addInstancesForApplication(MApplication mapplication) {
        this.instances.addObjectsFromArray(mapplication.instanceArray());
    }

    protected void refreshInformation() {
        Enumeration enumeration = new NSSet((NSArray)this.instances.valueForKey("application")).objectEnumerator();
        while (enumeration.hasMoreElements()) {
            MApplication mapplication = (MApplication)enumeration.nextElement();
            AppDetailPage appDetailPage = AppDetailPage.create(this.context(), mapplication);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WOActionResults performMonitorActionNamed(String s) {
        String s1 = (String)this.context().request().formValueForKey("type");
        if ("all".equalsIgnoreCase(s1)) {
            this.prepareApplications((NSArray)this.siteConfig().applicationArray().valueForKey("name"));
        } else {
            NSArray nsarray = this.context().request().formValuesForKey("name");
            if ("app".equalsIgnoreCase(s1)) {
                this.prepareApplications(nsarray);
            } else if ("ins".equalsIgnoreCase(s1)) {
                this.prepareInstances(nsarray);
            } else {
                throw new DirectActionException("Invalid type " + s1, 406);
            }
        }
        this.refreshInformation();
        this._handler.startReading();
        try {
            WOActionResults woactionresults;
            WOActionResults wOActionResults = woactionresults = super.performActionNamed(s);
            return wOActionResults;
        }
        finally {
            this._handler.endReading();
        }
    }

    private MSiteConfig siteConfig() {
        return WOTaskdHandler.siteConfig();
    }

    public WOActionResults performActionNamed(String s) {
        WOResponse woresponse;
        block6: {
            woresponse = new WOResponse();
            if (!this.siteConfig().isPasswordRequired() || this.siteConfig().compareStringWithPassword(this.context().request().stringFormValueForKey("pw"))) {
                try {
                    WOActionResults woactionresults = this.performMonitorActionNamed(s);
                    if (woactionresults != null && woactionresults instanceof WOResponse) {
                        woresponse = (WOResponse)woactionresults;
                        break block6;
                    }
                    woresponse.setContent("OK");
                    woresponse.setStatus(200);
                }
                catch (DirectActionException directactionexception) {
                    woresponse.setStatus(directactionexception.status);
                    woresponse.setContent(s + " action failed: " + directactionexception.getMessage());
                }
                catch (Exception throwable) {
                    woresponse.setStatus(500);
                    woresponse.setContent(s + " action failed: " + throwable.getMessage() + ". See Monitor's log for a stack trace.");
                    throwable.printStackTrace();
                }
            } else {
                woresponse.setStatus(403);
                woresponse.setContent("Monitor is password protected - password missing or incorrect.");
            }
        }
        return woresponse;
    }

    public Session mySession() {
        return (Session)this.session();
    }

    public class DirectActionException
    extends RuntimeException {
        public int status;

        public DirectActionException(String s, int i) {
            super(s);
            this.status = i;
        }
    }
}

