/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.monitor.application;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.monitor._private.MApplication;
import com.webobjects.monitor._private.MHost;
import com.webobjects.monitor._private.MInstance;
import com.webobjects.monitor._private.MObject;
import com.webobjects.monitor._private.String_Extensions;
import com.webobjects.monitor.application.AppDetailPage;
import com.webobjects.monitor.application.ApplicationsPage;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdminApplicationsPage
extends ApplicationsPage {
    public static final String DISPLAY_NAME = "displayName";
    public static final String ACTION_NAME = "actionName";
    protected static NSArray _actions;
    public NSArray actions = _actions;
    public NSDictionary selectedAction;
    public NSDictionary currentActionItem;
    protected NSMutableArray processedHosts = new NSMutableArray();
    protected NSMutableArray processedInstances = new NSMutableArray();

    public AdminApplicationsPage(WOContext context) {
        super(context);
    }

    protected void processedInstance(MInstance minstance) {
        this.processedInstances.addObject((Object)minstance);
        this.processedHosts.addObject((Object)minstance.host());
    }

    protected void cleanup() {
        this.processedInstances.removeAllObjects();
        this.processedHosts.removeAllObjects();
    }

    protected void sendUpdateInstancesToWotaskds() {
        if (this.processedInstances.count() > 0) {
            this.handler().sendUpdateInstancesToWotaskds((NSArray<MInstance>)this.processedInstances, (NSArray)this.processedHosts);
        }
        this.cleanup();
    }

    protected void sendCommandInstancesToWotaskds(String s) {
        if (this.processedInstances.count() > 0) {
            this.handler().sendCommandInstancesToWotaskds(s, (NSArray<MInstance>)this.processedInstances, (NSArray<MHost>)this.processedHosts);
        }
        this.cleanup();
    }

    public void clearDeaths(NSArray nsarray) {
        Enumeration enumeration = nsarray.objectEnumerator();
        while (enumeration.hasMoreElements()) {
            MInstance minstance = (MInstance)enumeration.nextElement();
            this.processedInstance(minstance);
        }
        this.sendCommandInstancesToWotaskds("CLEAR");
    }

    public void turnScheduledOn(NSArray nsarray) {
        Enumeration enumeration = nsarray.objectEnumerator();
        while (enumeration.hasMoreElements()) {
            MInstance minstance = (MInstance)enumeration.nextElement();
            if (minstance.isScheduled()) continue;
            minstance.setSchedulingEnabled(Boolean.TRUE);
            this.processedInstance(minstance);
        }
        this.sendUpdateInstancesToWotaskds();
    }

    public void turnScheduledOff(NSArray nsarray) {
        Enumeration enumeration = nsarray.objectEnumerator();
        while (enumeration.hasMoreElements()) {
            MInstance minstance = (MInstance)enumeration.nextElement();
            if (!minstance.isScheduled()) continue;
            minstance.setSchedulingEnabled(Boolean.FALSE);
            this.processedInstance(minstance);
        }
        this.sendUpdateInstancesToWotaskds();
    }

    public void turnRefuseNewSessionsOn(NSArray nsarray) {
        Enumeration enumeration = nsarray.objectEnumerator();
        while (enumeration.hasMoreElements()) {
            MInstance minstance = (MInstance)enumeration.nextElement();
            if (minstance.isRefusingNewSessions()) continue;
            minstance.setRefusingNewSessions(true);
            this.processedInstance(minstance);
        }
        this.sendCommandInstancesToWotaskds("REFUSE");
    }

    public void turnRefuseNewSessionsOff(NSArray nsarray) {
        Enumeration enumeration = nsarray.objectEnumerator();
        while (enumeration.hasMoreElements()) {
            MInstance minstance = (MInstance)enumeration.nextElement();
            if (!minstance.isRefusingNewSessions()) continue;
            minstance.setRefusingNewSessions(false);
            this.processedInstance(minstance);
        }
        this.sendCommandInstancesToWotaskds("ACCEPT");
    }

    public void turnAutoRecoverOn(NSArray nsarray) {
        Enumeration enumeration = nsarray.objectEnumerator();
        while (enumeration.hasMoreElements()) {
            MInstance minstance = (MInstance)enumeration.nextElement();
            if (minstance.autoRecover() != null && minstance.autoRecover().booleanValue()) continue;
            minstance.setAutoRecover(Boolean.TRUE);
            this.processedInstance(minstance);
        }
        this.sendUpdateInstancesToWotaskds();
    }

    public void turnAutoRecoverOff(NSArray nsarray) {
        Enumeration enumeration = nsarray.objectEnumerator();
        while (enumeration.hasMoreElements()) {
            MInstance minstance = (MInstance)enumeration.nextElement();
            if (minstance.autoRecover() == null || !minstance.autoRecover().booleanValue()) continue;
            minstance.setAutoRecover(Boolean.FALSE);
            this.processedInstance(minstance);
        }
        this.sendUpdateInstancesToWotaskds();
    }

    public void forceQuit(NSArray nsarray) {
        Enumeration enumeration = nsarray.objectEnumerator();
        while (enumeration.hasMoreElements()) {
            MInstance minstance = (MInstance)enumeration.nextElement();
            minstance.state = MObject.STOPPING;
            this.processedInstance(minstance);
        }
        this.sendCommandInstancesToWotaskds("QUIT");
    }

    public void stop(NSArray nsarray) {
        Enumeration enumeration = nsarray.objectEnumerator();
        while (enumeration.hasMoreElements()) {
            MInstance minstance = (MInstance)enumeration.nextElement();
            if (minstance.state != MObject.ALIVE && minstance.state != MObject.STARTING) continue;
            minstance.state = MObject.STOPPING;
            this.processedInstance(minstance);
        }
        this.sendCommandInstancesToWotaskds("STOP");
    }

    public void start(NSArray nsarray) {
        Enumeration enumeration = nsarray.objectEnumerator();
        while (enumeration.hasMoreElements()) {
            MInstance minstance = (MInstance)enumeration.nextElement();
            if (minstance.state != MObject.DEAD && minstance.state != MObject.STOPPING && minstance.state != MObject.CRASHING && minstance.state != MObject.UNKNOWN) continue;
            minstance.state = MObject.STARTING;
            this.processedInstance(minstance);
        }
        this.sendCommandInstancesToWotaskds("START");
    }

    public void bounce(NSArray<MApplication> applications) {
        this.bounceGraceful(applications);
    }

    public void bounceGraceful(NSArray<MApplication> applications) {
        for (MApplication application : applications) {
            AppDetailPage page = AppDetailPage.create(this.context(), application);
            page = (AppDetailPage)page.bounceClickedWithGracefulBouncer();
        }
    }

    public void bounceShutdown(NSArray<MApplication> applications, int maxwait) {
        for (MApplication application : applications) {
            AppDetailPage page = AppDetailPage.create(this.context(), application);
            page = (AppDetailPage)page.bounceClickedWithShutdownBouncer(maxwait);
        }
    }

    @Override
    public WOComponent bounceClicked() {
        AppDetailPage page = AppDetailPage.create(this.context(), this.currentApplication);
        page = (AppDetailPage)page.bounceClicked();
        return page;
    }

    protected NSArray allInstances() {
        NSMutableArray nsmutablearray = new NSMutableArray();
        Enumeration enumeration = this.applicationArray().objectEnumerator();
        while (enumeration.hasMoreElements()) {
            NSArray instances = ((MApplication)enumeration.nextElement()).instanceArray();
            nsmutablearray.addObjectsFromArray(instances);
        }
        return nsmutablearray;
    }

    private NSMutableArray applicationArray() {
        return this.siteConfig().applicationArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WOComponent performInstanceAction() {
        this.handler().startReading();
        try {
            ((Method)this.selectedAction.valueForKey(ACTION_NAME)).invoke((Object)this, this.allInstances());
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        finally {
            this.handler().endReading();
        }
        return AdminApplicationsPage.create(this.context());
    }

    public boolean showMovers() {
        return this.applicationArray().count() > 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WOComponent saveMoving() {
        this.handler().startReading();
        try {
            NSMutableArray hosts = this.siteConfig().hostArray();
            Enumeration enumeration = hosts.objectEnumerator();
            while (enumeration.hasMoreElements()) {
                MHost mhost = (MHost)enumeration.nextElement();
                this.handler().sendOverwriteToWotaskd(mhost);
            }
            WOComponent wOComponent = AdminApplicationsPage.create(this.context());
            return wOComponent;
        }
        finally {
            this.handler().endReading();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WOComponent moveUpClicked() {
        this.handler().startReading();
        try {
            NSMutableArray nsmutablearray = this.applicationArray();
            int i = nsmutablearray.indexOfObject((Object)this.currentApplication);
            nsmutablearray.removeObjectAtIndex(i);
            if (i == 0) {
                nsmutablearray.addObject((Object)this.currentApplication);
            } else {
                nsmutablearray.insertObjectAtIndex((Object)this.currentApplication, i - 1);
            }
            this.siteConfig().dataHasChanged();
            WOComponent wOComponent = AdminApplicationsPage.create(this.context());
            return wOComponent;
        }
        finally {
            this.handler().endReading();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WOComponent moveDownClicked() {
        this.handler().startReading();
        try {
            NSMutableArray nsmutablearray = this.applicationArray();
            int i = nsmutablearray.indexOfObject((Object)this.currentApplication);
            nsmutablearray.removeObjectAtIndex(i);
            if (i == nsmutablearray.count()) {
                nsmutablearray.insertObjectAtIndex((Object)this.currentApplication, 0);
            } else {
                nsmutablearray.insertObjectAtIndex((Object)this.currentApplication, i + 1);
            }
            this.siteConfig().dataHasChanged();
            WOComponent wOComponent = AdminApplicationsPage.create(this.context());
            return wOComponent;
        }
        finally {
            this.handler().endReading();
        }
    }

    @Override
    public WOComponent addApplicationClicked() {
        String s = null;
        WOComponent result = null;
        if (!String_Extensions.isValidXMLString((String)this.newApplicationName)) {
            s = "\"" + this.newApplicationName + "\" is an invalid application name.";
        }
        if (this.siteConfig().applicationWithName(this.newApplicationName) != null) {
            s = "An application with the name \"" + this.newApplicationName + "\" does already exist.";
        }
        result = s != null ? AdminApplicationsPage.create(this.context()) : super.addApplicationClicked();
        return result;
    }

    public static WOComponent create(WOContext context) {
        return WOApplication.application().pageWithName(AdminApplicationsPage.class.getName(), context);
    }

    static {
        try {
            Class<AdminApplicationsPage> c = AdminApplicationsPage.class;
            Class[] aclass = new Class[]{NSArray.class};
            Object[] keys = new String[]{DISPLAY_NAME, ACTION_NAME};
            _actions = new NSArray((Object[])new NSDictionary[]{new NSDictionary(new Object[]{"Start", c.getMethod("start", aclass)}, keys), new NSDictionary(new Object[]{"Stop", c.getMethod("stop", aclass)}, keys), new NSDictionary(new Object[]{"Turn Auto Recover on for", c.getMethod("turnAutoRecoverOn", aclass)}, keys), new NSDictionary(new Object[]{"Turn Auto Recover off for", c.getMethod("turnAutoRecoverOff", aclass)}, keys), new NSDictionary(new Object[]{"Turn Refuse New Sessions on for", c.getMethod("turnRefuseNewSessionsOn", aclass)}, keys), new NSDictionary(new Object[]{"Turn Refuse New Sessions off for", c.getMethod("turnRefuseNewSessionsOff", aclass)}, keys), new NSDictionary(new Object[]{"Turn Scheduled on for", c.getMethod("turnScheduledOn", aclass)}, keys), new NSDictionary(new Object[]{"Turn Scheduled off for", c.getMethod("turnScheduledOff", aclass)}, keys), new NSDictionary(new Object[]{"Force Quit", c.getMethod("forceQuit", aclass)}, keys)});
        }
        catch (NoSuchMethodException nosuchmethodexception) {
            nosuchmethodexception.printStackTrace();
        }
    }
}

