/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.monitor.application;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WODisplayGroup;
import com.webobjects.appserver._private.WOProperties;
import com.webobjects.eocontrol.EOSortOrdering;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.monitor._private.MApplication;
import com.webobjects.monitor._private.MHost;
import com.webobjects.monitor._private.MInstance;
import com.webobjects.monitor._private.MObject;
import com.webobjects.monitor._private.StatsUtilities;
import com.webobjects.monitor.application.AppConfigurePage;
import com.webobjects.monitor.application.AppDeathPage;
import com.webobjects.monitor.application.ConfirmationPage;
import com.webobjects.monitor.application.HostsPage;
import com.webobjects.monitor.application.InstConfigurePage;
import com.webobjects.monitor.application.MonitorComponent;
import com.webobjects.monitor.application.starter.ApplicationStarter;
import com.webobjects.monitor.application.starter.GracefulBouncer;
import com.webobjects.monitor.application.starter.ShutdownBouncer;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppDetailPage
extends MonitorComponent {
    private static final long serialVersionUID = 438829612215550387L;
    public MInstance currentInstance;
    public boolean isClearDeathSectionVisible = false;
    public boolean showDetailStatistics = false;
    public WODisplayGroup displayGroup;
    public String _hrefToApp = null;
    public MHost aHost;
    public MHost selectedHost;
    public int numberToAdd = 1;

    public AppDetailPage(WOContext aWocontext) {
        super(aWocontext);
        this.handler().updateForPage(this.name());
        this.displayGroup = new WODisplayGroup();
        this.displayGroup.setFetchesOnLoad(false);
    }

    public WOComponent showStatisticsClicked() {
        this.showDetailStatistics = !this.showDetailStatistics;
        return this.context().page();
    }

    public WOComponent refreshClicked() {
        return this.newDetailPage();
    }

    private String bouncerName() {
        return "Bouncer." + this.myApplication().name();
    }

    public ApplicationStarter currentBouncer() {
        return (ApplicationStarter)this.session().objectForKey(this.bouncerName());
    }

    public WOComponent bounceClicked() {
        return this.bounceClickedWithGracefulBouncer();
    }

    public WOComponent bounceClickedWithGracefulBouncer() {
        return this.bounceClickedWithBouncer(new GracefulBouncer(this.myApplication()));
    }

    public WOComponent bounceClickedWithShutdownBouncer(int maxwait) {
        return this.bounceClickedWithBouncer(new ShutdownBouncer(this.myApplication(), maxwait));
    }

    private WOComponent bounceClickedWithBouncer(ApplicationStarter bouncer) {
        ApplicationStarter old = this.currentBouncer();
        if (old != null) {
            old.interrupt();
        }
        this.session().setObjectForKey((Object)bouncer, this.bouncerName());
        bouncer.start();
        return this.newDetailPage();
    }

    public MInstance currentInstance() {
        return this.currentInstance;
    }

    public void selectAll() {
        if ("on".equals(this.context().request().stringFormValueForKey("deselectall"))) {
            this.displayGroup.setSelectedObjects((NSArray)new NSMutableArray());
        } else {
            this.displayGroup.setSelectedObjects(this.displayGroup.allObjects());
        }
    }

    public WOActionResults selectAllAction() {
        this.displayGroup.setSelectedObjects(this.displayGroup.allObjects());
        return null;
    }

    public WOActionResults selectNoneAction() {
        this.displayGroup.setSelectedObjects((NSArray)new NSMutableArray());
        return null;
    }

    public void selectRunning() {
        NSMutableArray selected = new NSMutableArray();
        Enumeration enumerator = this.displayGroup.allObjects().objectEnumerator();
        while (enumerator.hasMoreElements()) {
            MInstance instance = (MInstance)enumerator.nextElement();
            if (!instance.isRunning_M()) continue;
            selected.addObject((Object)instance);
        }
        this.displayGroup.setSelectedObjects((NSArray)selected);
    }

    public void selectNotRunning() {
        NSMutableArray selected = new NSMutableArray();
        Enumeration enumerator = this.displayGroup.allObjects().objectEnumerator();
        while (enumerator.hasMoreElements()) {
            MInstance instance = (MInstance)enumerator.nextElement();
            if (instance.isRunning_M()) continue;
            selected.addObject((Object)instance);
        }
        this.displayGroup.setSelectedObjects((NSArray)selected);
    }

    public void selectOne() {
        this._setIsSelectedInstance(!this.isSelectedInstance());
    }

    public void _setIsSelectedInstance(boolean selected) {
        NSMutableArray selectedObjects = this.displayGroup.selectedObjects().mutableClone();
        if (selected && !selectedObjects.containsObject((Object)this.currentInstance)) {
            selectedObjects.addObject((Object)this.currentInstance);
        } else if (!selected && selectedObjects.containsObject((Object)this.currentInstance)) {
            selectedObjects.removeObject((Object)this.currentInstance);
        }
        this.displayGroup.setSelectedObjects((NSArray)selectedObjects);
    }

    public void setIsSelectedInstance(boolean selected) {
    }

    public boolean isSelectedInstance() {
        return this.displayGroup.selectedObjects().contains((Object)this.currentInstance);
    }

    public boolean hasInstances() {
        NSArray instancesArray = this.myApplication().instanceArray();
        return instancesArray != null && instancesArray.count() != 0;
    }

    public boolean isRefreshEnabled() {
        NSArray instancesArray = this.myApplication().instanceArray();
        if (instancesArray == null || instancesArray.count() == 0) {
            return false;
        }
        return this.siteConfig().viewRefreshEnabled();
    }

    public WOComponent configureApplicationClicked() {
        AppConfigurePage aPage = AppConfigurePage.create(this.context(), this.myApplication());
        aPage.isNewInstanceSectionVisible = true;
        return aPage;
    }

    public WOComponent configureInstanceClicked() {
        InstConfigurePage aPage = InstConfigurePage.create(this.context(), this.currentInstance);
        return aPage;
    }

    public WOComponent deleteInstanceClicked() {
        final MInstance instance = this.currentInstance;
        return ConfirmationPage.create(this.context(), new ConfirmationPage.Delegate(){

            public WOComponent cancel() {
                return AppDetailPage.create(AppDetailPage.this.context(), instance.application());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public WOComponent confirm() {
                AppDetailPage.this.handler().startWriting();
                try {
                    AppDetailPage.this.siteConfig().removeInstance_M(instance);
                    if (AppDetailPage.this.siteConfig().hostArray().count() != 0) {
                        AppDetailPage.this.handler().sendRemoveInstancesToWotaskds(new NSArray((Object)instance), (NSArray)AppDetailPage.this.siteConfig().hostArray());
                    }
                }
                finally {
                    AppDetailPage.this.handler().endWriting();
                }
                return AppDetailPage.create(AppDetailPage.this.context(), instance.application());
            }

            public String explaination() {
                return "Selecting 'Yes' will shutdown the selected instance of this application and delete its instance configuration.";
            }

            public int pageType() {
                return 0;
            }

            public String question() {
                return "Are you sure you want to delete this instance (" + instance.displayName() + " running on " + instance.hostName() + ")";
            }
        });
    }

    public String linkToWOStats() {
        String adaptorURL = this.siteConfig().woAdaptor();
        StringBuffer aURL = null;
        if (adaptorURL != null) {
            aURL = new StringBuffer(this.hrefToInst());
        } else {
            aURL = new StringBuffer(this.hrefToInstDirect());
            aURL = aURL.append("/cgi-bin/WebObjects/");
            aURL = aURL.append(this.myApplication().name());
            aURL = aURL.append(".woa");
        }
        aURL = aURL.append("/wa/ERXDirectAction/stats?pw=" + WOProperties.TheStatisticsStorePassword);
        return aURL.toString();
    }

    public String hrefToApp() {
        if (this._hrefToApp == null) {
            String adaptorURL = this.siteConfig().woAdaptor();
            if (adaptorURL == null) {
                adaptorURL = WOApplication.application().cgiAdaptorURL();
            }
            this._hrefToApp = adaptorURL.charAt(adaptorURL.length() - 1) == '/' ? adaptorURL + this.myApplication().name() : adaptorURL + "/" + this.myApplication().name();
        }
        return this._hrefToApp;
    }

    public String hrefToInst() {
        return this.hrefToApp() + ".woa/" + this.currentInstance.id();
    }

    public String hrefToInstDirect() {
        return "http://" + this.currentInstance.hostName() + ":" + this.currentInstance.port();
    }

    public boolean shouldDisplayDeathDetailLink() {
        return this.currentInstance.deathCount() > 0;
    }

    public WOComponent instanceDeathDetailClicked() {
        AppDeathPage aPage = AppDeathPage.create(this.context(), this.currentInstance);
        return aPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WOComponent clearAllDeathsClicked() {
        this.handler().startReading();
        try {
            if (this.myApplication().hostArray().count() != 0) {
                this.handler().sendClearDeathsToWotaskds((NSArray<MInstance>)this.myApplication().instanceArray(), (NSArray<MHost>)this.myApplication().hostArray());
            }
        }
        finally {
            this.handler().endReading();
        }
        return this.newDetailPage();
    }

    public WOComponent startInstance() {
        if (this.currentInstance.state == MObject.DEAD || this.currentInstance.state == MObject.STOPPING || this.currentInstance.state == MObject.CRASHING || this.currentInstance.state == MObject.UNKNOWN) {
            this.handler().sendStartInstancesToWotaskds((NSArray<MInstance>)new NSArray((Object)this.currentInstance), (NSArray<MHost>)new NSArray((Object)this.currentInstance.host()));
            this.currentInstance.state = MObject.STARTING;
        }
        return this.newDetailPage();
    }

    public WOComponent stopInstance() {
        if (this.currentInstance.state == MObject.ALIVE || this.currentInstance.state == MObject.STARTING) {
            this.handler().sendStopInstancesToWotaskds((NSArray<MInstance>)new NSArray((Object)this.currentInstance), (NSArray<MHost>)new NSArray((Object)this.currentInstance.host()));
            this.currentInstance.state = MObject.STOPPING;
        }
        return this.newDetailPage();
    }

    public WOComponent toggleAutoRecover() {
        if (this.currentInstance.autoRecover() != null && this.currentInstance.autoRecover().booleanValue()) {
            this.currentInstance.setAutoRecover(Boolean.FALSE);
        } else {
            this.currentInstance.setAutoRecover(Boolean.TRUE);
        }
        this.sendUpdateInstances((NSArray<MInstance>)new NSArray((Object)this.currentInstance));
        return this.newDetailPage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendUpdateInstances(NSArray<MInstance> instances) {
        this.handler().startReading();
        try {
            NSMutableSet hosts = new NSMutableSet();
            for (MInstance instance : instances) {
                hosts.addObject((Object)instance.host());
            }
            this.handler().sendUpdateInstancesToWotaskds(instances, hosts.allObjects());
        }
        finally {
            this.handler().endReading();
        }
    }

    public WOComponent toggleRefuseNewSessions() {
        this.handler().sendRefuseSessionToWotaskds((NSArray<MInstance>)new NSArray((Object)this.currentInstance), (NSArray<MHost>)new NSArray((Object)this.currentInstance.host()), !this.currentInstance.isRefusingNewSessions());
        return this.newDetailPage();
    }

    public WOComponent toggleScheduling() {
        if (this.currentInstance.schedulingEnabled() != null && this.currentInstance.schedulingEnabled().booleanValue()) {
            this.currentInstance.setSchedulingEnabled(Boolean.FALSE);
        } else {
            this.currentInstance.setSchedulingEnabled(Boolean.TRUE);
        }
        this.sendUpdateInstances((NSArray<MInstance>)new NSArray((Object)this.currentInstance));
        return this.newDetailPage();
    }

    public NSArray<MInstance> selectedInstances() {
        return this.displayGroup.selectedObjects();
    }

    public NSArray<MInstance> runningInstances() {
        return this.myApplication().runningInstances_M();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WOComponent startAllClicked() {
        this.handler().startReading();
        try {
            this.startInstances(this.selectedInstances());
        }
        finally {
            this.handler().endReading();
        }
        return this.newDetailPage();
    }

    private void startInstances(NSArray<MInstance> possibleInstances) {
        NSMutableArray instances = new NSMutableArray();
        for (MInstance anInstance : possibleInstances) {
            if (anInstance.state != MObject.DEAD && anInstance.state != MObject.STOPPING && anInstance.state != MObject.CRASHING && anInstance.state != MObject.UNKNOWN) continue;
            instances.addObject((Object)anInstance);
        }
        if (instances.count() != 0) {
            this.handler().sendStartInstancesToWotaskds((NSArray<MInstance>)instances, (NSArray<MHost>)this.myApplication().hostArray());
            for (MInstance anInstance : instances) {
                if (anInstance.state == MObject.ALIVE) continue;
                anInstance.state = MObject.STARTING;
            }
        }
    }

    public WOComponent stopAllClicked() {
        final NSArray instances = this.selectedInstances().immutableClone();
        final MApplication application = this.myApplication();
        return ConfirmationPage.create(this.context(), new ConfirmationPage.Delegate(){

            public WOComponent cancel() {
                return AppDetailPage.create(AppDetailPage.this.context(), application, (NSArray<MInstance>)instances);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public WOComponent confirm() {
                AppDetailPage.this.handler().startReading();
                try {
                    if (application.hostArray().count() != 0) {
                        AppDetailPage.this.handler().sendStopInstancesToWotaskds((NSArray<MInstance>)instances, (NSArray<MHost>)application.hostArray());
                    }
                    for (int i = 0; i < instances.count(); ++i) {
                        MInstance anInst = (MInstance)instances.objectAtIndex(i);
                        if (anInst.state == MObject.DEAD) continue;
                        anInst.state = MObject.STOPPING;
                    }
                }
                finally {
                    AppDetailPage.this.handler().endReading();
                }
                return AppDetailPage.create(AppDetailPage.this.context(), application, (NSArray<MInstance>)instances);
            }

            public String explaination() {
                return "Selecting 'Yes' will shutdown the selected instances of this application.";
            }

            public int pageType() {
                return 0;
            }

            public String question() {
                return "Are you sure you want to stop the " + instances.count() + " instances of " + application.name() + "?";
            }
        });
    }

    public WOComponent deleteAllInstancesClicked() {
        final NSArray instances = this.selectedInstances().immutableClone();
        final MApplication application = this.myApplication();
        return ConfirmationPage.create(this.context(), new ConfirmationPage.Delegate(){

            public WOComponent cancel() {
                return AppDetailPage.create(AppDetailPage.this.context(), application, (NSArray<MInstance>)instances);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public WOComponent confirm() {
                AppDetailPage.this.handler().startWriting();
                try {
                    AppDetailPage.this.siteConfig().removeInstances_M(application, instances);
                    if (AppDetailPage.this.siteConfig().hostArray().count() != 0) {
                        AppDetailPage.this.handler().sendRemoveInstancesToWotaskds(instances, (NSArray)AppDetailPage.this.siteConfig().hostArray());
                    }
                }
                finally {
                    AppDetailPage.this.handler().endWriting();
                }
                return AppDetailPage.create(AppDetailPage.this.context(), application, (NSArray<MInstance>)instances);
            }

            public String explaination() {
                return "Selecting 'Yes' will shutdown any shutdown the selected instances of this application, and delete all matching instance configurations.";
            }

            public int pageType() {
                return 0;
            }

            public String question() {
                return "Are you sure you want to delete the selected <i>" + instances.count() + "</i> instances of application " + application.name() + "?";
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WOComponent autoRecoverEnableAllClicked() {
        this.handler().startReading();
        try {
            NSArray<MInstance> instancesArray = this.selectedInstances();
            for (int i = 0; i < instancesArray.count(); ++i) {
                MInstance anInst = (MInstance)instancesArray.objectAtIndex(i);
                anInst.setAutoRecover(Boolean.TRUE);
            }
            this.handler().sendUpdateInstancesToWotaskds(instancesArray, (NSArray)this.allHosts());
        }
        finally {
            this.handler().endReading();
        }
        return this.newDetailPage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WOComponent autoRecoverDisableAllClicked() {
        this.handler().startReading();
        try {
            NSArray<MInstance> instancesArray = this.selectedInstances();
            for (int i = 0; i < instancesArray.count(); ++i) {
                MInstance anInst = (MInstance)instancesArray.objectAtIndex(i);
                anInst.setAutoRecover(Boolean.FALSE);
            }
            this.handler().sendUpdateInstancesToWotaskds(instancesArray, (NSArray)this.allHosts());
        }
        finally {
            this.handler().endReading();
        }
        return this.newDetailPage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WOComponent acceptNewSessionsAllClicked() {
        this.handler().startReading();
        try {
            this.handler().sendRefuseSessionToWotaskds(this.selectedInstances(), (NSArray<MHost>)this.myApplication().hostArray(), false);
        }
        finally {
            this.handler().endReading();
        }
        return this.newDetailPage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WOComponent refuseNewSessionsAllClicked() {
        this.handler().startReading();
        try {
            this.handler().sendRefuseSessionToWotaskds(this.selectedInstances(), (NSArray<MHost>)this.myApplication().hostArray(), true);
            NSArray<MInstance> nSArray = this.selectedInstances();
        }
        finally {
            this.handler().endReading();
        }
        return this.newDetailPage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WOComponent schedulingEnableAllClicked() {
        this.handler().startReading();
        try {
            NSArray<MInstance> instancesArray = this.selectedInstances();
            for (int i = 0; i < instancesArray.count(); ++i) {
                MInstance anInst = (MInstance)instancesArray.objectAtIndex(i);
                anInst.setSchedulingEnabled(Boolean.TRUE);
            }
            if (this.allHosts().count() != 0) {
                this.handler().sendUpdateInstancesToWotaskds(instancesArray, (NSArray)this.allHosts());
            }
        }
        finally {
            this.handler().endReading();
        }
        return this.newDetailPage();
    }

    private WOComponent newDetailPage() {
        AppDetailPage nextPage = AppDetailPage.create(this.context(), this.myApplication());
        nextPage.displayGroup.setSelectedObjects(this.displayGroup.selectedObjects());
        return nextPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WOComponent schedulingDisableAllClicked() {
        this.handler().startReading();
        try {
            NSArray<MInstance> instancesArray = this.selectedInstances();
            for (int i = 0; i < instancesArray.count(); ++i) {
                MInstance anInst = (MInstance)instancesArray.objectAtIndex(i);
                anInst.setSchedulingEnabled(Boolean.FALSE);
            }
            this.handler().sendUpdateInstancesToWotaskds(instancesArray, (NSArray)this.allHosts());
        }
        finally {
            this.handler().endReading();
        }
        return this.newDetailPage();
    }

    public String instanceStatusImage() {
        if (this.currentInstance.state == MObject.DEAD) {
            return "PowerSwitch_Off.gif";
        }
        if (this.currentInstance.state == MObject.ALIVE) {
            return "PowerSwitch_On.gif";
        }
        if (this.currentInstance.state == MObject.STOPPING) {
            return "Turning_Off.gif";
        }
        if (this.currentInstance.state == MObject.CRASHING) {
            return "Turning_Off.gif";
        }
        if (this.currentInstance.state == MObject.STARTING) {
            return "Turning_On.gif";
        }
        return "PowerSwitch_Off.gif";
    }

    public String instanceStatusImageText() {
        if (this.currentInstance.state == MObject.DEAD) {
            return "OFF";
        }
        if (this.currentInstance.state == MObject.ALIVE) {
            return "ON";
        }
        if (this.currentInstance.state == MObject.STOPPING) {
            return "STOPPING";
        }
        if (this.currentInstance.state == MObject.CRASHING) {
            return "CRASHING";
        }
        if (this.currentInstance.state == MObject.STARTING) {
            return "STARTING";
        }
        return "UNKNOWN";
    }

    public String autoRecoverImage() {
        String result = "Panel_Off.gif";
        if (this.currentInstance.autoRecover() != null && this.currentInstance.autoRecover().booleanValue()) {
            result = "Panel_On_Green.gif";
        }
        return result;
    }

    public String autoRecoverImageText() {
        String result = "AutoRecover OFF";
        if (this.currentInstance.autoRecover() != null && this.currentInstance.autoRecover().booleanValue()) {
            result = "AutoRecover ON";
        }
        return result;
    }

    public String autoRecoverLabel() {
        String results = "Off";
        if (this.currentInstance.autoRecover() != null && this.currentInstance.autoRecover().booleanValue()) {
            results = "On";
        }
        return results;
    }

    public String autoRecoverDivClass() {
        String base = "AppControl";
        String results = base + " " + base + "AutoRecoverOff";
        if (this.currentInstance.autoRecover() != null && this.currentInstance.autoRecover().booleanValue()) {
            results = base + " " + base + "AutoRecoverOn";
        }
        return results;
    }

    public String refuseNewSessionsClass() {
        String base = "AppControl";
        String result = base + " " + base + "NotRefusingNewSessions";
        if (this.currentInstance.schedulingEnabled() != null && this.currentInstance.schedulingEnabled().booleanValue()) {
            result = this.currentInstance.isRefusingNewSessions() ? base + " " + base + "ScheduleEnabledRefusingNewSessions" : base + " " + base + "ScheduleEnabledNotRefusingNewSessions";
        } else if (this.currentInstance.isRefusingNewSessions()) {
            result = base + " " + base + "RefusingNewSessions";
        }
        return result;
    }

    public String refuseNewSessionsLabel() {
        String results = "Off";
        if (this.currentInstance.isRefusingNewSessions()) {
            results = "On";
        }
        return results;
    }

    public String refuseNewSessionsImage() {
        String result = null;
        result = this.currentInstance.schedulingEnabled() != null && this.currentInstance.schedulingEnabled().booleanValue() ? (this.currentInstance.isRefusingNewSessions() ? "Panel_On_Yellow.gif" : "Panel_Off_Yellow.gif") : (this.currentInstance.isRefusingNewSessions() ? "Panel_On_Green.gif" : "Panel_Off.gif");
        return result;
    }

    public String refuseNewSessionsImageText() {
        String result = "Accepting New Sessions";
        if (this.currentInstance.isRefusingNewSessions()) {
            result = "Refusing New Sessions";
        }
        return result;
    }

    public String schedulingImage() {
        String result = "Panel_Off.gif";
        if (this.currentInstance.schedulingEnabled() != null && this.currentInstance.schedulingEnabled().booleanValue()) {
            result = "Panel_On_Green.gif";
        }
        return result;
    }

    public String schedulingImageText() {
        String result = "Scheduling OFF";
        if (this.currentInstance.schedulingEnabled() != null && this.currentInstance.schedulingEnabled().booleanValue()) {
            result = "Scheduling ON";
        }
        return result;
    }

    public String schedulingLabel() {
        String result = "Off";
        if (this.currentInstance.schedulingEnabled() != null && this.currentInstance.schedulingEnabled().booleanValue()) {
            result = "On";
        }
        return result;
    }

    public String schedulingDivClass() {
        String base = "AppControl";
        String result = base + " " + base + "ScheduleOff";
        if (this.currentInstance.schedulingEnabled() != null && this.currentInstance.schedulingEnabled().booleanValue()) {
            result = base + " " + base + "ScheduleOn";
        }
        return result;
    }

    public String nextShutdown() {
        String result = "N/A";
        if (this.currentInstance.schedulingEnabled() != null && this.currentInstance.schedulingEnabled().booleanValue()) {
            result = this.currentInstance.nextScheduledShutdownString();
        }
        return result;
    }

    public Integer totalTransactions() {
        return StatsUtilities.totalTransactionsForApplication((MApplication)this.myApplication());
    }

    public Integer totalActiveSessions() {
        return StatsUtilities.totalActiveSessionsForApplication((MApplication)this.myApplication());
    }

    public Float totalAverageTransaction() {
        return StatsUtilities.totalAverageTransactionForApplication((MApplication)this.myApplication());
    }

    public Float totalAverageIdleTime() {
        return StatsUtilities.totalAverageIdleTimeForApplication((MApplication)this.myApplication());
    }

    public Float actualRatePerSecond() {
        return StatsUtilities.actualTransactionsPerSecondForApplication((MApplication)this.myApplication());
    }

    public Float actualRatePerMinute() {
        Float aNumber = StatsUtilities.actualTransactionsPerSecondForApplication((MApplication)this.myApplication());
        return new Float(aNumber.floatValue() * 60.0f);
    }

    public WOComponent hostsPageClicked() {
        return HostsPage.create(this.context());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WOComponent addInstanceClicked() {
        if (this.numberToAdd < 1) {
            return this.newDetailPage();
        }
        this.handler().startWriting();
        try {
            NSMutableArray newInstanceArray = this.siteConfig().addInstances_M(this.selectedHost, this.myApplication(), this.numberToAdd);
            if (this.allHosts().count() != 0) {
                this.handler().sendAddInstancesToWotaskds((NSArray)newInstanceArray, (NSArray)this.allHosts());
            }
        }
        finally {
            this.handler().endWriting();
        }
        return this.newDetailPage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasHosts() {
        this.handler().startReading();
        try {
            NSMutableArray hosts = this.allHosts();
            boolean bl = hosts != null && hosts.count() > 0;
            return bl;
        }
        finally {
            this.handler().endReading();
        }
    }

    public static AppDetailPage create(WOContext context, MApplication currentApplication, NSArray<MInstance> selected) {
        AppDetailPage page = (AppDetailPage)WOApplication.application().pageWithName(AppDetailPage.class.getName(), context);
        page.setMyApplication(currentApplication);
        NSArray instancesArray = currentApplication.instanceArray();
        if (instancesArray == null) {
            instancesArray = NSArray.EmptyArray;
        }
        NSMutableArray result = new NSMutableArray();
        result.addObjectsFromArray(currentApplication.instanceArray());
        EOSortOrdering order = new EOSortOrdering("id", EOSortOrdering.CompareAscending);
        EOSortOrdering.sortArrayUsingKeyOrderArray((NSMutableArray)result, (NSArray)new NSArray((Object)order));
        instancesArray = result;
        if (!page.displayGroup.allObjects().equals((Object)instancesArray)) {
            page.displayGroup.setObjectArray(instancesArray);
        }
        if (selected != null) {
            NSMutableArray active = new NSMutableArray();
            for (MInstance instance : selected) {
                if (!instancesArray.containsObject((Object)instance)) continue;
                active.addObject((Object)instance);
            }
            page.displayGroup.setSelectedObjects((NSArray)active);
        } else {
            page.displayGroup.setSelectedObjects(page.displayGroup.allObjects());
        }
        return page;
    }

    public static AppDetailPage create(WOContext context, MApplication currentApplication) {
        NSArray<MInstance> selected = context.page() instanceof AppDetailPage ? ((AppDetailPage)context.page()).selectedInstances() : null;
        return AppDetailPage.create(context, currentApplication, selected);
    }
}

