/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.monitor.application;

import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WODirectAction;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSPropertyListSerialization;
import com.webobjects.monitor._private.MApplication;
import com.webobjects.monitor._private.MHost;
import com.webobjects.monitor._private.MInstance;
import com.webobjects.monitor._private.MSiteConfig;
import com.webobjects.monitor.application.WOTaskdHandler;

public class DirectAction
extends WODirectAction {
    public DirectAction(WORequest aRequest) {
        super(aRequest);
    }

    public WOComponent MainAction() {
        return this.pageWithName("Main");
    }

    protected MSiteConfig siteConfig() {
        return WOTaskdHandler.siteConfig();
    }

    private Object nonNull(Object value) {
        if (value == null) {
            return "";
        }
        return value;
    }

    private NSDictionary historyEntry(MApplication app) {
        NSMutableDictionary result = new NSMutableDictionary();
        result.setObjectForKey((Object)app.name(), (Object)"applicationName");
        NSArray allInstances = app.instanceArray();
        result.setObjectForKey((Object)new Integer(allInstances.count()), (Object)"configuredInstances");
        int runningInstances = 0;
        int refusingInstances = 0;
        NSMutableArray instances = new NSMutableArray();
        for (MInstance instance : allInstances) {
            if (instance.isRunning_M()) {
                ++runningInstances;
                instances.addObject((Object)instance);
            }
            if (!instance.isRefusingNewSessions()) continue;
            ++refusingInstances;
        }
        result.setObjectForKey((Object)new Integer(runningInstances), (Object)"runningInstances");
        result.setObjectForKey((Object)new Integer(refusingInstances), (Object)"refusingInstances");
        result.setObjectForKey(this.nonNull(app.instanceArray().valueForKeyPath("@sum.activeSessionsValue")), (Object)"sumSessions");
        result.setObjectForKey(this.nonNull(app.instanceArray().valueForKeyPath("@max.activeSessionsValue")), (Object)"maxSessions");
        result.setObjectForKey(this.nonNull(app.instanceArray().valueForKeyPath("@avg.activeSessionsValue")), (Object)"avgSessions");
        result.setObjectForKey(this.nonNull(app.instanceArray().valueForKeyPath("@sum.transactionsValue")), (Object)"sumTransactions");
        result.setObjectForKey(this.nonNull(app.instanceArray().valueForKeyPath("@max.transactionsValue")), (Object)"maxTransactions");
        result.setObjectForKey(this.nonNull(app.instanceArray().valueForKeyPath("@avg.transactionsValue")), (Object)"avgTransactions");
        result.setObjectForKey(this.nonNull(app.instanceArray().valueForKeyPath("@max.avgTransactionTimeValue")), (Object)"maxAvgTransactionTime");
        result.setObjectForKey(this.nonNull(app.instanceArray().valueForKeyPath("@avg.avgTransactionTimeValue")), (Object)"avgAvgTransactionTime");
        result.setObjectForKey(this.nonNull(app.instanceArray().valueForKeyPath("@max.avgIdleTimeValue")), (Object)"maxAvgIdleTime");
        result.setObjectForKey(this.nonNull(app.instanceArray().valueForKeyPath("@avg.avgIdleTimeValue")), (Object)"avgAvgIdleTime");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WOResponse statisticsAction() {
        WOResponse response = new WOResponse();
        String pw = this.context().request().stringFormValueForKey("pw");
        if (this.siteConfig().compareStringWithPassword(pw)) {
            WOTaskdHandler handler = new WOTaskdHandler(new WOTaskdHandler.ErrorCollector(){

                @Override
                public void addObjectsFromArrayIfAbsentToErrorMessageArray(NSArray<String> aErrors) {
                }
            });
            handler.startReading();
            try {
                NSMutableArray stats = new NSMutableArray();
                for (MApplication app : this.siteConfig().applicationArray()) {
                    handler.getInstanceStatusForHosts((NSArray<MHost>)app.hostArray());
                    NSDictionary appStats = this.historyEntry(app);
                    stats.addObject((Object)appStats);
                }
                response.appendContentString(NSPropertyListSerialization.stringFromPropertyList((Object)stats));
            }
            finally {
                handler.endReading();
            }
        }
        return response;
    }
}

