/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.monitor.application;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOHTTPConnection;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.monitor._private.MHost;
import com.webobjects.monitor._private.MObject;
import com.webobjects.monitor._private.String_Extensions;
import com.webobjects.monitor.application.ConfirmationPage;
import com.webobjects.monitor.application.HostConfigurePage;
import com.webobjects.monitor.application.MonitorComponent;
import com.webobjects.monitor.application.WotaskdInfoPage;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;

public class HostsPage
extends MonitorComponent {
    private static final long serialVersionUID = -4009657723964398636L;
    public MHost currentHost;
    public String newHostName;
    public String hostTypeSelection;
    public NSArray hostTypeList = MObject.hostTypeArray;

    public HostsPage(WOContext aWocontext) {
        super(aWocontext);
        this.handler().updateForPage(this.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WOComponent addHostClicked() {
        String nullOrError = null;
        if (this.newHostName != null && this.newHostName.length() > 0 && String_Extensions.isValidXMLString((String)this.newHostName)) {
            try {
                InetAddress anAddress = InetAddress.getByName(this.newHostName);
                this.handler().startWriting();
                try {
                    if (this.newHostName.equalsIgnoreCase("localhost") || this.newHostName.equals("127.0.0.1")) {
                        if (this.siteConfig().hostArray() == null || this.siteConfig().hostArray().count() != 0) {
                            nullOrError = "Hosts named localhost or 127.0.0.1 may not be added while other hosts are configured.";
                        }
                    } else if (this.siteConfig().localhostOrLoopbackHostExists()) {
                        nullOrError = "Additional hosts may not be added while a host named localhost or 127.0.0.1 is configured.";
                    }
                    if (nullOrError == null && this.siteConfig().hostWithAddress(anAddress) == null) {
                        if (this.hostMeetsMinimumVersion(anAddress)) {
                            MHost host = new MHost(this.siteConfig(), this.newHostName, this.hostTypeSelection.toUpperCase());
                            NSArray tempHostArray = new NSArray((NSArray)this.siteConfig().hostArray());
                            this.siteConfig().addHost_M(host);
                            this.handler().sendOverwriteToWotaskd(host);
                            if (tempHostArray.count() != 0) {
                                this.handler().sendAddHostToWotaskds(host, tempHostArray);
                            }
                        } else {
                            this.mySession().addErrorIfAbsent("The wotaskd on " + this.newHostName + " is an older version, please upgrade before adding...");
                        }
                    } else if (nullOrError != null) {
                        this.mySession().addErrorIfAbsent(nullOrError);
                    } else {
                        this.mySession().addErrorIfAbsent("The host " + this.newHostName + " has already been added");
                    }
                }
                finally {
                    this.handler().endWriting();
                }
            }
            catch (UnknownHostException ex) {
                this.mySession().addErrorIfAbsent("ERROR: Cannot find IP address for hostname: " + this.newHostName);
            }
        } else {
            this.mySession().addErrorIfAbsent(this.newHostName + " is not a valid hostname");
        }
        this.newHostName = null;
        return HostsPage.create(this.context());
    }

    public WOComponent removeHostClicked() {
        final MHost host = this.currentHost;
        return ConfirmationPage.create(this.context(), new ConfirmationPage.Delegate(){

            public WOComponent cancel() {
                return HostsPage.create(HostsPage.this.context());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public WOComponent confirm() {
                HostsPage.this.handler().startWriting();
                try {
                    HostsPage.this.siteConfig().removeHost_M(host);
                    NSMutableArray tempHostArray = new NSMutableArray((NSArray)HostsPage.this.siteConfig().hostArray());
                    tempHostArray.addObject((Object)host);
                    HostsPage.this.handler().sendRemoveHostToWotaskds(host, (NSArray)tempHostArray);
                }
                finally {
                    HostsPage.this.handler().endWriting();
                }
                return HostsPage.create(HostsPage.this.context());
            }

            public String explaination() {
                return "Selecting 'Yes' will shutdown any running instances of this host, and remove those instance configurations.";
            }

            public int pageType() {
                return 1;
            }

            public String question() {
                return "Are you sure you want to delete the host <I>" + host.name() + "</I>?";
            }
        });
    }

    public WOComponent configureHostClicked() {
        return HostConfigurePage.create(this.context(), this.currentHost);
    }

    public WOComponent displayWotaskdInfoClicked() {
        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)0x400000L)) {
            NSLog.debug.appendln((Object)"!@#$!@#$ displayWotaskdInfoClicked creates a WOHTTPConnection");
        }
        WotaskdInfoPage aPage = (WotaskdInfoPage)this.pageWithName("WotaskdInfoPage");
        WORequest aRequest = new WORequest(MObject._POST, "/", MObject._HTTP1, this.siteConfig().passwordDictionary(), null, null);
        WOResponse aResponse = null;
        try {
            WOHTTPConnection anHTTPConnection = new WOHTTPConnection(this.currentHost.name(), this.theApplication.lifebeatDestinationPort());
            anHTTPConnection.setReceiveTimeout(10000);
            if (anHTTPConnection.sendRequest(aRequest)) {
                aResponse = anHTTPConnection.readResponse();
            }
        }
        catch (Throwable localException) {
            NSLog._conditionallyLogPrivateException((Throwable)localException);
        }
        aPage.wotaskdText = aResponse == null ? "Failed to get response from wotaskd " + this.currentHost.name() + ": " + WOApplication.application().lifebeatDestinationPort() : aResponse.contentString();
        return aPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hostMeetsMinimumVersion(InetAddress anAddress) {
        block15: {
            boolean bl;
            byte[] versionRequest;
            try {
                versionRequest = "womp://queryVersion".getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                versionRequest = "womp://queryVersion".getBytes();
            }
            DatagramPacket outgoingPacket = new DatagramPacket(versionRequest, versionRequest.length, anAddress, WOApplication.application().lifebeatDestinationPort());
            byte[] mbuffer = new byte[1000];
            DatagramPacket incomingPacket = new DatagramPacket(mbuffer, mbuffer.length);
            DatagramSocket socket = null;
            try {
                socket = new DatagramSocket();
                socket.send(outgoingPacket);
                incomingPacket.setLength(mbuffer.length);
                socket.setSoTimeout(2000);
                socket.receive(incomingPacket);
                String reply = new String(incomingPacket.getData());
                if (reply.startsWith("womp://replyVersion/")) {
                    int lastIndex = reply.lastIndexOf(":webObjects");
                    String version = reply.substring(lastIndex += 11);
                    if (version.equals("4.5")) {
                        boolean bl2 = false;
                        return bl2;
                    }
                    break block15;
                }
                boolean bl3 = false;
                return bl3;
            }
            catch (InterruptedIOException iioe) {
                bl = true;
                return bl;
            }
            catch (SocketException se) {
                bl = true;
                return bl;
            }
            catch (Throwable e) {
                bl = false;
                return bl;
            }
            finally {
                if (socket != null) {
                    socket.close();
                }
            }
        }
        return true;
    }

    public static HostsPage create(WOContext context) {
        return (HostsPage)context.page().pageWithName(HostsPage.class.getName());
    }
}

