/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.monitor.application;

import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOResourceManager;
import com.webobjects.appserver.WOResponse;
import com.webobjects.monitor.application.ApplicationsPage;
import com.webobjects.monitor.application.ConfigurePage;
import com.webobjects.monitor.application.HostsPage;
import com.webobjects.monitor.application.MonitorComponent;
import com.webobjects.monitor.application.PrefsPage;
import er.ajax.AjaxUtils;
import er.extensions.foundation.ERXProperties;

public class NavigationPage
extends MonitorComponent {
    private static final long serialVersionUID = 338657623393333855L;
    private static final String _appBarImageName = "applications_bar.gif";
    private static final String _hostBarImageName = "hosts_bar.gif";
    private static final String _siteBarImageName = "site_bar.gif";
    private static final String _prefBarImageName = "preferences_bar.gif";
    private static final String _helpBarImageName = "help_bar.gif";
    private static final String _migrationBarImageName = "migration_bar.gif";
    private static final String[] _barImageNames = new String[]{"applications_bar.gif", "hosts_bar.gif", "site_bar.gif", "preferences_bar.gif", "help_bar.gif", "migration_bar.gif"};
    private static final String _appActiveImageName = "applications_tab_active.gif";
    private static final String _hostActiveImageName = "hosts_tab_active.gif";
    private static final String _siteActiveImageName = "site_tab_active.gif";
    private static final String _prefActiveImageName = "preferences_tab_active.gif";
    private static final String _helpActiveImageName = "help_tab_active.gif";
    private static final String _migrationActiveImageName = "migration_tab_active.gif";
    private static final String _appInactiveImageName = "applications_tab_inactive.gif";
    private static final String _hostInactiveImageName = "hosts_tab_inactive.gif";
    private static final String _siteInactiveImageName = "site_tab_inactive.gif";
    private static final String _prefInactiveImageName = "preferences_tab_inactive.gif";
    private static final String _helpInactiveImageName = "help_tab_inactive.gif";
    private static final String _migrationInActiveImageName = "migration_tab_inactive.gif";
    public String appleImageName = "AppleLogo.gif";
    public String backgroundImageName = "background.gif";
    public int currentPage = 0;
    public String title;
    public String pageId;

    public NavigationPage(WOContext aWocontext) {
        super(aWocontext);
    }

    public void appendToResponse(WOResponse response, WOContext context) {
        super.appendToResponse(response, context);
        AjaxUtils.addScriptResourceInHead((WOContext)context, (WOResponse)response, (String)"Ajax", (String)"prototype.js");
    }

    public String pageTitle() {
        return "WOMonitor: " + this.title;
    }

    public String barImageName() {
        return _barImageNames[this.currentPage];
    }

    public String appImageName() {
        return this.currentPage == 0 ? _appActiveImageName : _appInactiveImageName;
    }

    public String hostImageName() {
        return this.currentPage == 1 ? _hostActiveImageName : _hostInactiveImageName;
    }

    public String siteImageName() {
        return this.currentPage == 2 ? _siteActiveImageName : _siteInactiveImageName;
    }

    public String prefImageName() {
        return this.currentPage == 3 ? _prefActiveImageName : _prefInactiveImageName;
    }

    public String helpImageName() {
        return this.currentPage == 4 ? _helpActiveImageName : _helpInactiveImageName;
    }

    public String migrationImageName() {
        return this.currentPage == 5 ? _migrationActiveImageName : _migrationInActiveImageName;
    }

    public String backgroundImageSrc() {
        WOResourceManager aResourceManager = this.application().resourceManager();
        return aResourceManager.urlForResourceNamed(this.backgroundImageName, null, null, this.context().request());
    }

    public WOComponent ApplicationsPageClicked() {
        return ApplicationsPage.create(this.context());
    }

    public WOComponent HostsPageClicked() {
        return HostsPage.create(this.context());
    }

    public WOComponent ConfigurePageClicked() {
        return ConfigurePage.create(this.context());
    }

    public WOComponent PrefsPageClicked() {
        return PrefsPage.create(this.context());
    }

    public WOComponent HelpPageClicked() {
        return this.pageWithName("HelpPage");
    }

    public WOComponent MigrationPageClicked() {
        return this.pageWithName("MigrationPage");
    }

    public boolean logoutRequired() {
        return this.siteConfig() != null && this.mySession().isLoggedIn() && this.siteConfig().isPasswordRequired();
    }

    public WOComponent logoutClicked() {
        this.mySession().setIsLoggedIn(false);
        return this.pageWithName("Main");
    }

    public boolean showMigrationsTab() {
        return ERXProperties.booleanForKeyWithDefault((String)"er.javamonitor.showMigrationsTab", (boolean)false);
    }
}

