/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.monitor.application;

import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation._NSThreadsafeMutableArray;
import com.webobjects.foundation._NSThreadsafeMutableDictionary;
import com.webobjects.monitor._private.MSiteConfig;
import com.webobjects.monitor.application.Main;
import com.webobjects.monitor.application.WOTaskdHandler;
import er.extensions.appserver.ERXSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Session
extends ERXSession
implements WOTaskdHandler.ErrorCollector {
    private static final long serialVersionUID = 8067267944038698356L;
    public boolean _isLoggedIn = false;
    private _NSThreadsafeMutableArray errorMessageArray = new _NSThreadsafeMutableArray(new NSMutableArray());

    public boolean isLoggedIn() {
        return this._isLoggedIn;
    }

    public void setIsLoggedIn(boolean aBOOL) {
        this._isLoggedIn = aBOOL;
    }

    protected MSiteConfig siteConfig() {
        return WOTaskdHandler.siteConfig();
    }

    public void appendToResponse(WOResponse aResponse, WOContext aContext) {
        MSiteConfig aMonitorConfig = this.siteConfig();
        if (aMonitorConfig == null || aMonitorConfig.isPasswordRequired()) {
            if (this._isLoggedIn) {
                super.appendToResponse(aResponse, aContext);
            } else if (aContext.page().getClass().getName().equals(Main.class.getName())) {
                super.appendToResponse(aResponse, aContext);
            } else {
                NSLog.err.appendln((Object)("Tried to access " + aContext.page() + " while not logged in."));
            }
        } else {
            super.appendToResponse(aResponse, aContext);
        }
    }

    public void addErrorIfAbsent(String message) {
        this.errorMessageArray.addObjectIfAbsent((Object)message);
    }

    public String message() {
        NSArray globalArray;
        String _message = null;
        if (this.siteConfig() != null && (globalArray = this.siteConfig().globalErrorDictionary.allValues()) != null && globalArray.count() > 0) {
            this.addObjectsFromArrayIfAbsentToErrorMessageArray((NSArray<String>)globalArray);
            this.siteConfig().globalErrorDictionary = new _NSThreadsafeMutableDictionary(new NSMutableDictionary());
        }
        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)0x400000L)) {
            NSLog.debug.appendln((Object)("message(): " + this.errorMessageArray.array()));
        }
        if (this.errorMessageArray != null && this.errorMessageArray.count() > 0) {
            _message = this.errorMessageArray.componentsJoinedByString(", ");
            this.errorMessageArray = new _NSThreadsafeMutableArray(new NSMutableArray());
        }
        NSLog.out.appendln((Object)("Session.message: " + _message));
        return _message;
    }

    @Override
    public void addObjectsFromArrayIfAbsentToErrorMessageArray(NSArray<String> anArray) {
        if (anArray != null && anArray.count() > 0) {
            int arrayCount = anArray.count();
            for (int i = 0; i < arrayCount; ++i) {
                this.addErrorIfAbsent((String)anArray.objectAtIndex(i));
            }
        }
    }
}

