/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.monitor.application.starter;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.monitor._private.MApplication;
import com.webobjects.monitor._private.MHost;
import com.webobjects.monitor._private.MInstance;
import com.webobjects.monitor.application.starter.ApplicationStarter;

public class GracefulBouncer
extends ApplicationStarter {
    public GracefulBouncer(MApplication app) {
        super(app);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bounce() throws InterruptedException {
        NSArray currentInstances;
        NSArray instances = this.application().instanceArray().immutableClone();
        NSMutableArray runningInstances = new NSMutableArray();
        NSMutableSet activeHosts = new NSMutableSet();
        NSMutableDictionary inactiveInstancesByHost = new NSMutableDictionary();
        NSMutableDictionary activeInstancesByHost = new NSMutableDictionary();
        for (MInstance instance : instances) {
            NSMutableArray currentInstances2;
            MHost host = instance.host();
            if (instance.isRunning_M()) {
                runningInstances.addObject((Object)instance);
                activeHosts.addObject((Object)host);
                currentInstances2 = (NSMutableArray)activeInstancesByHost.objectForKey((Object)host);
                if (currentInstances2 == null) {
                    currentInstances2 = new NSMutableArray();
                    activeInstancesByHost.setObjectForKey((Object)currentInstances2, (Object)host);
                }
                currentInstances2.addObject((Object)instance);
                continue;
            }
            currentInstances2 = (NSMutableArray)inactiveInstancesByHost.objectForKey((Object)host);
            if (currentInstances2 == null) {
                currentInstances2 = new NSMutableArray();
                inactiveInstancesByHost.setObjectForKey((Object)currentInstances2, (Object)host);
            }
            currentInstances2.addObject((Object)instance);
        }
        int numToStartPerHost = 1;
        if (activeHosts.count() > 0) {
            numToStartPerHost = (int)((double)(runningInstances.count() / activeHosts.count()) * 0.1);
        }
        if (numToStartPerHost < 1) {
            numToStartPerHost = 1;
        }
        boolean useScheduling = true;
        for (MInstance instance : runningInstances) {
            useScheduling &= instance.schedulingEnabled() != null && instance.schedulingEnabled() != false;
        }
        NSMutableArray startingInstances = new NSMutableArray();
        for (int i = 0; i < numToStartPerHost; ++i) {
            for (MHost host : activeHosts) {
                NSArray inactiveInstances = (NSArray)inactiveInstancesByHost.objectForKey((Object)host);
                if (inactiveInstances != null && inactiveInstances.count() >= i) {
                    MInstance instance = (MInstance)inactiveInstances.objectAtIndex(i);
                    this.log("Adding instance " + instance.displayName() + " on host " + host.addressAsString());
                    startingInstances.addObject((Object)instance);
                    continue;
                }
                this.log("Not enough instances on host: " + host.addressAsString());
            }
        }
        for (MInstance instance : startingInstances) {
            if (useScheduling) {
                instance.setSchedulingEnabled(Boolean.TRUE);
                continue;
            }
            instance.setAutoRecover(Boolean.TRUE);
        }
        this.handler().sendUpdateInstancesToWotaskds((NSArray<MInstance>)startingInstances, activeHosts.allObjects());
        this.handler().sendStartInstancesToWotaskds((NSArray<MInstance>)startingInstances, (NSArray<MHost>)activeHosts.allObjects());
        boolean waiting = true;
        while (waiting) {
            this.handler().startReading();
            try {
                this.log("Checking for started instances");
                this.handler().getInstanceStatusForHosts((NSArray<MHost>)activeHosts.allObjects());
                boolean allStarted = true;
                for (MInstance instance : startingInstances) {
                    allStarted &= instance.isRunning_M();
                }
                if (allStarted) {
                    waiting = false;
                    continue;
                }
                GracefulBouncer.sleep(10000L);
            }
            finally {
                this.handler().endReading();
            }
        }
        this.log("Started instances sucessfully");
        for (MHost host : activeHosts) {
            currentInstances = (NSArray)activeInstancesByHost.objectForKey((Object)host);
            for (MInstance instance : currentInstances) {
                if (useScheduling) {
                    instance.setSchedulingEnabled(Boolean.FALSE);
                    continue;
                }
                instance.setAutoRecover(Boolean.FALSE);
            }
        }
        this.handler().sendUpdateInstancesToWotaskds((NSArray<MInstance>)runningInstances, activeHosts.allObjects());
        for (MHost host : activeHosts) {
            currentInstances = (NSArray)activeInstancesByHost.objectForKey((Object)host);
            for (MInstance instance : currentInstances) {
                instance.setRefusingNewSessions(true);
            }
        }
        this.handler().sendRefuseSessionToWotaskds((NSArray<MInstance>)runningInstances, (NSArray<MHost>)activeHosts.allObjects(), true);
        this.log("Refused new sessions: " + runningInstances);
        NSMutableArray restarting = new NSMutableArray();
        for (MHost host : activeHosts) {
            NSArray currentInstances3 = (NSArray)activeInstancesByHost.objectForKey((Object)host);
            for (int i = 0; i < currentInstances3.count() - numToStartPerHost; ++i) {
                MInstance instance = (MInstance)currentInstances3.objectAtIndex(i);
                if (useScheduling) {
                    instance.setSchedulingEnabled(Boolean.TRUE);
                } else {
                    instance.setAutoRecover(Boolean.TRUE);
                }
                restarting.addObject((Object)instance);
            }
        }
        this.handler().sendUpdateInstancesToWotaskds((NSArray<MInstance>)restarting, activeHosts.allObjects());
        this.log("Started scheduling again: " + restarting);
        this.handler().startReading();
        try {
            this.handler().getInstanceStatusForHosts((NSArray<MHost>)activeHosts.allObjects());
            this.log("Finished");
        }
        finally {
            this.handler().endReading();
        }
    }
}

