/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.monitor.application.starter;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.monitor._private.MApplication;
import com.webobjects.monitor._private.MHost;
import com.webobjects.monitor._private.MInstance;
import com.webobjects.monitor.application.starter.ApplicationStarter;

public class ShutdownBouncer
extends ApplicationStarter {
    private long _time;

    public ShutdownBouncer(MApplication app, int seconds) {
        super(app);
        this._time = seconds * 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bounce() throws InterruptedException {
        NSArray instances = this.application().instanceArray().immutableClone();
        NSMutableArray runningInstances = new NSMutableArray();
        NSMutableSet activeHosts = new NSMutableSet();
        for (MInstance instance : instances) {
            MHost host = instance.host();
            if (!instance.isRunning_M()) continue;
            runningInstances.addObject((Object)instance);
            activeHosts.addObject((Object)host);
        }
        this.handler().sendRefuseSessionToWotaskds((NSArray<MInstance>)runningInstances, (NSArray<MHost>)activeHosts.allObjects(), true);
        boolean waiting = true;
        long startTime = System.currentTimeMillis();
        while (waiting && this._time + startTime > System.currentTimeMillis()) {
            this.handler().startReading();
            try {
                this.log("Checking for started instances");
                this.handler().getInstanceStatusForHosts((NSArray<MHost>)activeHosts.allObjects());
                boolean allStopped = false;
                for (MInstance instance : runningInstances) {
                    allStopped &= !instance.isRunning_M();
                }
                if (allStopped) {
                    waiting = false;
                    continue;
                }
                ShutdownBouncer.sleep(10000L);
            }
            finally {
                this.handler().endReading();
            }
        }
        this.handler().sendStopInstancesToWotaskds((NSArray<MInstance>)runningInstances, (NSArray<MHost>)activeHosts.allObjects());
        this.log("Stopped instances sucessfully");
        this.handler().sendRefuseSessionToWotaskds((NSArray<MInstance>)runningInstances, (NSArray<MHost>)activeHosts.allObjects(), false);
        this.handler().sendStartInstancesToWotaskds((NSArray<MInstance>)runningInstances, (NSArray<MHost>)activeHosts.allObjects());
        this.handler().startReading();
        try {
            this.handler().getInstanceStatusForHosts((NSArray<MHost>)activeHosts.allObjects());
            this.log("Finished");
        }
        finally {
            this.handler().endReading();
        }
    }
}

