/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.ashwood.dbutil;

import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.objectstyle.ashwood.dbutil.Column;
import org.objectstyle.ashwood.dbutil.ForeignKey;
import org.objectstyle.ashwood.dbutil.PrimaryKey;

public class Table
implements Serializable {
    private String catalog;
    private String schema;
    private String name;
    private Collection columns = new ArrayList(1);
    private Collection foreignKeys = new ArrayList(1);
    private Collection primaryKeys = new ArrayList(1);

    public Table() {
    }

    public Table(String string, String string2, String string3) {
        this.setCatalog(string);
        this.setSchema(string2);
        this.setName(string3);
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String string) {
        this.catalog = string;
    }

    public void setSchema(String string) {
        this.schema = string;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return StringUtils.defaultString(this.name);
    }

    public static String composeFullName(String string, String string2, String string3) {
        return StringUtils.defaultString(string) + '.' + StringUtils.defaultString(string2) + '.' + StringUtils.defaultString(string3);
    }

    public String getFullName() {
        return Table.composeFullName(this.catalog, this.schema, this.name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void refreshColumns(DatabaseMetaData databaseMetaData) throws SQLException {
        this.columns.clear();
        ResultSet resultSet = null;
        try {
            resultSet = databaseMetaData.getColumns(this.catalog, this.schema, this.name, null);
            while (resultSet.next()) {
                Column column = new Column();
                this.columns.add(column);
                column.setOwner(this);
                column.setName(resultSet.getString("COLUMN_NAME"));
                column.setDataType(resultSet.getInt("DATA_TYPE"));
                column.setTypeName(resultSet.getString("TYPE_NAME"));
                column.setSize(resultSet.getInt("COLUMN_SIZE"));
                column.setDecimalDigits(resultSet.getInt("DECIMAL_DIGITS"));
                column.setRadix(resultSet.getInt("NUM_PREC_RADIX"));
                column.setNullable(resultSet.getInt("NULLABLE"));
                column.setRemarks(resultSet.getString("REMARKS"));
                column.setDefaultValue(resultSet.getString("COLUMN_DEF"));
                column.setCharOctetLength(resultSet.getInt("CHAR_OCTET_LENGTH"));
                column.setOrdinalPosition(resultSet.getInt("ORDINAL_POSITION"));
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                resultSet.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        resultSet.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void refreshPrimaryKeys(DatabaseMetaData databaseMetaData) throws SQLException {
        this.primaryKeys.clear();
        ResultSet resultSet = null;
        try {
            resultSet = databaseMetaData.getPrimaryKeys(this.catalog, this.schema, this.name);
            while (resultSet.next()) {
                PrimaryKey primaryKey = new PrimaryKey();
                this.primaryKeys.add(primaryKey);
                primaryKey.setOwner(this);
                primaryKey.setColumnName(resultSet.getString("COLUMN_NAME"));
                primaryKey.setKeySequence(resultSet.getShort("KEY_SEQ"));
                primaryKey.setName(resultSet.getString("PK_NAME"));
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                resultSet.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        resultSet.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void refreshForeignKeys(DatabaseMetaData databaseMetaData) throws SQLException {
        this.foreignKeys.clear();
        ResultSet resultSet = null;
        try {
            resultSet = databaseMetaData.getImportedKeys(this.catalog, this.schema, this.name);
            while (resultSet.next()) {
                ForeignKey foreignKey = new ForeignKey();
                this.foreignKeys.add(foreignKey);
                foreignKey.setOwner(this);
                foreignKey.setPkTableCatalog(resultSet.getString("PKTABLE_CAT"));
                foreignKey.setPkTableSchema(resultSet.getString("PKTABLE_SCHEM"));
                foreignKey.setPkTableName(resultSet.getString("PKTABLE_NAME"));
                foreignKey.setPkColumnName(resultSet.getString("PKCOLUMN_NAME"));
                foreignKey.setColumnName(resultSet.getString("FKCOLUMN_NAME"));
                foreignKey.setKeySequence(resultSet.getShort("KEY_SEQ"));
                foreignKey.setUpdateRule(resultSet.getShort("UPDATE_RULE"));
                foreignKey.setDeleteRule(resultSet.getShort("DELETE_RULE"));
                foreignKey.setName(resultSet.getString("FK_NAME"));
                foreignKey.setPkName(resultSet.getString("PK_NAME"));
                foreignKey.setDeferrability(resultSet.getShort("DEFERRABILITY"));
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                resultSet.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        resultSet.close();
        return;
    }

    public void refresh(DatabaseMetaData databaseMetaData) throws SQLException {
        this.refreshColumns(databaseMetaData);
        this.refreshPrimaryKeys(databaseMetaData);
        this.refreshForeignKeys(databaseMetaData);
    }

    public Collection getPrimaryKeys() {
        return Collections.unmodifiableCollection(this.primaryKeys);
    }

    public Collection getForeignKeys() {
        return Collections.unmodifiableCollection(this.foreignKeys);
    }

    public Collection getColumns() {
        return Collections.unmodifiableCollection(this.columns);
    }

    public void addColumn(Column column) {
        this.columns.add(column);
        column.setOwner(this);
    }

    public boolean removeColumn(Column column) {
        column.setOwner(null);
        return this.columns.remove(column);
    }

    public void addPrimaryKey(PrimaryKey primaryKey) {
        this.primaryKeys.add(primaryKey);
        primaryKey.setOwner(this);
    }

    public boolean removePrimaryKey(PrimaryKey primaryKey) {
        primaryKey.setOwner(null);
        return this.primaryKeys.remove(primaryKey);
    }

    public void addForeignKey(ForeignKey foreignKey) {
        this.foreignKeys.add(foreignKey);
        foreignKey.setOwner(this);
    }

    public boolean removeForeignKey(ForeignKey foreignKey) {
        foreignKey.setOwner(null);
        return this.foreignKeys.remove(foreignKey);
    }

    public void toCreateSQL(PrintWriter printWriter) {
        Serializable serializable;
        Iterator iterator;
        printWriter.println("CREATE TABLE " + this.name + " (");
        Iterator iterator2 = this.columns.iterator();
        while (iterator2.hasNext()) {
            iterator = (Column)iterator2.next();
            printWriter.print("  " + ((Column)((Object)iterator)).getName() + " " + ((Column)((Object)iterator)).getTypeName());
            if (((Column)((Object)iterator)).getNullable() == 0) {
                printWriter.print(" NOT NULL");
            }
            if (!iterator2.hasNext()) continue;
            printWriter.println(',');
        }
        if (!this.primaryKeys.isEmpty()) {
            printWriter.println(',');
            iterator = this.primaryKeys.iterator();
            serializable = (PrimaryKey)iterator.next();
            printWriter.print("  ");
            if (((PrimaryKey)serializable).getName() != null) {
                printWriter.print("CONSTRAINT " + ((PrimaryKey)serializable).getName() + " ");
            }
            printWriter.print("PRIMARY KEY (" + ((PrimaryKey)serializable).getColumnName());
            while (iterator.hasNext()) {
                serializable = (PrimaryKey)iterator.next();
                printWriter.print(", " + ((PrimaryKey)serializable).getColumnName());
            }
            printWriter.print(")");
        }
        if (!this.foreignKeys.isEmpty()) {
            printWriter.println(',');
            iterator = this.foreignKeys.iterator();
            while (iterator.hasNext()) {
                serializable = (ForeignKey)iterator.next();
                printWriter.print("  ");
                if (((ForeignKey)serializable).getName() != null) {
                    printWriter.print("CONSTRAINT " + ((ForeignKey)serializable).getName() + " ");
                }
                printWriter.print("FOREIGN KEY (" + ((ForeignKey)serializable).getColumnName() + ") REFERENCES " + ((ForeignKey)serializable).getPkTableName());
                if (((ForeignKey)serializable).getPkColumnName() != null) {
                    printWriter.print(" (" + ((ForeignKey)serializable).getPkColumnName() + ")");
                }
                if (!iterator.hasNext()) continue;
                printWriter.println(',');
            }
        }
        printWriter.println();
        printWriter.print(")");
    }

    public void toDropSQL(PrintWriter printWriter) {
        printWriter.print("DROP TABLE " + this.name + " CASCADE CONSTRAINTS");
    }
}

