/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.ashwood.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.iterators.TransformIterator;
import org.objectstyle.ashwood.graph.ArcIterator;
import org.objectstyle.ashwood.graph.BreadthFirstSearch;
import org.objectstyle.ashwood.graph.DepthFirstSearch;
import org.objectstyle.ashwood.graph.DepthFirstStampSearch;
import org.objectstyle.ashwood.graph.Digraph;
import org.objectstyle.ashwood.graph.DigraphIteration;
import org.objectstyle.ashwood.graph.LoopSearch;
import org.objectstyle.ashwood.graph.ReversedIteration;
import org.objectstyle.ashwood.graph.TransformArcIterator;
import org.objectstyle.ashwood.predicate.ConstPredicate;
import org.objectstyle.ashwood.util.MutableInteger;

public class GraphUtils {
    public static final Predicate TRUE_PREDICATE = ConstPredicate.TRUE;
    public static final Predicate FALSE_PREDICATE = ConstPredicate.FALSE;

    private GraphUtils() {
    }

    public static boolean isConnected(DigraphIteration digraphIteration, Object object, int n) {
        DepthFirstSearch depthFirstSearch = new DepthFirstSearch(digraphIteration, object);
        return n == GraphUtils.traverse(depthFirstSearch);
    }

    public static boolean isConnected(Digraph digraph) {
        return GraphUtils.isConnected(digraph, digraph.vertexIterator().next(), digraph.order());
    }

    public static boolean isStronglyConnected(DigraphIteration digraphIteration, Object object, int n) {
        return GraphUtils.isConnected(digraphIteration, object, n) && GraphUtils.isConnected(new ReversedIteration(digraphIteration), object, n);
    }

    public static boolean isStronglyConnected(Digraph digraph) {
        return GraphUtils.isStronglyConnected(digraph, digraph.vertexIterator().next(), digraph.order());
    }

    public static int traverse(Iterator iterator) {
        int n = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++n;
        }
        return n;
    }

    public static boolean hasLoops(Digraph digraph) {
        return GraphUtils.traverse(new LoopSearch(digraph)) != 0;
    }

    public static boolean isAcyclic(Digraph digraph) {
        int n = digraph.order();
        if (n == 0) {
            return true;
        }
        HashSet hashSet = new HashSet(n);
        DepthFirstStampSearch depthFirstStampSearch = new DepthFirstStampSearch(digraph, digraph.vertexIterator().next());
        Iterator iterator = digraph.vertexIterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (hashSet.contains(e)) continue;
            depthFirstStampSearch.reset(e);
            Map map = depthFirstStampSearch.traverse(new HashMap(digraph.order()));
            Iterator iterator2 = map.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry = iterator2.next();
                Object k = entry.getKey();
                DepthFirstStampSearch.OrderPair orderPair = (DepthFirstStampSearch.OrderPair)entry.getValue();
                hashSet.add(k);
                ArcIterator arcIterator = digraph.outgoingIterator(k);
                while (arcIterator.hasNext()) {
                    arcIterator.next();
                    Object object = arcIterator.getDestination();
                    DepthFirstStampSearch.OrderPair orderPair2 = (DepthFirstStampSearch.OrderPair)map.get(object);
                    if (orderPair2.getPostOrder() <= orderPair.getPostOrder()) continue;
                    return false;
                }
            }
            if (map.size() == n) break;
        }
        return true;
    }

    public static Digraph randomize(Digraph digraph, int n, int n2, Random random) {
        int n3 = 1;
        while (n3 <= n) {
            digraph.addVertex(new Integer(n3));
            ++n3;
        }
        Random random2 = random;
        int n4 = n * n;
        n2 = Math.min(n2, n4);
        int n5 = 1;
        while (n5 <= n2) {
            int n6 = random2.nextInt(n4);
            int n7 = n6 / n + 1;
            int n8 = n6 % n + 1;
            digraph.putArc(new Integer(n7), new Integer(n8), new Integer(n5));
            ++n5;
        }
        return digraph;
    }

    public static Digraph randomizeAcyclic(Digraph digraph, int n, int n2, int n3, Random random) {
        Random random2 = random;
        int n4 = 1;
        int n5 = 1;
        while (n5 <= n) {
            Integer n6 = new Integer(n5);
            digraph.addVertex(n6);
            int n7 = 0;
            while (n7 < n2) {
                Integer n8;
                int n9 = random2.nextInt(n5);
                if (n9 != 0 && digraph.outgoingSize(n8 = new Integer(n9)) < n3) {
                    digraph.putArc(n8, n6, new Integer(n4++));
                }
                ++n7;
            }
            ++n5;
        }
        return digraph;
    }

    public static Digraph randomizeTree(Digraph digraph, int n, int n2, Random random) {
        int n3 = 1;
        Integer n4 = new Integer(n3);
        List<Integer> list = Collections.singletonList(n4);
        digraph.addVertex(n4);
        int n5 = 1;
        while (n5 < n2) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>(list.size() * n);
            Iterator<Integer> iterator = list.iterator();
            while (iterator.hasNext()) {
                Integer n6 = iterator.next();
                int n7 = random.nextInt(n + 1);
                int n8 = 0;
                while (n8 < n7) {
                    Integer n9 = new Integer(++n3);
                    digraph.addVertex(n9);
                    digraph.putArc(n6, n9, Boolean.TRUE);
                    arrayList.add(n9);
                    ++n8;
                }
            }
            if (arrayList.isEmpty()) break;
            list = arrayList;
            ++n5;
        }
        return digraph;
    }

    public static Digraph transform(Digraph digraph, DigraphIteration digraphIteration, Transformer transformer, Transformer transformer2) {
        TransformIterator transformIterator = new TransformIterator(digraphIteration.vertexIterator(), transformer);
        while (transformIterator.hasNext()) {
            digraph.addVertex(transformIterator.next());
        }
        TransformArcIterator transformArcIterator = new TransformArcIterator(digraphIteration.arcIterator(), transformer, transformer2);
        while (transformArcIterator.hasNext()) {
            Object e = transformArcIterator.next();
            Object object = transformArcIterator.getOrigin();
            Object object2 = transformArcIterator.getDestination();
            digraph.putArc(object, object2, e);
        }
        return digraph;
    }

    public static Digraph merge(Digraph digraph, DigraphIteration digraphIteration) {
        Iterator iterator = digraphIteration.vertexIterator();
        while (iterator.hasNext()) {
            digraph.addVertex(iterator.next());
        }
        ArcIterator arcIterator = digraphIteration.arcIterator();
        while (arcIterator.hasNext()) {
            Object e = arcIterator.next();
            Object object = arcIterator.getOrigin();
            Object object2 = arcIterator.getDestination();
            digraph.putArc(object, object2, e);
        }
        return digraph;
    }

    public static Map computeLevels(Map hashMap, Digraph digraph, boolean bl) {
        if (hashMap == null) {
            hashMap = new HashMap(digraph.order());
        }
        Iterator iterator = digraph.vertexIterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (digraph.incomingSize(e) != 0) continue;
            GraphUtils.computeLevels(hashMap, digraph, e, bl);
        }
        return hashMap;
    }

    public static Map computeLevels(Map hashMap, DigraphIteration digraphIteration, Object object, boolean bl) {
        MutableInteger mutableInteger;
        if (hashMap == null) {
            hashMap = new HashMap<Object, MutableInteger>();
        }
        if ((mutableInteger = (MutableInteger)hashMap.get(object)) == null) {
            mutableInteger = new MutableInteger(0);
            hashMap.put(object, mutableInteger);
        }
        ArcIterator arcIterator = digraphIteration.outgoingIterator(object);
        while (arcIterator.hasNext()) {
            arcIterator.next();
            Object object2 = arcIterator.getDestination();
            int n = mutableInteger.intValue() + 1;
            MutableInteger mutableInteger2 = (MutableInteger)hashMap.get(object2);
            if (mutableInteger2 == null) {
                mutableInteger2 = new MutableInteger(n);
                hashMap.put(object2, mutableInteger2);
                GraphUtils.computeLevels(hashMap, digraphIteration, object2, bl);
                continue;
            }
            if ((!bl || mutableInteger2.intValue() >= n) && (bl || mutableInteger2.intValue() <= n)) continue;
            mutableInteger2.setValue(n);
            GraphUtils.computeLevels(hashMap, digraphIteration, object2, bl);
        }
        return hashMap;
    }

    public static Map shiftLevelsDown(Map map, Digraph digraph) {
        Iterator iterator = digraph.vertexIterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (digraph.incomingSize(e) != 0) continue;
            GraphUtils.shiftLevelsDown(map, digraph, e);
        }
        return map;
    }

    public static Map shiftLevelsDown(Map map, DigraphIteration digraphIteration, Object object) {
        Object object2;
        int n = Integer.MAX_VALUE;
        ArcIterator arcIterator = digraphIteration.outgoingIterator(object);
        while (arcIterator.hasNext()) {
            arcIterator.next();
            object2 = arcIterator.getDestination();
            GraphUtils.shiftLevelsDown(map, digraphIteration, object2);
            MutableInteger mutableInteger = (MutableInteger)map.get(object2);
            int n2 = n = n <= mutableInteger.intValue() ? n : mutableInteger.intValue();
        }
        if (n != Integer.MAX_VALUE) {
            object2 = (MutableInteger)map.get(object);
            ((MutableInteger)object2).setValue(n - 1);
        }
        return map;
    }

    public static boolean isTree(Digraph digraph) {
        Object object;
        Object object2 = null;
        Iterator iterator = digraph.vertexIterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            int n = digraph.incomingSize(object);
            if (n != 0) continue;
            object2 = object;
            break;
        }
        if (object2 == null) {
            return false;
        }
        object = new BreadthFirstSearch((DigraphIteration)digraph, object2);
        while (((BreadthFirstSearch)object).isValidTree() && ((BreadthFirstSearch)object).hasNext()) {
            ((BreadthFirstSearch)object).next();
        }
        if (!((BreadthFirstSearch)object).isValidTree()) {
            return false;
        }
        Set set = ((BreadthFirstSearch)object).getSeenVertices();
        Iterator iterator2 = digraph.vertexIterator();
        while (iterator2.hasNext()) {
            if (set.contains(iterator2.next())) continue;
            return false;
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    public static List findCycles(DigraphIteration var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: CONTINUE without a while class org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.GotoStatement.getTargetStartBlock(GotoStatement.java:102)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.IfStatement.getStructuredStatement(IfStatement.java:110)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.getStructuredStatementPlaceHolder(Op03SimpleStatement.java:550)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:727)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

