/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.ashwood.graph;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections.Factory;
import org.objectstyle.ashwood.graph.ArcIterator;
import org.objectstyle.ashwood.graph.Digraph;

public class MapDigraph
implements Digraph,
Serializable {
    public static final Factory HASHMAP_FACTORY = new HashMapFactory();
    public static final Factory TREEMAP_FACTORY = new TreeMapFactory();
    private Factory mapFactory;
    private Map graph;
    private int size;

    public MapDigraph() {
        this(null);
    }

    public MapDigraph(Factory factory) {
        this.mapFactory = factory != null ? factory : HASHMAP_FACTORY;
        this.graph = this.createMap();
    }

    public boolean addVertex(Object object) {
        if (this.graph.containsKey(object)) {
            return false;
        }
        this.graph.put(object, this.createMap());
        return true;
    }

    public boolean addAllVertices(Collection collection) {
        if (this.graph.keySet().containsAll(collection)) {
            return false;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.addVertex(iterator.next());
        }
        return true;
    }

    public Object putArc(Object object, Object object2, Object object3) {
        Map map = (Map)this.graph.get(object);
        if (map == null) {
            map = this.createMap();
            this.graph.put(object, map);
        }
        this.addVertex(object2);
        Object object4 = map.put(object2, object3);
        if (object4 == null) {
            ++this.size;
        }
        return object4;
    }

    public Object getArc(Object object, Object object2) {
        Map map = (Map)this.graph.get(object);
        if (map == null) {
            return null;
        }
        return map.get(object2);
    }

    public boolean removeVertex(Object object) {
        Map map = (Map)this.graph.remove(object);
        if (map != null) {
            this.size -= map.size();
        } else {
            return false;
        }
        this.removeIncoming(object);
        return true;
    }

    public boolean removeAllVertices(Collection collection) {
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            bl |= this.removeVertex(iterator.next());
        }
        return bl;
    }

    public Object removeArc(Object object, Object object2) {
        Map map = (Map)this.graph.get(object);
        if (map == null) {
            return null;
        }
        Object v = map.remove(object2);
        if (v != null) {
            --this.size;
        }
        return v;
    }

    public boolean removeIncoming(Object object) {
        boolean bl = false;
        Iterator iterator = this.graph.values().iterator();
        while (iterator.hasNext()) {
            Map map = (Map)iterator.next();
            Object v = map.remove(object);
            if (v != null) {
                --this.size;
            }
            bl |= v != null;
        }
        return bl;
    }

    public boolean removeOutgoing(Object object) {
        Map map = (Map)this.graph.remove(object);
        if (map != null) {
            this.size -= map.size();
        } else {
            return false;
        }
        boolean bl = !map.isEmpty();
        map.clear();
        return bl;
    }

    public Iterator vertexIterator() {
        return this.graph.keySet().iterator();
    }

    public ArcIterator arcIterator() {
        return new AllArcIterator();
    }

    public ArcIterator outgoingIterator(Object object) {
        if (!this.containsVertex(object)) {
            return ArcIterator.EMPTY_ITERATOR;
        }
        return new OutgoingArcIterator(object);
    }

    public ArcIterator incomingIterator(Object object) {
        if (!this.containsVertex(object)) {
            return ArcIterator.EMPTY_ITERATOR;
        }
        return new IncomingArcIterator(object);
    }

    public int order() {
        return this.graph.size();
    }

    public int size() {
        return this.size;
    }

    public int outgoingSize(Object object) {
        Map map = (Map)this.graph.get(object);
        if (map == null) {
            return 0;
        }
        return map.size();
    }

    public int incomingSize(Object object) {
        int n = 0;
        if (!this.graph.containsKey(object)) {
            return 0;
        }
        Iterator iterator = this.graph.values().iterator();
        while (iterator.hasNext()) {
            Map map = (Map)iterator.next();
            n += map.containsKey(object) ? 1 : 0;
        }
        return n;
    }

    public boolean containsVertex(Object object) {
        return this.graph.containsKey(object);
    }

    public boolean containsAllVertices(Collection collection) {
        return this.graph.keySet().containsAll(collection);
    }

    public boolean hasArc(Object object, Object object2) {
        Map map = (Map)this.graph.get(object);
        if (map == null) {
            return false;
        }
        return map.containsKey(object2);
    }

    public boolean isEmpty() {
        return this.graph.isEmpty();
    }

    public boolean isOutgoingEmpty(Object object) {
        return this.outgoingSize(object) == 0;
    }

    public boolean isIncomingEmpty(Object object) {
        return this.incomingSize(object) == 0;
    }

    private Map createMap() {
        return (Map)this.mapFactory.create();
    }

    public static class TreeMapFactory
    implements Factory,
    Serializable {
        private Comparator comparator;

        public TreeMapFactory() {
        }

        public TreeMapFactory(Comparator comparator) {
            this.comparator = comparator;
        }

        public Object create() {
            if (this.comparator == null) {
                return new TreeMap();
            }
            return new TreeMap(this.comparator);
        }
    }

    public static class HashMapFactory
    implements Factory,
    Serializable {
        public Object create() {
            return new HashMap();
        }
    }

    private class IncomingArcIterator
    implements ArcIterator {
        private Object dst;
        private Object origin;
        private Object nextOrigin;
        private Object arc;
        private Object nextArc;
        private Iterator graphIt;

        private IncomingArcIterator(Object object) {
            this.dst = object;
            this.graphIt = MapDigraph.this.graph.entrySet().iterator();
            this.next();
        }

        public Object getOrigin() {
            return this.origin;
        }

        public Object getDestination() {
            return this.dst;
        }

        public boolean hasNext() {
            return this.nextArc != null;
        }

        public Object next() {
            this.origin = this.nextOrigin;
            this.arc = this.nextArc;
            this.nextArc = null;
            this.nextOrigin = null;
            while (this.graphIt.hasNext()) {
                Map.Entry entry = (Map.Entry)this.graphIt.next();
                Map map = (Map)entry.getValue();
                this.nextArc = map.get(this.dst);
                if (this.nextArc == null) continue;
                this.nextOrigin = entry.getKey();
                break;
            }
            return this.arc;
        }

        public void remove() {
            throw new UnsupportedOperationException("Method remove() not yet implemented.");
        }
    }

    private class OutgoingArcIterator
    implements ArcIterator {
        private Object origin;
        private Iterator dstIt;
        private Map.Entry entry;

        private OutgoingArcIterator(Object object) {
            this.origin = object;
            this.dstIt = ((Map)MapDigraph.this.graph.get(object)).entrySet().iterator();
        }

        public Object getOrigin() {
            return this.origin;
        }

        public Object getDestination() {
            if (this.entry == null) {
                return null;
            }
            return this.entry.getKey();
        }

        public boolean hasNext() {
            return this.dstIt.hasNext();
        }

        public Object next() {
            this.entry = (Map.Entry)this.dstIt.next();
            return this.entry.getValue();
        }

        public void remove() {
            throw new UnsupportedOperationException("Method remove() not yet implemented.");
        }
    }

    private class AllArcIterator
    implements ArcIterator {
        private Iterator orgIterator;
        private Iterator dstIterator;
        private Object origin;
        private Object nextOrigin;
        private Object dst;
        private Object nextDst;
        private Object arc;
        private Object nextArc;

        private AllArcIterator() {
            this.orgIterator = MapDigraph.this.graph.entrySet().iterator();
            this.next();
        }

        public Object getOrigin() {
            return this.origin;
        }

        public Object getDestination() {
            return this.dst;
        }

        public boolean hasNext() {
            return this.nextArc != null;
        }

        public Object next() {
            this.origin = this.nextOrigin;
            this.dst = this.nextDst;
            this.arc = this.nextArc;
            if (this.dstIterator == null || !this.dstIterator.hasNext()) {
                this.nextOrigin = null;
                this.nextDst = null;
                this.nextArc = null;
                while (this.orgIterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)this.orgIterator.next();
                    this.dstIterator = ((Map)entry.getValue()).entrySet().iterator();
                    if (!this.dstIterator.hasNext()) continue;
                    this.nextOrigin = entry.getKey();
                    Map.Entry entry2 = (Map.Entry)this.dstIterator.next();
                    this.nextDst = entry2.getKey();
                    this.nextArc = entry2.getValue();
                    break;
                }
            } else {
                Map.Entry entry = (Map.Entry)this.dstIterator.next();
                this.nextDst = entry.getKey();
                this.nextArc = entry.getValue();
            }
            return this.arc;
        }

        public void remove() {
            throw new UnsupportedOperationException("Method remove() not yet implemented.");
        }
    }
}

