/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.objectstyle.cayenne.CayenneContext;
import org.objectstyle.cayenne.ObjectContext;
import org.objectstyle.cayenne.ObjectContextChangeLog;
import org.objectstyle.cayenne.ObjectContextMergeHandler;
import org.objectstyle.cayenne.ObjectContextStateLog;
import org.objectstyle.cayenne.event.EventManager;
import org.objectstyle.cayenne.event.EventSubject;
import org.objectstyle.cayenne.graph.ArcCreateOperation;
import org.objectstyle.cayenne.graph.ArcDeleteOperation;
import org.objectstyle.cayenne.graph.GraphChangeHandler;
import org.objectstyle.cayenne.graph.GraphDiff;
import org.objectstyle.cayenne.graph.GraphEvent;
import org.objectstyle.cayenne.graph.GraphMap;
import org.objectstyle.cayenne.graph.NodeCreateOperation;
import org.objectstyle.cayenne.graph.NodeDeleteOperation;
import org.objectstyle.cayenne.graph.NodeIdChangeOperation;
import org.objectstyle.cayenne.graph.NodePropertyChangeOperation;

final class ObjectContextGraphManager
extends GraphMap {
    static final String COMMIT_MARKER = "commit";
    static final String FLUSH_MARKER = "flush";
    CayenneContext context;
    Collection deadIds;
    boolean changeEventsEnabled;
    boolean lifecycleEventsEnabled;
    ObjectContextStateLog stateLog;
    ObjectContextChangeLog changeLog;

    ObjectContextGraphManager(CayenneContext context, boolean changeEventsEnabled, boolean lifecycleEventsEnabled) {
        this.context = context;
        this.changeEventsEnabled = changeEventsEnabled;
        this.lifecycleEventsEnabled = lifecycleEventsEnabled;
        this.stateLog = new ObjectContextStateLog(this);
        this.changeLog = new ObjectContextChangeLog();
    }

    boolean hasChanges() {
        return this.changeLog.size() > 0;
    }

    boolean hasChangesSinceLastFlush() {
        int size = this.changeLog.hasMarker(FLUSH_MARKER) ? this.changeLog.sizeAfterMarker(FLUSH_MARKER) : this.changeLog.size();
        return size > 0;
    }

    GraphDiff getDiffs() {
        return this.changeLog.getDiffs();
    }

    GraphDiff getDiffsSinceLastFlush() {
        return this.changeLog.hasMarker(FLUSH_MARKER) ? this.changeLog.getDiffsAfterMarker(FLUSH_MARKER) : this.changeLog.getDiffs();
    }

    Collection dirtyNodes() {
        return this.stateLog.dirtyNodes();
    }

    Collection dirtyNodes(int state) {
        return this.stateLog.dirtyNodes(state);
    }

    void graphCommitAborted() {
        this.changeLog.removeMarker(COMMIT_MARKER);
        if (this.lifecycleEventsEnabled) {
            this.send(null, ObjectContext.GRAPH_COMMIT_ABORTED_SUBJECT, this.context);
        }
    }

    void graphCommitStarted() {
        if (this.lifecycleEventsEnabled) {
            GraphDiff diff = this.changeLog.getDiffs();
            this.changeLog.setMarker(COMMIT_MARKER);
            this.send(diff, ObjectContext.GRAPH_COMMIT_STARTED_SUBJECT, this.context);
        } else {
            this.changeLog.setMarker(COMMIT_MARKER);
        }
    }

    void graphCommitted(GraphDiff parentSyncDiff) {
        if (parentSyncDiff != null) {
            new ObjectContextMergeHandler(this.context).merge(parentSyncDiff);
        }
        if (this.lifecycleEventsEnabled) {
            GraphDiff diff = this.changeLog.getDiffsAfterMarker(COMMIT_MARKER);
            this.stateLog.graphCommitted();
            this.reset();
            this.send(diff, ObjectContext.GRAPH_COMMITTED_SUBJECT, this.context);
        } else {
            this.stateLog.graphCommitted();
            this.reset();
        }
    }

    void graphFlushed() {
        this.changeLog.setMarker(FLUSH_MARKER);
    }

    void graphReverted() {
        GraphDiff diff = this.changeLog.getDiffs();
        diff.undo(new NullChangeHandler());
        this.stateLog.graphReverted();
        this.reset();
        if (this.lifecycleEventsEnabled) {
            this.send(diff, ObjectContext.GRAPH_ROLLEDBACK_SUBJECT, this.context);
        }
    }

    public synchronized void nodeIdChanged(Object nodeId, Object newId) {
        this.stateLog.nodeIdChanged(nodeId, newId);
        this.processChange(new NodeIdChangeOperation(nodeId, newId));
    }

    public synchronized void nodeCreated(Object nodeId) {
        this.stateLog.nodeCreated(nodeId);
        this.processChange(new NodeCreateOperation(nodeId));
    }

    public synchronized void nodeRemoved(Object nodeId) {
        this.stateLog.nodeRemoved(nodeId);
        this.processChange(new NodeDeleteOperation(nodeId));
    }

    public synchronized void nodePropertyChanged(Object nodeId, String property, Object oldValue, Object newValue) {
        this.stateLog.nodePropertyChanged(nodeId, property, oldValue, newValue);
        this.processChange(new NodePropertyChangeOperation(nodeId, property, oldValue, newValue));
    }

    public synchronized void arcCreated(Object nodeId, Object targetNodeId, Object arcId) {
        this.stateLog.arcCreated(nodeId, targetNodeId, arcId);
        this.processChange(new ArcCreateOperation(nodeId, targetNodeId, arcId));
    }

    public synchronized void arcDeleted(Object nodeId, Object targetNodeId, Object arcId) {
        this.stateLog.arcDeleted(nodeId, targetNodeId, arcId);
        this.processChange(new ArcDeleteOperation(nodeId, targetNodeId, arcId));
    }

    private void processChange(GraphDiff diff) {
        this.changeLog.addOperation(diff);
        if (this.changeEventsEnabled) {
            this.send(diff, ObjectContext.GRAPH_CHANGED_SUBJECT, this.context);
        }
    }

    void send(GraphDiff diff, EventSubject subject, Object eventSource) {
        EventManager manager;
        EventManager eventManager = manager = this.context.getChannel() != null ? this.context.getChannel().getEventManager() : null;
        if (manager != null) {
            GraphEvent e = new GraphEvent((Object)this.context, eventSource, diff);
            manager.postEvent(e, subject);
        }
    }

    void reset() {
        this.changeLog.reset();
        if (this.deadIds != null) {
            Iterator it = this.deadIds.iterator();
            while (it.hasNext()) {
                this.nodes.remove(it.next());
            }
            this.deadIds = null;
        }
    }

    Collection deadIds() {
        if (this.deadIds == null) {
            this.deadIds = new ArrayList();
        }
        return this.deadIds;
    }

    class NullChangeHandler
    implements GraphChangeHandler {
        NullChangeHandler() {
        }

        public void arcCreated(Object nodeId, Object targetNodeId, Object arcId) {
        }

        public void arcDeleted(Object nodeId, Object targetNodeId, Object arcId) {
        }

        public void nodeCreated(Object nodeId) {
        }

        public void nodeIdChanged(Object nodeId, Object newId) {
        }

        public void nodePropertyChanged(Object nodeId, String property, Object oldValue, Object newValue) {
        }

        public void nodeRemoved(Object nodeId) {
        }
    }
}

