/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne;

import org.objectstyle.cayenne.CayenneContext;
import org.objectstyle.cayenne.ObjectContext;
import org.objectstyle.cayenne.ObjectContextGraphManager;
import org.objectstyle.cayenne.ObjectId;
import org.objectstyle.cayenne.Persistent;
import org.objectstyle.cayenne.graph.GraphChangeHandler;
import org.objectstyle.cayenne.graph.GraphDiff;
import org.objectstyle.cayenne.graph.GraphEvent;
import org.objectstyle.cayenne.graph.GraphEventListener;
import org.objectstyle.cayenne.property.ArcProperty;
import org.objectstyle.cayenne.property.ClassDescriptor;
import org.objectstyle.cayenne.property.Property;
import org.objectstyle.cayenne.util.Util;

class ObjectContextMergeHandler
implements GraphChangeHandler,
GraphEventListener {
    CayenneContext context;
    boolean active;

    ObjectContextMergeHandler(CayenneContext context) {
        this.context = context;
        this.active = true;
    }

    public void graphChanged(final GraphEvent e) {
        if (this.shouldProcessEvent(e) && e.getDiff() != null) {
            this.runWithEventsDisabled(new Runnable(){

                public void run() {
                    e.getDiff().apply(ObjectContextMergeHandler.this);
                }
            });
            this.repostAfterMerge(e);
        }
    }

    public void graphCommitted(final GraphEvent e) {
        if (this.shouldProcessEvent(e)) {
            final boolean hadChanges = this.context.internalGraphManager().hasChanges();
            this.runWithEventsDisabled(new Runnable(){

                public void run() {
                    if (e.getDiff() != null) {
                        e.getDiff().apply(ObjectContextMergeHandler.this);
                    }
                    if (!hadChanges) {
                        ObjectContextMergeHandler.this.context.internalGraphManager().stateLog.graphCommitted();
                        ObjectContextMergeHandler.this.context.internalGraphManager().reset();
                    }
                }
            });
            this.repostAfterMerge(e);
        }
    }

    public void graphRolledback(GraphEvent e) {
        if (this.shouldProcessEvent(e) && this.context.internalGraphManager().hasChanges()) {
            this.runWithEventsDisabled(new Runnable(){

                public void run() {
                    ObjectContextMergeHandler.this.context.internalGraphManager().graphReverted();
                }
            });
            this.repostAfterMerge(e);
        }
    }

    public void graphCommitAborted(GraphEvent e) {
    }

    public void graphCommitStarted(GraphEvent e) {
    }

    void repostAfterMerge(GraphEvent originalEvent) {
        if (this.context.isLifecycleEventsEnabled()) {
            this.context.internalGraphManager().send(originalEvent.getDiff(), ObjectContext.GRAPH_CHANGED_SUBJECT, originalEvent.getSource());
        }
    }

    void merge(final GraphDiff diff) {
        this.runWithEventsDisabled(new Runnable(){

            public void run() {
                diff.apply(ObjectContextMergeHandler.this);
            }
        });
    }

    public void nodeIdChanged(Object nodeId, Object newId) {
        Object node = this.context.internalGraphManager().getNode(nodeId);
        if (node != null) {
            this.context.internalGraphManager().deadIds().add(nodeId);
            this.context.internalGraphManager().registerNode(newId, node);
            if (node instanceof Persistent) {
                ((Persistent)node).setObjectId((ObjectId)newId);
            }
        }
    }

    public void nodeCreated(Object nodeId) {
        this.context.createNewObject((ObjectId)nodeId);
    }

    public void nodeRemoved(Object nodeId) {
        Object object = this.context.internalGraphManager().getNode(nodeId);
        if (object != null) {
            this.context.deleteObject((Persistent)object);
        }
    }

    public void nodePropertyChanged(Object nodeId, String property, Object oldValue, Object newValue) {
        Property p;
        Object object = this.context.internalGraphManager().getNode(nodeId);
        if (object != null && Util.nullSafeEquals((p = this.propertyForId(nodeId, property)).readPropertyDirectly(object), oldValue)) {
            p.writePropertyDirectly(object, oldValue, newValue);
            this.context.internalGraphAction().handleSimplePropertyChange((Persistent)object, property, oldValue, newValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void arcCreated(Object nodeId, Object targetNodeId, Object arcId) {
        Object target;
        Object source = this.context.internalGraphManager().getNode(nodeId);
        if (source == null) {
            source = this.context.createFault((ObjectId)nodeId);
        }
        if ((target = this.context.internalGraphManager().getNode(targetNodeId)) == null) {
            target = this.context.createFault((ObjectId)targetNodeId);
        }
        ArcProperty p = (ArcProperty)this.propertyForId(nodeId, arcId.toString());
        p.writePropertyDirectly(source, null, target);
        try {
            this.context.internalGraphAction().handleArcPropertyChange((Persistent)source, p, null, target);
        }
        finally {
            this.context.internalGraphAction().setArcChangeInProcess(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void arcDeleted(Object nodeId, Object targetNodeId, Object arcId) {
        Object target;
        Object source = this.context.internalGraphManager().getNode(nodeId);
        if (source == null) {
            source = this.context.createFault((ObjectId)nodeId);
        }
        if ((target = this.context.internalGraphManager().getNode(targetNodeId)) == null) {
            target = this.context.createFault((ObjectId)targetNodeId);
        }
        ArcProperty p = (ArcProperty)this.propertyForId(nodeId, arcId.toString());
        p.writePropertyDirectly(source, target, null);
        try {
            this.context.internalGraphAction().handleArcPropertyChange((Persistent)source, p, target, null);
        }
        finally {
            this.context.internalGraphAction().setArcChangeInProcess(false);
        }
    }

    private Property propertyForId(Object nodeId, String propertyName) {
        ClassDescriptor descriptor = this.context.getEntityResolver().getClassDescriptor(((ObjectId)nodeId).getEntityName());
        return descriptor.getProperty(propertyName);
    }

    boolean shouldProcessEvent(GraphEvent e) {
        return this.active && e.getSource() == this.context.getChannel() && e.getPostedBy() != this.context && e.getPostedBy() != this.context.getChannel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runWithEventsDisabled(Runnable closure) {
        ObjectContextGraphManager objectContextGraphManager = this.context.internalGraphManager();
        synchronized (objectContextGraphManager) {
            boolean changeEventsEnabled = this.context.internalGraphManager().changeEventsEnabled;
            this.context.internalGraphManager().changeEventsEnabled = false;
            boolean lifecycleEventsEnabled = this.context.internalGraphManager().lifecycleEventsEnabled;
            this.context.internalGraphManager().lifecycleEventsEnabled = false;
            try {
                closure.run();
            }
            finally {
                this.context.internalGraphManager().changeEventsEnabled = changeEventsEnabled;
                this.context.internalGraphManager().lifecycleEventsEnabled = lifecycleEventsEnabled;
            }
        }
    }
}

