/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.objectstyle.cayenne.Persistent;
import org.objectstyle.cayenne.graph.GraphChangeHandler;
import org.objectstyle.cayenne.graph.GraphManager;

class ObjectContextStateLog
implements GraphChangeHandler {
    Set dirtyIds = new HashSet();
    GraphManager graphManager;

    ObjectContextStateLog(GraphManager graphManager) {
        this.graphManager = graphManager;
    }

    void clear() {
        this.dirtyIds = new HashSet();
    }

    void graphCommitted() {
        Iterator it = this.dirtyIds.iterator();
        while (it.hasNext()) {
            Object node = this.graphManager.getNode(it.next());
            if (!(node instanceof Persistent)) continue;
            Persistent persistentNode = (Persistent)node;
            switch (persistentNode.getPersistenceState()) {
                case 2: 
                case 4: {
                    persistentNode.setPersistenceState(3);
                    break;
                }
                case 6: {
                    persistentNode.setPersistenceState(1);
                }
            }
        }
        this.clear();
    }

    void graphReverted() {
        Iterator it = this.dirtyIds.iterator();
        while (it.hasNext()) {
            Object node = this.graphManager.getNode(it.next());
            if (!(node instanceof Persistent)) continue;
            Persistent persistentNode = (Persistent)node;
            switch (persistentNode.getPersistenceState()) {
                case 4: 
                case 6: {
                    persistentNode.setPersistenceState(3);
                    break;
                }
                case 2: {
                    persistentNode.setPersistenceState(1);
                }
            }
        }
        this.clear();
    }

    boolean hasChanges() {
        return !this.dirtyIds.isEmpty();
    }

    Collection dirtyNodes() {
        if (this.dirtyIds.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        ArrayList<Object> objects = new ArrayList<Object>(this.dirtyIds.size());
        Iterator it = this.dirtyIds.iterator();
        while (it.hasNext()) {
            objects.add(this.graphManager.getNode(it.next()));
        }
        return objects;
    }

    Collection dirtyNodes(int state) {
        if (this.dirtyIds.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        int size = this.dirtyIds.size();
        ArrayList<Persistent> objects = new ArrayList<Persistent>(size > 50 ? size / 2 : size);
        Iterator it = this.dirtyIds.iterator();
        while (it.hasNext()) {
            Persistent o = (Persistent)this.graphManager.getNode(it.next());
            if (o.getPersistenceState() != state) continue;
            objects.add(o);
        }
        return objects;
    }

    public void nodeIdChanged(Object nodeId, Object newId) {
        if (this.dirtyIds.remove(nodeId)) {
            this.dirtyIds.add(newId);
        }
    }

    public void nodeCreated(Object nodeId) {
        this.dirtyIds.add(nodeId);
    }

    public void nodeRemoved(Object nodeId) {
        this.dirtyIds.add(nodeId);
    }

    public void nodePropertyChanged(Object nodeId, String property, Object oldValue, Object newValue) {
        this.dirtyIds.add(nodeId);
    }

    public void arcCreated(Object nodeId, Object targetNodeId, Object arcId) {
        this.dirtyIds.add(nodeId);
    }

    public void arcDeleted(Object nodeId, Object targetNodeId, Object arcId) {
        this.dirtyIds.add(nodeId);
    }
}

