/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.access;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.objectstyle.cayenne.CayenneRuntimeException;
import org.objectstyle.cayenne.DataChannel;
import org.objectstyle.cayenne.ObjectContext;
import org.objectstyle.cayenne.ObjectId;
import org.objectstyle.cayenne.Persistent;
import org.objectstyle.cayenne.QueryResponse;
import org.objectstyle.cayenne.access.ChildDiffLoader;
import org.objectstyle.cayenne.access.DataContext;
import org.objectstyle.cayenne.access.DataDomain;
import org.objectstyle.cayenne.access.ServerToClientDiffConverter;
import org.objectstyle.cayenne.event.EventManager;
import org.objectstyle.cayenne.graph.CompoundDiff;
import org.objectstyle.cayenne.graph.GraphDiff;
import org.objectstyle.cayenne.graph.GraphEvent;
import org.objectstyle.cayenne.map.EntityResolver;
import org.objectstyle.cayenne.map.ObjEntity;
import org.objectstyle.cayenne.property.ClassDescriptor;
import org.objectstyle.cayenne.query.AbstractQuery;
import org.objectstyle.cayenne.query.PrefetchTreeNode;
import org.objectstyle.cayenne.query.Query;
import org.objectstyle.cayenne.query.QueryMetadata;
import org.objectstyle.cayenne.util.GenericResponse;
import org.objectstyle.cayenne.util.ObjectDetachOperation;

public class ClientServerChannel
implements DataChannel {
    protected DataContext serverContext;
    protected boolean lifecycleEventsEnabled;

    public ClientServerChannel(DataDomain domain) {
        this(domain, false);
    }

    public ClientServerChannel(DataDomain domain, boolean lifecycleEventsEnabled) {
        this(domain.createDataContext(), lifecycleEventsEnabled);
    }

    ClientServerChannel(DataContext serverContext, boolean lifecycleEventsEnabled) {
        this.serverContext = serverContext;
        this.lifecycleEventsEnabled = lifecycleEventsEnabled;
    }

    public EventManager getEventManager() {
        return this.serverContext != null ? this.serverContext.getObjectStore().getEventManager() : null;
    }

    public boolean isLifecycleEventsEnabled() {
        return this.lifecycleEventsEnabled;
    }

    public void setLifecycleEventsEnabled(boolean lifecycleEventsEnabled) {
        this.lifecycleEventsEnabled = lifecycleEventsEnabled;
    }

    public GraphDiff onSync(ObjectContext originatingContext, GraphDiff changes, int syncType) {
        switch (syncType) {
            case 3: {
                return this.onRollback(changes);
            }
            case 1: {
                return this.onFlush(changes);
            }
            case 2: {
                return this.onCommit(changes);
            }
        }
        throw new CayenneRuntimeException("Unrecognized SyncMessage type: " + syncType);
    }

    GraphDiff onRollback(GraphDiff childDiff) {
        if (this.serverContext.hasChanges()) {
            EventManager eventManager;
            this.serverContext.rollbackChanges();
            if (this.lifecycleEventsEnabled && (eventManager = this.getEventManager()) != null) {
                eventManager.postEvent(new GraphEvent((Object)this, null), DataChannel.GRAPH_ROLLEDBACK_SUBJECT);
            }
        }
        return null;
    }

    GraphDiff onFlush(GraphDiff childDiff) {
        EventManager eventManager;
        childDiff.apply(new ChildDiffLoader(this.serverContext));
        if (this.lifecycleEventsEnabled && (eventManager = this.getEventManager()) != null) {
            eventManager.postEvent(new GraphEvent((Object)this, childDiff), DataChannel.GRAPH_CHANGED_SUBJECT);
        }
        return null;
    }

    GraphDiff onCommit(GraphDiff childDiff) {
        EventManager eventManager;
        GraphDiff returnClientDiff;
        GraphDiff diff = this.serverContext.onContextFlush(null, childDiff, true);
        if (diff.isNoop()) {
            returnClientDiff = diff;
        } else {
            ServerToClientDiffConverter clientConverter = new ServerToClientDiffConverter(this.serverContext.getEntityResolver());
            diff.apply(clientConverter);
            returnClientDiff = clientConverter.getClientDiff();
        }
        if (this.lifecycleEventsEnabled && (eventManager = this.getEventManager()) != null) {
            CompoundDiff notification = new CompoundDiff();
            notification.add(childDiff);
            notification.add(returnClientDiff);
            eventManager.postEvent(new GraphEvent((Object)this, notification), DataChannel.GRAPH_COMMITTED_SUBJECT);
        }
        return returnClientDiff;
    }

    public QueryResponse onQuery(ObjectContext context, Query query) {
        Query serverQuery = this.rewriteQuery(query);
        QueryResponse response = this.serverContext.onQuery(null, serverQuery);
        EntityResolver serverResolver = this.serverContext.getEntityResolver();
        QueryMetadata info = serverQuery.getMetaData(serverResolver);
        if (!info.isFetchingDataRows()) {
            GenericResponse clientResponse = new GenericResponse();
            response.reset();
            while (response.next()) {
                if (response.isList()) {
                    List serverObjects = response.currentList();
                    if (serverObjects.isEmpty()) {
                        clientResponse.addResultList(serverObjects);
                        continue;
                    }
                    ArrayList<Object> clientObjects = new ArrayList<Object>(serverObjects.size());
                    ObjectDetachOperation op = new ObjectDetachOperation(serverResolver.getClientEntityResolver());
                    Iterator it = serverObjects.iterator();
                    PrefetchTreeNode prefetchTree = info.getPrefetchTree();
                    while (it.hasNext()) {
                        Persistent object = (Persistent)it.next();
                        ObjectId id = object.getObjectId();
                        if (id == null) {
                            throw new CayenneRuntimeException("Server returned an object without an id: " + object);
                        }
                        ClassDescriptor serverDescriptor = serverResolver.getClassDescriptor(id.getEntityName());
                        clientObjects.add(op.detach(object, serverDescriptor, prefetchTree));
                    }
                    clientResponse.addResultList(clientObjects);
                    continue;
                }
                clientResponse.addBatchUpdateCount(response.currentUpdateCount());
            }
            response = clientResponse;
        }
        return response;
    }

    public EntityResolver getEntityResolver() {
        return this.serverContext.getEntityResolver().getClientEntityResolver();
    }

    Query rewriteQuery(Query clientQuery) {
        if (clientQuery instanceof AbstractQuery) {
            AbstractQuery abstractClientQuery = (AbstractQuery)clientQuery;
            EntityResolver clientResolver = this.serverContext.getEntityResolver().getClientEntityResolver();
            Object root = abstractClientQuery.getRoot();
            if (root instanceof Class) {
                ObjEntity entity = clientResolver.lookupObjEntity((Class)root);
                if (entity == null) {
                    throw new CayenneRuntimeException("Unmapped client class: " + root);
                }
                abstractClientQuery.setRoot(entity.getName());
            }
        }
        return clientQuery;
    }
}

