/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.access;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.objectstyle.cayenne.access.DataNodeFlushAction;
import org.objectstyle.cayenne.access.FlattenedArcKey;
import org.objectstyle.cayenne.map.DbEntity;
import org.objectstyle.cayenne.query.DeleteBatchQuery;
import org.objectstyle.cayenne.query.InsertBatchQuery;

class DataNodeFlattenedBucket {
    final DataNodeFlushAction parent;
    final Map flattenedInsertQueries;
    final Map flattenedDeleteQueries;

    DataNodeFlattenedBucket(DataNodeFlushAction parent) {
        this.parent = parent;
        this.flattenedInsertQueries = new HashMap();
        this.flattenedDeleteQueries = new HashMap();
    }

    boolean isEmpty() {
        return this.flattenedInsertQueries.isEmpty() && this.flattenedDeleteQueries.isEmpty();
    }

    void addFlattenedInsert(DbEntity flattenedEntity, FlattenedArcKey flattenedInsertInfo) {
        InsertBatchQuery relationInsertQuery = (InsertBatchQuery)this.flattenedInsertQueries.get(flattenedEntity);
        if (relationInsertQuery == null) {
            relationInsertQuery = new InsertBatchQuery(flattenedEntity, 50);
            this.flattenedInsertQueries.put(flattenedEntity, relationInsertQuery);
        }
        Map flattenedSnapshot = flattenedInsertInfo.buildJoinSnapshotForInsert(this.parent.getNode());
        relationInsertQuery.add(flattenedSnapshot);
    }

    void addFlattenedDelete(DbEntity flattenedEntity, FlattenedArcKey flattenedDeleteInfo) {
        List flattenedSnapshots;
        DeleteBatchQuery relationDeleteQuery = (DeleteBatchQuery)this.flattenedDeleteQueries.get(flattenedEntity);
        if (relationDeleteQuery == null) {
            boolean optimisticLocking = false;
            relationDeleteQuery = new DeleteBatchQuery(flattenedEntity, 50);
            relationDeleteQuery.setUsingOptimisticLocking(optimisticLocking);
            this.flattenedDeleteQueries.put(flattenedEntity, relationDeleteQuery);
        }
        if (!(flattenedSnapshots = flattenedDeleteInfo.buildJoinSnapshotsForDelete(this.parent.getNode())).isEmpty()) {
            Iterator snapsIt = flattenedSnapshots.iterator();
            while (snapsIt.hasNext()) {
                relationDeleteQuery.add((Map)snapsIt.next());
            }
        }
    }

    void appendInserts(Collection queries) {
        if (!this.flattenedInsertQueries.isEmpty()) {
            queries.addAll(this.flattenedInsertQueries.values());
        }
    }

    void appendDeletes(Collection queries) {
        if (!this.flattenedDeleteQueries.isEmpty()) {
            queries.addAll(this.flattenedDeleteQueries.values());
        }
    }
}

