/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.access;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.apache.commons.collections.map.LinkedMap;
import org.objectstyle.cayenne.DataObject;
import org.objectstyle.cayenne.access.DataNodeDBDiffBuilder;
import org.objectstyle.cayenne.access.DataNodeFlushAction;
import org.objectstyle.cayenne.access.DataNodeSyncBucket;
import org.objectstyle.cayenne.access.DataNodeSyncQualifierDescriptor;
import org.objectstyle.cayenne.access.ObjectDiff;
import org.objectstyle.cayenne.map.DbAttribute;
import org.objectstyle.cayenne.map.DbEntity;
import org.objectstyle.cayenne.map.ObjEntity;
import org.objectstyle.cayenne.query.UpdateBatchQuery;

class DataNodeUpdateBucket
extends DataNodeSyncBucket {
    private final boolean supportsGeneratedKeys;

    DataNodeUpdateBucket(DataNodeFlushAction parent) {
        super(parent);
        this.supportsGeneratedKeys = parent.getNode().getAdapter().supportsGeneratedKeys();
    }

    void appendQueriesInternal(Collection queries) {
        DataNodeDBDiffBuilder diffBuilder = new DataNodeDBDiffBuilder(this.supportsGeneratedKeys);
        DataNodeSyncQualifierDescriptor qualifierBuilder = new DataNodeSyncQualifierDescriptor();
        Iterator i = this.dbEntities.iterator();
        while (i.hasNext()) {
            DbEntity dbEntity = (DbEntity)i.next();
            List objEntitiesForDbEntity = (List)this.objEntitiesByDbEntity.get(dbEntity);
            LinkedMap batches = new LinkedMap();
            Iterator j = objEntitiesForDbEntity.iterator();
            while (j.hasNext()) {
                ObjEntity entity = (ObjEntity)j.next();
                diffBuilder.reset(entity, dbEntity);
                qualifierBuilder.reset(entity, dbEntity);
                boolean isRootDbEntity = entity.getDbEntity() == dbEntity;
                List objects = (List)this.objectsByEntity.get(entity);
                Iterator k = objects.iterator();
                while (k.hasNext()) {
                    DataObject o = (DataObject)k.next();
                    ObjectDiff diff = this.parent.objectDiff(o.getObjectId());
                    Map snapshot = diffBuilder.buildDBDiff(diff);
                    if (snapshot == null) {
                        if (!isRootDbEntity) continue;
                        k.remove();
                        o.setPersistenceState(3);
                        continue;
                    }
                    this.checkReadOnly(entity);
                    Map qualifierSnapshot = qualifierBuilder.createQualifierSnapshot(diff);
                    Set snapshotSet = snapshot.keySet();
                    HashSet nullQualifierNames = new HashSet();
                    Iterator it = qualifierSnapshot.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry entry = it.next();
                        if (entry.getValue() != null) continue;
                        nullQualifierNames.add(entry.getKey());
                    }
                    List<Object> batchKey = Arrays.asList(snapshotSet, nullQualifierNames);
                    UpdateBatchQuery batch = (UpdateBatchQuery)batches.get(batchKey);
                    if (batch == null) {
                        batch = new UpdateBatchQuery(dbEntity, qualifierBuilder.getAttributes(), this.updatedAttributes(dbEntity, snapshot), nullQualifierNames, 10);
                        batch.setUsingOptimisticLocking(qualifierBuilder.isUsingOptimisticLocking());
                        batches.put(batchKey, batch);
                    }
                    batch.add(qualifierSnapshot, snapshot, o.getObjectId());
                    if (!isRootDbEntity) continue;
                    Map replacementId = o.getObjectId().getReplacementIdMap();
                    Iterator pkIt = dbEntity.getPrimaryKey().iterator();
                    while (pkIt.hasNext()) {
                        String name = ((DbAttribute)pkIt.next()).getName();
                        if (!snapshot.containsKey(name) || replacementId.containsKey(name)) continue;
                        replacementId.put(name, snapshot.get(name));
                    }
                }
            }
            queries.addAll(batches.values());
        }
    }

    private List updatedAttributes(DbEntity entity, Map updatedSnapshot) {
        ArrayList attributes = new ArrayList(updatedSnapshot.size());
        SortedMap entityAttributes = entity.getAttributeMap();
        Iterator it = updatedSnapshot.keySet().iterator();
        while (it.hasNext()) {
            Object name = it.next();
            attributes.add(entityAttributes.get(name));
        }
        return attributes;
    }
}

