/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.access;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.objectstyle.cayenne.CayenneRuntimeException;
import org.objectstyle.cayenne.access.DataDomain;
import org.objectstyle.cayenne.access.DataNode;
import org.objectstyle.cayenne.access.QueryLogger;
import org.objectstyle.cayenne.conn.DataSourceInfo;
import org.objectstyle.cayenne.conn.DriverDataSource;
import org.objectstyle.cayenne.dba.DbAdapter;
import org.objectstyle.cayenne.dba.PkGenerator;
import org.objectstyle.cayenne.map.DataMap;
import org.objectstyle.cayenne.map.DbAttribute;
import org.objectstyle.cayenne.map.DbEntity;
import org.objectstyle.cayenne.map.DbJoin;
import org.objectstyle.cayenne.map.DbRelationship;
import org.objectstyle.cayenne.map.DerivedDbEntity;
import org.objectstyle.cayenne.validation.SimpleValidationFailure;
import org.objectstyle.cayenne.validation.ValidationResult;

public class DbGenerator {
    private Logger logObj = Logger.getLogger(DbGenerator.class);
    protected DbAdapter adapter;
    protected DataMap map;
    protected DataDomain domain;
    protected Map dropTables;
    protected Map createTables;
    protected Map createFK;
    protected List createPK;
    protected List dropPK;
    protected List dbEntitiesInInsertOrder;
    protected List dbEntitiesRequiringAutoPK;
    protected boolean shouldDropTables;
    protected boolean shouldCreateTables;
    protected boolean shouldDropPKSupport;
    protected boolean shouldCreatePKSupport;
    protected boolean shouldCreateFKConstraints;
    protected ValidationResult failures;

    public DbGenerator(DbAdapter adapter, DataMap map) {
        this(adapter, map, Collections.EMPTY_LIST);
    }

    public DbGenerator(DbAdapter adapter, DataMap map, Collection excludedEntities) {
        this(adapter, map, excludedEntities, null);
    }

    public DbGenerator(DbAdapter adapter, DataMap map, Collection excludedEntities, DataDomain domain) {
        if (adapter == null) {
            throw new IllegalArgumentException("Adapter must not be null.");
        }
        if (map == null) {
            throw new IllegalArgumentException("DataMap must not be null.");
        }
        this.domain = domain;
        this.map = map;
        this.adapter = adapter;
        this.prepareDbEntities(excludedEntities);
        this.resetToDefaults();
        this.buildStatements();
    }

    protected void resetToDefaults() {
        this.shouldDropTables = false;
        this.shouldDropPKSupport = false;
        this.shouldCreatePKSupport = true;
        this.shouldCreateTables = true;
        this.shouldCreateFKConstraints = true;
    }

    protected void buildStatements() {
        this.dropTables = new HashMap();
        this.createTables = new HashMap();
        this.createFK = new HashMap();
        DbAdapter adapter = this.getAdapter();
        Iterator it = this.dbEntitiesInInsertOrder.iterator();
        boolean supportsFK = adapter.supportsFkConstraints();
        while (it.hasNext()) {
            DbEntity dbe = (DbEntity)it.next();
            String name = dbe.getName();
            this.dropTables.put(name, adapter.dropTable(dbe));
            this.createTables.put(name, adapter.createTable(dbe));
            if (!supportsFK) continue;
            this.createFK.put(name, this.createFkConstraintsQueries(dbe));
        }
        PkGenerator pkGenerator = adapter.getPkGenerator();
        this.dropPK = pkGenerator.dropAutoPkStatements(this.dbEntitiesRequiringAutoPK);
        this.createPK = pkGenerator.createAutoPkStatements(this.dbEntitiesRequiringAutoPK);
    }

    public boolean isEmpty(boolean respectConfiguredSettings) {
        if (this.dbEntitiesInInsertOrder.isEmpty() && this.dbEntitiesRequiringAutoPK.isEmpty()) {
            return true;
        }
        if (!respectConfiguredSettings) {
            return false;
        }
        return !this.shouldDropTables && !this.shouldCreateTables && !this.shouldCreateFKConstraints && !this.shouldCreatePKSupport && !this.shouldDropPKSupport;
    }

    public DbAdapter getAdapter() {
        return this.adapter;
    }

    public List configuredStatements() {
        DbEntity ent;
        Iterator it;
        ArrayList list = new ArrayList();
        if (this.shouldDropTables) {
            it = this.dbEntitiesInInsertOrder.listIterator(this.dbEntitiesInInsertOrder.size());
            while (it.hasPrevious()) {
                ent = (DbEntity)it.previous();
                list.add(this.dropTables.get(ent.getName()));
            }
        }
        if (this.shouldCreateTables) {
            it = this.dbEntitiesInInsertOrder.iterator();
            while (it.hasNext()) {
                ent = (DbEntity)it.next();
                list.add(this.createTables.get(ent.getName()));
            }
        }
        if (this.shouldCreateFKConstraints && this.getAdapter().supportsFkConstraints()) {
            it = this.dbEntitiesInInsertOrder.iterator();
            while (it.hasNext()) {
                ent = (DbEntity)it.next();
                List fks = (List)this.createFK.get(ent.getName());
                list.addAll(fks);
            }
        }
        if (this.shouldDropPKSupport) {
            list.addAll(this.dropPK);
        }
        if (this.shouldCreatePKSupport) {
            list.addAll(this.createPK);
        }
        return list;
    }

    public void runGenerator(DataSourceInfo dsi) throws Exception {
        this.failures = null;
        if (this.isEmpty(true)) {
            return;
        }
        Driver driver = (Driver)Class.forName(dsi.getJdbcDriver()).newInstance();
        DriverDataSource dataSource = new DriverDataSource(driver, dsi.getDataSourceUrl(), dsi.getUserName(), dsi.getPassword());
        this.runGenerator(dataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runGenerator(DataSource ds) throws Exception {
        this.failures = null;
        Connection connection = ds.getConnection();
        try {
            Iterator it;
            DbEntity ent;
            Iterator it2;
            if (this.shouldDropTables) {
                ListIterator it3 = this.dbEntitiesInInsertOrder.listIterator(this.dbEntitiesInInsertOrder.size());
                while (it3.hasPrevious()) {
                    DbEntity ent2 = (DbEntity)it3.previous();
                    this.safeExecute(connection, (String)this.dropTables.get(ent2.getName()));
                }
            }
            ArrayList<String> createdTables = new ArrayList<String>();
            if (this.shouldCreateTables) {
                it2 = this.dbEntitiesInInsertOrder.iterator();
                while (it2.hasNext()) {
                    ent = (DbEntity)it2.next();
                    this.safeExecute(connection, (String)this.createTables.get(ent.getName()));
                    createdTables.add(ent.getName());
                }
            }
            if (this.shouldCreateTables && this.shouldCreateFKConstraints && this.getAdapter().supportsFkConstraints()) {
                it2 = this.dbEntitiesInInsertOrder.iterator();
                while (it2.hasNext()) {
                    ent = (DbEntity)it2.next();
                    if (!createdTables.contains(ent.getName())) continue;
                    List fks = (List)this.createFK.get(ent.getName());
                    Iterator fkIt = fks.iterator();
                    while (fkIt.hasNext()) {
                        this.safeExecute(connection, (String)fkIt.next());
                    }
                }
            }
            if (this.shouldDropPKSupport) {
                List dropAutoPKSQL = this.getAdapter().getPkGenerator().dropAutoPkStatements(this.dbEntitiesRequiringAutoPK);
                it = dropAutoPKSQL.iterator();
                while (it.hasNext()) {
                    this.safeExecute(connection, (String)it.next());
                }
            }
            if (this.shouldCreatePKSupport) {
                List createAutoPKSQL = this.getAdapter().getPkGenerator().createAutoPkStatements(this.dbEntitiesRequiringAutoPK);
                it = createAutoPKSQL.iterator();
                while (it.hasNext()) {
                    this.safeExecute(connection, (String)it.next());
                }
            }
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean safeExecute(Connection connection, String sql) throws SQLException {
        Statement statement = connection.createStatement();
        try {
            QueryLogger.logQuery(sql, null);
            statement.execute(sql);
            boolean bl = true;
            return bl;
        }
        catch (SQLException ex) {
            if (this.failures == null) {
                this.failures = new ValidationResult();
            }
            this.failures.addFailure(new SimpleValidationFailure(sql, ex.getMessage()));
            QueryLogger.logQueryError(ex);
            boolean bl = false;
            return bl;
        }
        finally {
            statement.close();
        }
    }

    public List createFkConstraintsQueries(DbEntity dbEnt) {
        if (!this.getAdapter().supportsFkConstraints()) {
            throw new CayenneRuntimeException("FK constraints are not supported by adapter.");
        }
        ArrayList<String> list = new ArrayList<String>();
        Iterator it = dbEnt.getRelationships().iterator();
        while (it.hasNext()) {
            DbRelationship reverse;
            DbRelationship rel = (DbRelationship)it.next();
            if (rel.isToMany()) continue;
            if (this.domain != null) {
                DataMap srcMap = rel.getSourceEntity().getDataMap();
                DataMap targetMap = rel.getTargetEntity().getDataMap();
                if (srcMap != null && targetMap != null && srcMap != targetMap && this.domain.lookupDataNode(srcMap) != this.domain.lookupDataNode(targetMap)) continue;
            }
            if (!rel.isToPK() || rel.isToDependentPK()) continue;
            if (this.getAdapter().supportsUniqueConstraints() && (reverse = rel.getReverseRelationship()) != null && !reverse.isToMany() && !reverse.isToPK()) {
                list.add(this.getAdapter().createUniqueConstraint((DbEntity)rel.getSourceEntity(), rel.getSourceAttributes()));
            }
            list.add(this.getAdapter().createFkConstraint(rel));
        }
        return list;
    }

    public ValidationResult getFailures() {
        return this.failures;
    }

    public boolean shouldCreatePKSupport() {
        return this.shouldCreatePKSupport;
    }

    public boolean shouldCreateTables() {
        return this.shouldCreateTables;
    }

    public boolean shouldDropPKSupport() {
        return this.shouldDropPKSupport;
    }

    public boolean shouldDropTables() {
        return this.shouldDropTables;
    }

    public boolean shouldCreateFKConstraints() {
        return this.shouldCreateFKConstraints;
    }

    public void setShouldCreatePKSupport(boolean shouldCreatePKSupport) {
        this.shouldCreatePKSupport = shouldCreatePKSupport;
    }

    public void setShouldCreateTables(boolean shouldCreateTables) {
        this.shouldCreateTables = shouldCreateTables;
    }

    public void setShouldDropPKSupport(boolean shouldDropPKSupport) {
        this.shouldDropPKSupport = shouldDropPKSupport;
    }

    public void setShouldDropTables(boolean shouldDropTables) {
        this.shouldDropTables = shouldDropTables;
    }

    public void setShouldCreateFKConstraints(boolean shouldCreateFKConstraints) {
        this.shouldCreateFKConstraints = shouldCreateFKConstraints;
    }

    public DataDomain getDomain() {
        return this.domain;
    }

    private void prepareDbEntities(Collection excludedEntities) {
        if (excludedEntities == null) {
            excludedEntities = Collections.EMPTY_LIST;
        }
        ArrayList<DbEntity> tables = new ArrayList<DbEntity>();
        ArrayList<DbEntity> tablesWithAutoPk = new ArrayList<DbEntity>();
        Iterator it = this.map.getDbEntities().iterator();
        while (it.hasNext()) {
            DbEntity nextEntity = (DbEntity)it.next();
            if (nextEntity instanceof DerivedDbEntity) continue;
            if (nextEntity.getAttributes().size() == 0) {
                this.logObj.info("Skipping entity with no attributes: " + nextEntity.getName());
                continue;
            }
            if (excludedEntities.contains(nextEntity)) continue;
            boolean invalidAttributes = false;
            Iterator nextDbAtributes = nextEntity.getAttributes().iterator();
            while (nextDbAtributes.hasNext()) {
                DbAttribute attr = (DbAttribute)nextDbAtributes.next();
                if (attr.getType() != Integer.MAX_VALUE) continue;
                this.logObj.info("Skipping entity, attribute type is undefined: " + nextEntity.getName() + "." + attr.getName());
                invalidAttributes = true;
                break;
            }
            if (invalidAttributes) continue;
            tables.add(nextEntity);
            Iterator relationships = nextEntity.getRelationships().iterator();
            ArrayList pkAttributes = new ArrayList(nextEntity.getPrimaryKey());
            while (pkAttributes.size() > 0 && relationships.hasNext()) {
                DbRelationship nextRelationship = (DbRelationship)relationships.next();
                if (!nextRelationship.isToMasterPK()) continue;
                Iterator joins = nextRelationship.getJoins().iterator();
                while (joins.hasNext()) {
                    DbJoin join = (DbJoin)joins.next();
                    pkAttributes.remove(join.getSource());
                }
            }
            if (pkAttributes.size() <= 0) continue;
            tablesWithAutoPk.add(nextEntity);
        }
        if (tables.size() > 1) {
            DataNode node = new DataNode("temp");
            node.addDataMap(this.map);
            node.getEntitySorter().sortDbEntities(tables, false);
        }
        this.dbEntitiesInInsertOrder = tables;
        this.dbEntitiesRequiringAutoPK = tablesWithAutoPk;
    }
}

