/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.access;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.objectstyle.cayenne.CayenneException;
import org.objectstyle.cayenne.DataRow;
import org.objectstyle.cayenne.access.ResultIterator;
import org.objectstyle.cayenne.access.types.ExtendedType;
import org.objectstyle.cayenne.access.util.ResultDescriptor;
import org.objectstyle.cayenne.map.DbEntity;
import org.objectstyle.cayenne.util.Util;

public class DefaultResultIterator
implements ResultIterator {
    private static Logger logObj = Logger.getLogger(DefaultResultIterator.class);
    protected Connection connection;
    protected Statement statement;
    protected ResultSet resultSet;
    protected ResultDescriptor descriptor;
    protected int mapCapacity;
    protected boolean closingConnection;
    protected boolean isClosed;
    protected boolean nextRow;
    protected int fetchedSoFar;
    protected int fetchLimit;

    public static Map readProcedureOutParameters(CallableStatement statement, ResultDescriptor resultDescriptor) throws SQLException, Exception {
        int resultWidth = resultDescriptor.getResultWidth();
        if (resultWidth > 0) {
            HashMap<String, Object> dataRow = new HashMap<String, Object>(resultWidth * 2, 0.75f);
            ExtendedType[] converters = resultDescriptor.getConverters();
            int[] jdbcTypes = resultDescriptor.getJdbcTypes();
            String[] names = resultDescriptor.getNames();
            int[] outParamIndexes = resultDescriptor.getOutParamIndexes();
            for (int i = 0; i < outParamIndexes.length; ++i) {
                int index = outParamIndexes[i];
                Object val = converters[index].materializeObject(statement, index + 1, jdbcTypes[index]);
                dataRow.put(names[index], val);
            }
            return dataRow;
        }
        return Collections.EMPTY_MAP;
    }

    public DefaultResultIterator(Connection connection, Statement statement, ResultSet resultSet, ResultDescriptor descriptor, int fetchLimit) throws SQLException, CayenneException {
        this.connection = connection;
        this.statement = statement;
        this.resultSet = resultSet;
        this.descriptor = descriptor;
        this.fetchLimit = fetchLimit;
        this.mapCapacity = (int)Math.ceil((double)descriptor.getNames().length / 0.75);
        this.checkNextRow();
    }

    protected void checkNextRow() throws SQLException, CayenneException {
        this.nextRow = false;
        if ((this.fetchLimit <= 0 || this.fetchedSoFar < this.fetchLimit) && this.resultSet.next()) {
            this.nextRow = true;
            ++this.fetchedSoFar;
        }
    }

    public boolean hasNextRow() {
        return this.nextRow;
    }

    public Map nextDataRow() throws CayenneException {
        if (!this.hasNextRow()) {
            throw new CayenneException("An attempt to read uninitialized row or past the end of the iterator.");
        }
        try {
            Map row = this.readDataRow();
            this.checkNextRow();
            return row;
        }
        catch (SQLException sqex) {
            throw new CayenneException("Exception reading ResultSet.", sqex);
        }
    }

    public int getDataRowWidth() {
        return this.descriptor.getResultWidth();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List dataRows(boolean close) throws CayenneException {
        ArrayList<Map> list = new ArrayList<Map>();
        try {
            while (this.hasNextRow()) {
                list.add(this.nextDataRow());
            }
            ArrayList<Map> arrayList = list;
            return arrayList;
        }
        finally {
            if (close) {
                this.close();
            }
        }
    }

    protected Map readDataRow() throws SQLException, CayenneException {
        try {
            DataRow dataRow = new DataRow(this.mapCapacity);
            ExtendedType[] converters = this.descriptor.getConverters();
            int[] jdbcTypes = this.descriptor.getJdbcTypes();
            String[] names = this.descriptor.getNames();
            int resultWidth = names.length;
            for (int i = 0; i < resultWidth; ++i) {
                Object val = converters[i].materializeObject(this.resultSet, i + 1, jdbcTypes[i]);
                dataRow.put(names[i], val);
            }
            return dataRow;
        }
        catch (CayenneException cex) {
            throw cex;
        }
        catch (Exception otherex) {
            throw new CayenneException("Exception materializing column.", Util.unwindException(otherex));
        }
    }

    protected Map readIdRow(DbEntity entity) throws SQLException, CayenneException {
        try {
            DataRow idRow = new DataRow(2);
            ExtendedType[] converters = this.descriptor.getConverters();
            int[] jdbcTypes = this.descriptor.getJdbcTypes();
            String[] names = this.descriptor.getNames();
            int[] idIndex = this.descriptor.getIdIndexes(entity);
            int len = idIndex.length;
            for (int i = 0; i < len; ++i) {
                int index = idIndex[i];
                Object val = converters[index].materializeObject(this.resultSet, index + 1, jdbcTypes[index]);
                idRow.put(names[index], val);
            }
            return idRow;
        }
        catch (CayenneException cex) {
            throw cex;
        }
        catch (Exception otherex) {
            logObj.warn("Error", otherex);
            throw new CayenneException("Exception materializing id column.", Util.unwindException(otherex));
        }
    }

    public void close() throws CayenneException {
        if (!this.isClosed) {
            this.nextRow = false;
            StringWriter errors = new StringWriter();
            PrintWriter out = new PrintWriter(errors);
            try {
                this.resultSet.close();
            }
            catch (SQLException e1) {
                out.println("Error closing ResultSet");
                e1.printStackTrace(out);
            }
            if (this.statement != null) {
                try {
                    this.statement.close();
                }
                catch (SQLException e2) {
                    out.println("Error closing PreparedStatement");
                    e2.printStackTrace(out);
                }
            }
            if (this.connection != null && this.isClosingConnection()) {
                try {
                    this.connection.close();
                }
                catch (SQLException e3) {
                    out.println("Error closing Connection");
                    e3.printStackTrace(out);
                }
            }
            try {
                out.close();
                errors.close();
            }
            catch (IOException ioex) {
                // empty catch block
            }
            StringBuffer buf = errors.getBuffer();
            if (buf.length() > 0) {
                throw new CayenneException("Error closing ResultIterator: " + buf);
            }
            this.isClosed = true;
        }
    }

    public boolean isClosingConnection() {
        return this.closingConnection;
    }

    public void setClosingConnection(boolean flag) {
        this.closingConnection = flag;
    }

    public void skipDataRow() throws CayenneException {
        if (!this.hasNextRow()) {
            throw new CayenneException("An attempt to read uninitialized row or past the end of the iterator.");
        }
        try {
            this.checkNextRow();
        }
        catch (SQLException sqex) {
            throw new CayenneException("Exception reading ResultSet.", sqex);
        }
    }

    public Map nextObjectId(DbEntity entity) throws CayenneException {
        if (!this.hasNextRow()) {
            throw new CayenneException("An attempt to read uninitialized row or past the end of the iterator.");
        }
        try {
            Map row = this.readIdRow(entity);
            this.checkNextRow();
            return row;
        }
        catch (SQLException sqex) {
            throw new CayenneException("Exception reading ResultSet.", sqex);
        }
    }
}

