/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.access;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.objectstyle.cayenne.DataObject;
import org.objectstyle.cayenne.ObjectId;
import org.objectstyle.cayenne.Persistent;
import org.objectstyle.cayenne.access.ObjectStore;
import org.objectstyle.cayenne.graph.GraphChangeHandler;
import org.objectstyle.cayenne.graph.GraphDiff;
import org.objectstyle.cayenne.graph.NodeDiff;
import org.objectstyle.cayenne.map.ObjEntity;
import org.objectstyle.cayenne.map.ObjRelationship;
import org.objectstyle.cayenne.property.ClassDescriptor;
import org.objectstyle.cayenne.property.CollectionProperty;
import org.objectstyle.cayenne.property.Property;
import org.objectstyle.cayenne.property.PropertyVisitor;
import org.objectstyle.cayenne.property.SingleObjectArcProperty;
import org.objectstyle.cayenne.util.Util;

class ObjectDiff
extends NodeDiff {
    private final ObjectStore objectStore;
    private Collection otherDiffs;
    private Map snapshot;
    private Map arcSnapshot;
    private Map currentArcSnapshot;
    private Map flatIds;

    ObjectDiff(ObjectStore objectStore, final Persistent object) {
        super(object.getObjectId());
        this.objectStore = objectStore;
        int state = object.getPersistenceState();
        if (state == 3 || state == 6 || state == 4) {
            ObjEntity entity = objectStore.getContext().getEntityResolver().getObjEntity(object.getObjectId().getEntityName());
            final boolean lock = entity.getLockType() == 1;
            this.snapshot = new HashMap();
            this.arcSnapshot = new HashMap();
            this.getClassDescriptor().visitProperties(new PropertyVisitor(){

                public boolean visitProperty(Property property) {
                    ObjectDiff.this.snapshot.put(property.getName(), property.readProperty(object));
                    return true;
                }

                public boolean visitCollectionArc(CollectionProperty property) {
                    return true;
                }

                public boolean visitSingleObjectArc(SingleObjectArcProperty property) {
                    if (lock) {
                        ObjectDiff.this.takeSingleObjectArcSnapshot(property, object);
                    }
                    return true;
                }
            });
        }
    }

    Object getSnapshotValue(String propertyName) {
        return this.snapshot != null ? this.snapshot.get(propertyName) : null;
    }

    ObjectId getArcSnapshotValue(String propertyName) {
        return this.arcSnapshot != null ? (ObjectId)this.arcSnapshot.get(propertyName) : null;
    }

    boolean containsArcSnapshot(String propertyName) {
        return this.arcSnapshot != null ? this.arcSnapshot.containsKey(propertyName) : false;
    }

    void appendDiffs(Collection collection) {
        if (this.otherDiffs != null) {
            collection.addAll(this.otherDiffs);
        }
        collection.add(new NodeDiff(this.nodeId, this.diffId){

            public void apply(GraphChangeHandler tracker) {
                ObjectDiff.this.applySimplePropertyChanges(tracker);
            }

            public void undo(GraphChangeHandler tracker) {
                throw new UnsupportedOperationException();
            }
        });
    }

    void addDiff(GraphDiff diff) {
        if (this.otherDiffs == null) {
            this.otherDiffs = new ArrayList(3);
        }
        this.otherDiffs.add(diff);
        if (diff instanceof ArcOperation) {
            this.takeArcSnapshot((ArcOperation)diff);
        }
    }

    public boolean isNoop() {
        if (this.snapshot == null) {
            return false;
        }
        if (this.flatIds != null && !this.flatIds.isEmpty()) {
            return false;
        }
        final boolean[] modFound = new boolean[1];
        final DataObject object = this.objectStore.getObject((ObjectId)this.nodeId);
        int state = object.getPersistenceState();
        if (state == 2 || state == 6) {
            return false;
        }
        this.getClassDescriptor().visitProperties(new PropertyVisitor(){

            public boolean visitProperty(Property property) {
                Object newValue;
                Object oldValue = ObjectDiff.this.snapshot.get(property.getName());
                if (!Util.nullSafeEquals(oldValue, newValue = property.readProperty(object))) {
                    modFound[0] = true;
                }
                return !modFound[0];
            }

            public boolean visitCollectionArc(CollectionProperty property) {
                return true;
            }

            public boolean visitSingleObjectArc(SingleObjectArcProperty property) {
                Persistent newValue;
                if (ObjectDiff.this.arcSnapshot == null) {
                    return true;
                }
                Object oldValue = ObjectDiff.this.arcSnapshot.get(property.getName());
                if (!Util.nullSafeEquals(oldValue, (newValue = (Persistent)property.readProperty(object)) != null ? newValue.getObjectId() : null)) {
                    modFound[0] = true;
                }
                return !modFound[0];
            }
        });
        return !modFound[0];
    }

    public void undo(GraphChangeHandler handler) {
        throw new UnsupportedOperationException();
    }

    public void apply(GraphChangeHandler handler) {
        if (this.otherDiffs != null) {
            Iterator it = this.otherDiffs.iterator();
            while (it.hasNext()) {
                ((GraphDiff)it.next()).apply(handler);
            }
        }
        this.applySimplePropertyChanges(handler);
    }

    private void applySimplePropertyChanges(final GraphChangeHandler handler) {
        final Persistent object = (Persistent)this.objectStore.objectMap.get(this.nodeId);
        this.getClassDescriptor().visitProperties(new PropertyVisitor(){

            public boolean visitProperty(Property property) {
                Object newValue = property.readProperty(object);
                if (ObjectDiff.this.snapshot == null) {
                    if (newValue != null) {
                        handler.nodePropertyChanged(ObjectDiff.this.nodeId, property.getName(), null, newValue);
                    }
                } else {
                    Object oldValue = ObjectDiff.this.snapshot.get(property.getName());
                    if (!Util.nullSafeEquals(oldValue, newValue)) {
                        handler.nodePropertyChanged(ObjectDiff.this.nodeId, property.getName(), oldValue, newValue);
                    }
                }
                return true;
            }

            public boolean visitCollectionArc(CollectionProperty property) {
                return true;
            }

            public boolean visitSingleObjectArc(SingleObjectArcProperty property) {
                return true;
            }
        });
    }

    private void takeArcSnapshot(ArcOperation operation) {
        if (this.snapshot == null) {
            return;
        }
        Object targetId = operation.getTargetNodeId();
        String arcId = operation.getArcId().toString();
        DataObject object = this.objectStore.getObject((ObjectId)this.nodeId);
        Property property = this.getClassDescriptor().getProperty(arcId);
        if (property instanceof CollectionProperty) {
            ObjEntity entity = this.objectStore.context.getEntityResolver().getObjEntity(object.getObjectId().getEntityName());
            ObjRelationship relationship = (ObjRelationship)entity.getRelationship(property.getName());
            if (relationship.isFlattened()) {
                ArcOperation oldOp;
                if (this.flatIds == null) {
                    this.flatIds = new HashMap();
                }
                if ((oldOp = this.flatIds.put(operation, operation)) != null && oldOp.isDelete() != operation.isDelete()) {
                    this.flatIds.remove(operation);
                }
            }
        } else {
            this.takeSingleObjectArcSnapshot(property, object);
            if (this.currentArcSnapshot == null) {
                this.currentArcSnapshot = new HashMap();
            }
            this.currentArcSnapshot.put(arcId, targetId);
        }
    }

    void takeSingleObjectArcSnapshot(Property property, Persistent object) {
        if (this.arcSnapshot == null) {
            this.arcSnapshot = new HashMap();
        }
        if (!this.arcSnapshot.containsKey(property.getName())) {
            Persistent oldTarget = (Persistent)property.readProperty(object);
            this.arcSnapshot.put(property.getName(), oldTarget != null ? oldTarget.getObjectId() : null);
        }
    }

    ClassDescriptor getClassDescriptor() {
        return this.objectStore.context.getEntityResolver().getClassDescriptor(((ObjectId)this.nodeId).getEntityName());
    }

    static final class ArcOperation
    extends NodeDiff {
        private Object targetNodeId;
        private Object arcId;
        private boolean delete;

        public ArcOperation(Object nodeId, Object targetNodeId, Object arcId, boolean delete) {
            super(nodeId);
            this.targetNodeId = targetNodeId;
            this.arcId = arcId;
            this.delete = delete;
        }

        boolean isDelete() {
            return this.delete;
        }

        public int hashCode() {
            return this.arcId.hashCode() + this.targetNodeId.hashCode() + 5;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (!(object instanceof ArcOperation)) {
                return false;
            }
            ArcOperation other = (ArcOperation)object;
            return this.arcId.equals(other.arcId) && Util.nullSafeEquals(this.targetNodeId, other.targetNodeId);
        }

        public void apply(GraphChangeHandler tracker) {
            if (this.delete) {
                tracker.arcDeleted(this.nodeId, this.targetNodeId, this.arcId);
            } else {
                tracker.arcCreated(this.nodeId, this.targetNodeId, this.arcId);
            }
        }

        public void undo(GraphChangeHandler tracker) {
            throw new UnsupportedOperationException();
        }

        public Object getArcId() {
            return this.arcId;
        }

        public Object getTargetNodeId() {
            return this.targetNodeId;
        }
    }
}

