/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.access;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.objectstyle.cayenne.CayenneRuntimeException;
import org.objectstyle.cayenne.DataObject;
import org.objectstyle.cayenne.DataRow;
import org.objectstyle.cayenne.access.PrefetchProcessorNode;
import org.objectstyle.cayenne.access.jdbc.ColumnDescriptor;
import org.objectstyle.cayenne.exp.Expression;
import org.objectstyle.cayenne.exp.parser.ASTPath;
import org.objectstyle.cayenne.map.DbAttribute;
import org.objectstyle.cayenne.map.DbJoin;
import org.objectstyle.cayenne.map.DbRelationship;
import org.objectstyle.cayenne.map.ObjAttribute;
import org.objectstyle.cayenne.map.ObjRelationship;
import org.objectstyle.cayenne.query.PrefetchTreeNode;

class PrefetchProcessorJointNode
extends PrefetchProcessorNode {
    ColumnDescriptor[] columns;
    int[] idIndices;
    int rowCapacity;
    Map resolved;
    List resolvedRows;

    PrefetchProcessorJointNode(PrefetchTreeNode parent, String segmentPath) {
        super(parent, segmentPath);
    }

    void afterInit() {
        int capacity;
        super.afterInit();
        int n = capacity = this.dataRows != null ? this.dataRows.size() : 10;
        if (capacity > 100) {
            capacity /= 2;
        }
        this.objects = new ArrayList(capacity);
        this.resolved = new HashMap(capacity);
        this.resolvedRows = new ArrayList(capacity);
        this.buildRowMapping();
        this.buildPKIndex();
    }

    List getResolvedRows() {
        return this.resolvedRows;
    }

    void addObject(DataObject object, DataRow row) {
        this.objects.add(object);
        this.resolvedRows.add(row);
    }

    Map idFromFlatRow(DataRow flatRow) {
        TreeMap id = new TreeMap();
        for (int i = 0; i < this.idIndices.length; ++i) {
            Object value = flatRow.get(this.columns[this.idIndices[i]].getLabel());
            id.put(this.columns[this.idIndices[i]].getName(), value);
        }
        return id;
    }

    DataObject getResolved(Map id) {
        return (DataObject)this.resolved.get(id);
    }

    void putResolved(Map id, DataObject object) {
        this.resolved.put(id, object);
    }

    DataRow rowFromFlatRow(DataRow flatRow) {
        DataRow row = new DataRow(this.rowCapacity);
        for (int i = 0; i < this.columns.length; ++i) {
            row.put(this.columns[i].getName(), flatRow.get(this.columns[i].getLabel()));
        }
        return row;
    }

    private void buildRowMapping() {
        String prefix;
        TreeMap targetSource = new TreeMap();
        PrefetchTreeNode jointRoot = this;
        while (jointRoot.getParent() != null && !jointRoot.isDisjointPrefetch()) {
            jointRoot = jointRoot.getParent();
        }
        if (jointRoot != this) {
            Expression objectPath = Expression.fromString(this.getPath(jointRoot));
            ASTPath translated = (ASTPath)((PrefetchProcessorNode)jointRoot).getResolver().getEntity().translateToDbPath(objectPath);
            prefix = translated.getOperand(0) + ".";
        } else {
            prefix = "";
        }
        if (this.getParent() != null && !this.getParent().isPhantom() && this.getIncoming() != null && !this.getIncoming().isFlattened()) {
            DbRelationship r = (DbRelationship)this.getIncoming().getDbRelationships().get(0);
            Iterator it = r.getJoins().iterator();
            while (it.hasNext()) {
                DbJoin join = (DbJoin)it.next();
                PrefetchProcessorNode parent = (PrefetchProcessorNode)this.getParent();
                String source = parent instanceof PrefetchProcessorJointNode ? ((PrefetchProcessorJointNode)parent).sourceForTarget(join.getSourceName()) : join.getSourceName();
                if (source == null) {
                    throw new CayenneRuntimeException("Propagated column value is not configured for parent node. Join: " + join);
                }
                this.appendColumn(targetSource, join.getTargetName(), source);
            }
        }
        Iterator attributes = this.getResolver().getEntity().getAttributes().iterator();
        while (attributes.hasNext()) {
            ObjAttribute attribute = (ObjAttribute)attributes.next();
            String target = attribute.getDbAttributePath();
            this.appendColumn(targetSource, target, prefix + target);
        }
        Iterator relationships = this.getResolver().getEntity().getRelationships().iterator();
        while (relationships.hasNext()) {
            ObjRelationship rel = (ObjRelationship)relationships.next();
            DbRelationship dbRel = (DbRelationship)rel.getDbRelationships().get(0);
            Iterator dbAttributes = dbRel.getSourceAttributes().iterator();
            while (dbAttributes.hasNext()) {
                DbAttribute attribute = (DbAttribute)dbAttributes.next();
                String target = attribute.getName();
                this.appendColumn(targetSource, target, prefix + target);
            }
        }
        Iterator pks = this.getResolver().getEntity().getDbEntity().getPrimaryKey().iterator();
        while (pks.hasNext()) {
            DbAttribute pk = (DbAttribute)pks.next();
            this.appendColumn(targetSource, pk.getName(), prefix + pk.getName());
        }
        int size = targetSource.size();
        this.rowCapacity = (int)Math.ceil((double)size / 0.75);
        this.columns = new ColumnDescriptor[size];
        targetSource.values().toArray(this.columns);
    }

    private ColumnDescriptor appendColumn(Map map, String name, String label) {
        ColumnDescriptor column = (ColumnDescriptor)map.get(name);
        if (column == null) {
            column = new ColumnDescriptor();
            column.setName(name);
            column.setLabel(label);
            map.put(name, column);
        }
        return column;
    }

    private void buildPKIndex() {
        List pks = this.getResolver().getEntity().getDbEntity().getPrimaryKey();
        this.idIndices = new int[pks.size()];
        Arrays.fill(this.idIndices, -1);
        for (int i = 0; i < this.idIndices.length; ++i) {
            DbAttribute pk = (DbAttribute)pks.get(i);
            for (int j = 0; j < this.columns.length; ++j) {
                if (!pk.getName().equals(this.columns[j].getName())) continue;
                this.idIndices[i] = j;
                break;
            }
            if (this.idIndices[i] != -1) continue;
            throw new CayenneRuntimeException("PK column is not part of result row: " + pk.getName());
        }
    }

    private String sourceForTarget(String targetColumn) {
        if (targetColumn != null && this.columns != null) {
            for (int i = 0; i < this.columns.length; ++i) {
                if (!targetColumn.equals(this.columns[i].getName())) continue;
                return this.columns[i].getLabel();
            }
        }
        return null;
    }
}

