/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.access.trans;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.objectstyle.cayenne.CayenneRuntimeException;
import org.objectstyle.cayenne.DataObject;
import org.objectstyle.cayenne.ObjectId;
import org.objectstyle.cayenne.exp.Expression;
import org.objectstyle.cayenne.map.DbAttribute;
import org.objectstyle.cayenne.map.DbEntity;
import org.objectstyle.cayenne.map.DbJoin;
import org.objectstyle.cayenne.map.DbRelationship;

public class DataObjectMatchTranslator {
    protected Map attributes;
    protected Map values;
    protected String operation;
    protected Expression expression;
    protected DbRelationship relationship;

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public void reset() {
        this.attributes = null;
        this.values = null;
        this.operation = null;
        this.expression = null;
        this.relationship = null;
    }

    public void setRelationship(DbRelationship rel) {
        this.relationship = rel;
        this.attributes = new HashMap(rel.getJoins().size() * 2);
        if (rel.isToMany() || !rel.isToPK()) {
            DbEntity ent = (DbEntity)rel.getTargetEntity();
            Iterator pk = ent.getPrimaryKey().iterator();
            while (pk.hasNext()) {
                DbAttribute pkAttr = (DbAttribute)pk.next();
                this.attributes.put(pkAttr.getName(), pkAttr);
            }
        } else {
            Iterator joins = rel.getJoins().iterator();
            while (joins.hasNext()) {
                DbJoin join = (DbJoin)joins.next();
                this.attributes.put(join.getTargetName(), join.getSource());
            }
        }
    }

    public void setDataObject(DataObject obj) {
        if (obj == null) {
            this.values = Collections.EMPTY_MAP;
            return;
        }
        ObjectId id = obj.getObjectId();
        this.setObjectId(id);
    }

    public void setObjectId(ObjectId id) {
        if (id == null) {
            throw new CayenneRuntimeException("Null ObjectId, probably an attempt to use TRANSIENT object as a query parameter.");
        }
        if (id.isTemporary()) {
            throw new CayenneRuntimeException("Temporary id, probably an attempt to use NEW object as a query parameter.");
        }
        this.values = id.getIdSnapshot();
    }

    public Iterator keys() {
        if (this.attributes == null) {
            throw new IllegalStateException("An attempt to use uninitialized DataObjectMatchTranslator: [attributes: null, values: " + this.values + "]");
        }
        return this.attributes.keySet().iterator();
    }

    public DbRelationship getRelationship() {
        return this.relationship;
    }

    public DbAttribute getAttribute(String key) {
        return (DbAttribute)this.attributes.get(key);
    }

    public Object getValue(String key) {
        return this.values.get(key);
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getOperation() {
        return this.operation;
    }
}

