/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.access.trans;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import org.objectstyle.cayenne.CayenneRuntimeException;
import org.objectstyle.cayenne.access.trans.BatchQueryBuilder;
import org.objectstyle.cayenne.dba.DbAdapter;
import org.objectstyle.cayenne.dba.TypesMapping;
import org.objectstyle.cayenne.map.DbAttribute;
import org.objectstyle.cayenne.query.BatchQuery;

public abstract class LOBBatchQueryBuilder
extends BatchQueryBuilder {
    protected String newClobFunction;
    protected String newBlobFunction;

    public LOBBatchQueryBuilder(DbAdapter adapter) {
        super(adapter);
    }

    public abstract List getValuesForLOBUpdateParameters(BatchQuery var1);

    public String createLOBSelectString(BatchQuery updateQuery, List selectedLOBAttributes, List qualifierAttributes) {
        StringBuffer buf = new StringBuffer();
        buf.append("SELECT ");
        Iterator it = selectedLOBAttributes.iterator();
        while (it.hasNext()) {
            buf.append(((DbAttribute)it.next()).getName());
            if (!it.hasNext()) continue;
            buf.append(", ");
        }
        buf.append(" FROM ").append(updateQuery.getDbEntity().getFullyQualifiedName()).append(" WHERE ");
        it = qualifierAttributes.iterator();
        while (it.hasNext()) {
            DbAttribute attribute = (DbAttribute)it.next();
            this.appendDbAttribute(buf, attribute);
            buf.append(" = ?");
            if (!it.hasNext()) continue;
            buf.append(" AND ");
        }
        buf.append(" FOR UPDATE");
        return buf.toString();
    }

    protected void appendUpdatedParameter(StringBuffer buf, DbAttribute dbAttribute, Object value) {
        int type = dbAttribute.getType();
        if (this.isUpdateableColumn(value, type)) {
            buf.append('?');
        } else if (type == 2005) {
            buf.append(this.newClobFunction);
        } else if (type == 2004) {
            buf.append(this.newBlobFunction);
        } else {
            throw new CayenneRuntimeException("Unknown LOB column type: " + type + "(" + TypesMapping.getSqlNameByType(type) + "). Query buffer: " + buf);
        }
    }

    public void bindParameters(PreparedStatement statement, BatchQuery query) throws SQLException, Exception {
        List dbAttributes = query.getDbAttributes();
        int attributeCount = dbAttributes.size();
        int j = 1;
        for (int i = 0; i < attributeCount; ++i) {
            DbAttribute attribute;
            int type;
            Object value = query.getValue(i);
            if (!this.isUpdateableColumn(value, type = (attribute = (DbAttribute)dbAttributes.get(i)).getType())) continue;
            this.adapter.bindParameter(statement, value, j, type, attribute.getPrecision());
            ++j;
        }
    }

    protected boolean isUpdateableColumn(Object value, int type) {
        return value == null || type != 2004 && type != 2005;
    }

    public String getNewBlobFunction() {
        return this.newBlobFunction;
    }

    public String getNewClobFunction() {
        return this.newClobFunction;
    }

    public void setNewBlobFunction(String string) {
        this.newBlobFunction = string;
    }

    public void setNewClobFunction(String string) {
        this.newClobFunction = string;
    }
}

