/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.access.trans;

import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.List;
import org.objectstyle.cayenne.access.QueryLogger;
import org.objectstyle.cayenne.access.QueryTranslator;
import org.objectstyle.cayenne.map.DbAttribute;
import org.objectstyle.cayenne.map.DbEntity;
import org.objectstyle.cayenne.map.DbRelationship;

public abstract class QueryAssembler
extends QueryTranslator {
    protected List values = new ArrayList();
    protected List attributes = new ArrayList();

    public abstract void dbRelationshipAdded(DbRelationship var1);

    public abstract String createSqlString() throws Exception;

    public String aliasForTable(DbEntity ent, DbRelationship rel) {
        return this.aliasForTable(ent);
    }

    public abstract String aliasForTable(DbEntity var1);

    public boolean supportsTableAliases() {
        return false;
    }

    public void addToParamList(DbAttribute dbAttr, Object anObject) {
        this.attributes.add(dbAttr);
        this.values.add(anObject);
    }

    public PreparedStatement createStatement() throws Exception {
        long t1 = System.currentTimeMillis();
        String sqlStr = this.createSqlString();
        QueryLogger.logQuery(sqlStr, this.values, System.currentTimeMillis() - t1);
        PreparedStatement stmt = this.connection.prepareStatement(sqlStr);
        this.initStatement(stmt);
        return stmt;
    }

    protected void initStatement(PreparedStatement stmt) throws Exception {
        if (this.values != null && this.values.size() > 0) {
            int len = this.values.size();
            for (int i = 0; i < len; ++i) {
                Object val = this.values.get(i);
                DbAttribute attr = (DbAttribute)this.attributes.get(i);
                if (attr == null) {
                    stmt.setObject(i + 1, val);
                    continue;
                }
                int type = attr.getType();
                int precision = attr.getPrecision();
                this.adapter.bindParameter(stmt, val, i + 1, type, precision);
            }
        }
    }
}

