/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.access.types;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.objectstyle.cayenne.CayenneException;
import org.objectstyle.cayenne.access.types.AbstractType;
import org.objectstyle.cayenne.map.DbAttribute;
import org.objectstyle.cayenne.util.MemoryBlob;
import org.objectstyle.cayenne.validation.BeanValidationFailure;
import org.objectstyle.cayenne.validation.ValidationResult;

public class ByteArrayType
extends AbstractType {
    private static final int BUF_SIZE = 8192;
    protected boolean trimmingBytes;
    protected boolean usingBlobs;

    public static byte[] trimBytes(byte[] bytes) {
        int bytesToTrim = 0;
        for (int i = bytes.length - 1; i >= 0; --i) {
            if (bytes[i] == 0) continue;
            bytesToTrim = bytes.length - 1 - i;
            break;
        }
        if (bytesToTrim == 0) {
            return bytes;
        }
        byte[] dest = new byte[bytes.length - bytesToTrim];
        System.arraycopy(bytes, 0, dest, 0, dest.length);
        return dest;
    }

    public ByteArrayType(boolean trimmingBytes, boolean usingBlobs) {
        this.usingBlobs = usingBlobs;
        this.trimmingBytes = trimmingBytes;
    }

    public String getClassName() {
        return "byte[]";
    }

    public boolean validateProperty(Object source, String property, Object value, DbAttribute dbAttribute, ValidationResult validationResult) {
        if (!(value instanceof byte[])) {
            return true;
        }
        if (dbAttribute.getMaxLength() <= 0) {
            return true;
        }
        byte[] bytes = (byte[])value;
        if (bytes.length > dbAttribute.getMaxLength()) {
            String message = "\"" + property + "\" exceeds maximum allowed length (" + dbAttribute.getMaxLength() + " bytes): " + bytes.length;
            validationResult.addFailure(new BeanValidationFailure(source, property, message));
            return false;
        }
        return true;
    }

    public Object materializeObject(ResultSet rs, int index, int type) throws Exception {
        byte[] bytes = null;
        if (type == 2004) {
            bytes = this.isUsingBlobs() ? this.readBlob(rs.getBlob(index)) : this.readBinaryStream(rs, index);
        } else {
            bytes = rs.getBytes(index);
            if (bytes != null && type == -2 && this.isTrimmingBytes()) {
                bytes = ByteArrayType.trimBytes(bytes);
            }
        }
        return bytes;
    }

    public Object materializeObject(CallableStatement cs, int index, int type) throws Exception {
        byte[] bytes = null;
        if (type == 2004) {
            if (!this.isUsingBlobs()) {
                throw new CayenneException("Binary streams are not supported in stored procedure parameters.");
            }
            bytes = this.readBlob(cs.getBlob(index));
        } else {
            bytes = cs.getBytes(index);
            if (bytes != null && type == -2 && this.isTrimmingBytes()) {
                bytes = ByteArrayType.trimBytes(bytes);
            }
        }
        return bytes;
    }

    public void setJdbcObject(PreparedStatement st, Object val, int pos, int type, int precision) throws Exception {
        if (type == 2004) {
            if (this.isUsingBlobs()) {
                st.setBlob(pos, this.writeBlob((byte[])val));
            } else {
                st.setBytes(pos, (byte[])val);
            }
        } else {
            super.setJdbcObject(st, val, pos, type, precision);
        }
    }

    protected Blob writeBlob(byte[] bytes) {
        return bytes != null ? new MemoryBlob(bytes) : null;
    }

    protected byte[] readBlob(Blob blob) throws IOException, SQLException {
        if (blob == null) {
            return null;
        }
        if (blob.length() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("BLOB is too big to be read as byte[] in memory: " + blob.length());
        }
        int size = (int)blob.length();
        if (size == 0) {
            return new byte[0];
        }
        int bufSize = size < 8192 ? size : 8192;
        InputStream in = blob.getBinaryStream();
        return in != null ? this.readValueStream(new BufferedInputStream(in, bufSize), size, bufSize) : null;
    }

    protected byte[] readBinaryStream(ResultSet rs, int index) throws IOException, SQLException {
        InputStream in = rs.getBinaryStream(index);
        return in != null ? this.readValueStream(in, -1, 8192) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] readValueStream(InputStream in, int streamSize, int bufSize) throws IOException {
        byte[] buf = new byte[bufSize];
        ByteArrayOutputStream out = streamSize > 0 ? new ByteArrayOutputStream(streamSize) : new ByteArrayOutputStream();
        try {
            int read;
            while ((read = in.read(buf, 0, bufSize)) >= 0) {
                out.write(buf, 0, read);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            in.close();
        }
    }

    public boolean isUsingBlobs() {
        return this.usingBlobs;
    }

    public void setUsingBlobs(boolean usingBlobs) {
        this.usingBlobs = usingBlobs;
    }

    public boolean isTrimmingBytes() {
        return this.trimmingBytes;
    }

    public void setTrimmingBytes(boolean trimingBytes) {
        this.trimmingBytes = trimingBytes;
    }
}

