/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.access.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.objectstyle.cayenne.CayenneRuntimeException;
import org.objectstyle.cayenne.DataObject;
import org.objectstyle.cayenne.ObjectId;
import org.objectstyle.cayenne.ValueHolder;
import org.objectstyle.cayenne.access.DataContext;
import org.objectstyle.cayenne.access.util.QueryUtils;
import org.objectstyle.cayenne.exp.Expression;
import org.objectstyle.cayenne.exp.parser.ASTDbPath;
import org.objectstyle.cayenne.exp.parser.ASTIn;
import org.objectstyle.cayenne.exp.parser.ASTList;
import org.objectstyle.cayenne.map.DbRelationship;
import org.objectstyle.cayenne.map.ObjEntity;
import org.objectstyle.cayenne.map.ObjRelationship;
import org.objectstyle.cayenne.query.SelectQuery;

public class PrefetchHelper {
    public static void resolveToOneRelations(DataContext context, List objects, String relName) {
        int len = objects.size();
        if (len == 0) {
            return;
        }
        ArrayList<ObjectId> oids = null;
        for (int i = 0; i < len; ++i) {
            DataObject sourceObject = (DataObject)objects.get(i);
            DataObject targetObject = (DataObject)sourceObject.readProperty(relName);
            if (targetObject.getPersistenceState() != 5) continue;
            ObjectId oid = targetObject.getObjectId();
            if (oids == null) {
                oids = new ArrayList<ObjectId>(len);
            }
            oids.add(oid);
        }
        if (oids != null) {
            SelectQuery sel = QueryUtils.selectQueryForIds(oids);
            context.performQuery(sel);
        }
    }

    public static void resolveToManyRelations(DataContext context, List objects, String relName) {
        int nobjects = objects.size();
        if (nobjects == 0) {
            return;
        }
        String dbKey = null;
        HashMap listMap = new HashMap(nobjects);
        for (int i = 0; i < nobjects; ++i) {
            DataObject object = (DataObject)objects.get(i);
            ObjectId oid = object.getObjectId();
            if (dbKey == null) {
                Map id = oid.getIdSnapshot();
                if (id.size() != 1) {
                    throw new CayenneRuntimeException("resolveToManyRelations expects single keys for now...");
                }
                dbKey = (String)id.keySet().iterator().next();
            }
            listMap.put(oid.getValueForAttribute(dbKey), new ArrayList());
        }
        ObjEntity ent = context.getEntityResolver().lookupObjEntity((DataObject)objects.get(0));
        ObjRelationship rel = (ObjRelationship)ent.getRelationship(relName);
        ObjEntity destEnt = (ObjEntity)rel.getTargetEntity();
        List dbRels = rel.getDbRelationships();
        if (dbRels == null || dbRels.size() == 0) {
            throw new CayenneRuntimeException("ObjRelationship '" + rel.getName() + "' is unmapped.");
        }
        StringBuffer buf = new StringBuffer();
        ListIterator it = dbRels.listIterator(dbRels.size());
        while (it.hasPrevious()) {
            DbRelationship dbRel;
            DbRelationship reverse;
            if (buf.length() > 0) {
                buf.append(".");
            }
            if ((reverse = (dbRel = (DbRelationship)it.previous()).getReverseRelationship()) == null) {
                throw new CayenneRuntimeException("DbRelatitionship '" + dbRel.getName() + "' has no reverse relationship");
            }
            buf.append(reverse.getName());
        }
        ASTDbPath dbpath = new ASTDbPath(buf.toString());
        ASTList listExp = new ASTList(objects);
        SelectQuery sel = new SelectQuery(destEnt, (Expression)new ASTIn(dbpath, listExp));
        sel.setFetchingDataRows(true);
        List results = context.performQuery(sel);
        List destObjects = context.objectsFromDataRows(destEnt, results, false, false);
        int nrows = destObjects.size();
        for (int k = 0; k < nrows; ++k) {
            Map row = (Map)results.get(k);
            ((List)listMap.get(row.get(dbKey))).add(destObjects.get(k));
        }
        for (int i = 0; i < nobjects; ++i) {
            DataObject object = (DataObject)objects.get(i);
            ObjectId oid = object.getObjectId();
            Object list = listMap.get(oid.getValueForAttribute(dbKey));
            ((ValueHolder)object.readPropertyDirectly(relName)).setValueDirectly(list);
        }
    }
}

