/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.dataview;

import java.util.ArrayList;
import java.util.List;
import org.objectstyle.cayenne.dataview.ObjEntityView;
import org.objectstyle.cayenne.dataview.ObjEntityViewField;
import org.objectstyle.cayenne.exp.Expression;
import org.objectstyle.cayenne.exp.ExpressionFactory;
import org.objectstyle.cayenne.query.SelectQuery;

public class BasicQueryBuilder {
    private ObjEntityView queryTarget;
    private List conditions = new ArrayList();

    public BasicQueryBuilder(ObjEntityView queryTarget) {
        this.queryTarget = queryTarget;
    }

    public void addEqual(String fieldName, Object value) {
        ObjEntityViewField field = this.queryTarget.getField(fieldName);
        String path = null;
        if (field.getCalcType().getValue() == 1) {
            path = field.getObjAttribute().getName();
        } else if (field.isLookup()) {
            path = field.getObjRelationship().getName();
        }
        Object rawValue = field.toRawValue(value);
        this.conditions.add(ExpressionFactory.matchExp(path, rawValue));
    }

    public void addRange(String fieldName, Object start, Object end) {
        ObjEntityViewField field = this.queryTarget.getField(fieldName);
        String path = null;
        if (field.getCalcType().getValue() == 1) {
            path = field.getObjAttribute().getName();
        } else if (field.isLookup()) {
            path = field.getObjRelationship().getName();
        }
        Object rawStart = field.toRawValue(start);
        Object rawEnd = field.toRawValue(end);
        Expression expr = null;
        if (rawStart != null && rawEnd != null) {
            expr = ExpressionFactory.betweenExp(path, rawStart, rawEnd);
        } else if (rawStart != null) {
            expr = ExpressionFactory.greaterOrEqualExp(path, rawStart);
        } else if (rawEnd != null) {
            expr = ExpressionFactory.lessOrEqualExp(path, rawStart);
        }
        if (expr != null) {
            this.conditions.add(expr);
        }
    }

    public void addLike(String fieldName, Object value, boolean caseSensetive) {
        ObjEntityViewField field = this.queryTarget.getField(fieldName);
        String path = null;
        if (field.getCalcType().getValue() == 1) {
            path = field.getObjAttribute().getName();
        } else if (field.isLookup()) {
            path = field.getObjRelationship().getName();
        }
        Object rawValue = field.toRawValue(value);
        String pattern = rawValue != null ? rawValue.toString() : "";
        Expression expr = caseSensetive ? ExpressionFactory.likeExp(path, pattern) : ExpressionFactory.likeIgnoreCaseExp(path, pattern);
        this.conditions.add(expr);
    }

    public SelectQuery getSelectQuery() {
        SelectQuery query = new SelectQuery(this.queryTarget.getObjEntity());
        if (!this.conditions.isEmpty()) {
            Expression qualifier = ExpressionFactory.joinExp(0, this.conditions);
            query.setQualifier(qualifier);
        }
        return query;
    }
}

