/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.dataview;

import java.awt.Component;
import java.text.Format;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.objectstyle.cayenne.dataview.DOTableModel;
import org.objectstyle.cayenne.dataview.ObjEntityViewField;

public class CellRenderers {
    public FormatRenderer createFormatTableCellRenderer(Format format, String nullText, String invalidText, int alignment) {
        FormatRenderer renderer = new FormatRenderer(format, nullText, invalidText);
        if (alignment >= 0) {
            renderer.setHorizontalAlignment(alignment);
        }
        return renderer;
    }

    public BooleanRenderer createBooleanTableCellRenderer() {
        BooleanRenderer renderer = new BooleanRenderer();
        return renderer;
    }

    public ObjectRenderer createDefaultTableCellRenderer(int alignment) {
        ObjectRenderer renderer = new ObjectRenderer();
        if (alignment >= 0) {
            renderer.setHorizontalAlignment(alignment);
        }
        return renderer;
    }

    public TableCellRenderer createTableCellRenderer(ObjEntityViewField field) {
        int alignment;
        JComponent renderer = null;
        Format format = field.getDisplayFormat();
        int dataType = field.getDataType().getValue();
        String nullText = "";
        String invalidText = "";
        switch (dataType) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                alignment = 4;
                break;
            }
            default: {
                alignment = 2;
            }
        }
        renderer = format != null ? this.createFormatTableCellRenderer(format, nullText, invalidText, alignment) : (dataType == 9 ? this.createBooleanTableCellRenderer() : this.createDefaultTableCellRenderer(alignment));
        return renderer;
    }

    public ListCellRenderer createFormatListCellRenderer(Format format, String nullText, String invalidText, int alignment) {
        FormatListCellRenderer renderer = new FormatListCellRenderer(format, nullText, invalidText);
        if (alignment >= 0) {
            renderer.setHorizontalAlignment(alignment);
        }
        return renderer;
    }

    public ListCellRenderer createListCellRenderer(ObjEntityViewField field) {
        int alignment;
        ListCellRenderer<Object> renderer = null;
        Format format = field.getDisplayFormat();
        int dataType = field.getDataType().getValue();
        String nullText = "";
        String invalidText = "";
        switch (dataType) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                alignment = 4;
            }
        }
        alignment = 2;
        if (format != null) {
            renderer = this.createFormatListCellRenderer(format, nullText, invalidText, alignment);
        } else {
            renderer = new DefaultListCellRenderer();
            renderer.setHorizontalAlignment(alignment);
        }
        return renderer;
    }

    public void installRenderers(JTable table) {
        TableModel m = table.getModel();
        if (!(m instanceof DOTableModel)) {
            return;
        }
        DOTableModel model = (DOTableModel)m;
        TableColumnModel columnModel = table.getColumnModel();
        int columnCount = model.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            ObjEntityViewField field = model.getField(i);
            TableCellRenderer renderer = this.createTableCellRenderer(field);
            TableColumn column = columnModel.getColumn(i);
            column.setCellRenderer(renderer);
        }
    }

    public void installRenderer(JList list, ObjEntityViewField field) {
        ListCellRenderer renderer = this.createListCellRenderer(field);
        list.setCellRenderer(renderer);
    }

    public void installRenderer(JComboBox comboBox, ObjEntityViewField field) {
        ListCellRenderer renderer = this.createListCellRenderer(field);
        comboBox.setRenderer(renderer);
    }

    public class FormatListCellRenderer
    extends DefaultListCellRenderer {
        protected Format formatter;
        protected String nullText = "";
        protected String invalidText = "";

        public FormatListCellRenderer() {
            this(null, null, null);
        }

        public FormatListCellRenderer(Format formatter) {
            this(formatter, null, null);
        }

        public FormatListCellRenderer(Format formatter, String nullText) {
            this(formatter, nullText, null);
        }

        public FormatListCellRenderer(Format formatter, String nullText, String invalidText) {
            this.setFormatter(formatter);
            this.setNullText(nullText);
            this.setInvalidText(invalidText);
        }

        public void setFormatter(Format formatter) {
            this.formatter = formatter;
        }

        public Format getFormatter() {
            return this.formatter;
        }

        public void setNullText(String nullText) {
            this.nullText = nullText != null ? nullText : this.nullText;
        }

        public String getNullText() {
            return this.nullText;
        }

        public void setInvalidText(String invalidText) {
            this.invalidText = invalidText != null ? invalidText : this.invalidText;
        }

        public String getInvalidText() {
            return this.invalidText;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String text;
            try {
                text = value == null ? this.nullText : (this.formatter == null ? value.toString() : this.formatter.format(value));
            }
            catch (Exception ex) {
                text = this.invalidText;
            }
            return super.getListCellRendererComponent((JList<?>)list, text, index, isSelected, cellHasFocus);
        }
    }

    public class FormatRenderer
    extends DefaultTableCellRenderer {
        protected Format formatter;
        protected String nullText = "";
        protected String invalidText = "";

        public FormatRenderer() {
            this(null, null, null);
        }

        public FormatRenderer(Format formatter) {
            this(formatter, null, null);
        }

        public FormatRenderer(Format formatter, String nullText) {
            this(formatter, nullText, null);
        }

        public FormatRenderer(Format formatter, String nullText, String invalidText) {
            this.setFormatter(formatter);
            this.setNullText(nullText);
            this.setInvalidText(invalidText);
        }

        public void setFormatter(Format formatter) {
            this.formatter = formatter;
        }

        public Format getFormatter() {
            return this.formatter;
        }

        public void setNullText(String nullText) {
            this.nullText = nullText != null ? nullText : this.nullText;
        }

        public String getNullText() {
            return this.nullText;
        }

        public void setInvalidText(String invalidText) {
            this.invalidText = invalidText != null ? invalidText : this.invalidText;
        }

        public String getInvalidText() {
            return this.invalidText;
        }

        public void setValue(Object value) {
            String text;
            try {
                text = value == null ? this.nullText : (this.formatter == null ? value.toString() : this.formatter.format(value));
            }
            catch (Exception ex) {
                text = this.invalidText;
            }
            this.setText(text);
        }
    }

    public class ObjectRenderer
    extends DefaultTableCellRenderer {
    }

    public class BooleanRenderer
    extends JCheckBox
    implements TableCellRenderer {
        public BooleanRenderer() {
            this.setHorizontalAlignment(0);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            this.setSelected(value != null && (Boolean)value != false);
            return this;
        }
    }
}

