/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.dataview;

import java.util.ArrayList;
import java.util.EventListener;
import org.objectstyle.cayenne.dataview.DispatchableEvent;

public class EventDispatcher {
    protected transient ArrayList listeners = new ArrayList(1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch(DispatchableEvent e) {
        EventListener[] listenersCopy = null;
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            if (this.hasListeners()) {
                listenersCopy = this.listeners.toArray(new EventListener[this.listeners.size()]);
            }
        }
        if (listenersCopy != null) {
            int count = listenersCopy.length;
            for (int index = 0; index < count; ++index) {
                e.dispatch(listenersCopy[index]);
            }
        }
    }

    public synchronized boolean hasListeners() {
        return !this.listeners.isEmpty();
    }

    public synchronized int getListenerCount() {
        return this.listeners.size();
    }

    public synchronized int find(EventListener listener) {
        return this.listeners.indexOf(listener);
    }

    public synchronized void add(EventListener listener) {
        if (this.find(listener) < 0) {
            this.listeners.add(listener);
        }
    }

    public synchronized void remove(EventListener listener) {
        this.listeners.remove(listener);
    }

    public synchronized void clear() {
        this.listeners.clear();
    }

    public static EventDispatcher add(EventDispatcher dispatcher, EventListener listener) {
        if (dispatcher == null) {
            dispatcher = new EventDispatcher();
        }
        dispatcher.add(listener);
        return dispatcher;
    }

    public static final EventDispatcher remove(EventDispatcher dispatcher, EventListener listener) {
        if (dispatcher != null) {
            dispatcher.remove(listener);
            if (!dispatcher.hasListeners()) {
                dispatcher = null;
            }
        }
        return dispatcher;
    }
}

