/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.dba;

import org.objectstyle.cayenne.access.jdbc.BatchAction;
import org.objectstyle.cayenne.access.jdbc.ProcedureAction;
import org.objectstyle.cayenne.access.jdbc.SQLTemplateAction;
import org.objectstyle.cayenne.access.jdbc.SelectAction;
import org.objectstyle.cayenne.access.jdbc.UpdateAction;
import org.objectstyle.cayenne.dba.DbAdapter;
import org.objectstyle.cayenne.map.EntityResolver;
import org.objectstyle.cayenne.query.BatchQuery;
import org.objectstyle.cayenne.query.ProcedureQuery;
import org.objectstyle.cayenne.query.Query;
import org.objectstyle.cayenne.query.SQLAction;
import org.objectstyle.cayenne.query.SQLActionVisitor;
import org.objectstyle.cayenne.query.SQLTemplate;
import org.objectstyle.cayenne.query.SelectQuery;

public class JdbcActionBuilder
implements SQLActionVisitor {
    protected DbAdapter adapter;
    protected EntityResolver entityResolver;

    public JdbcActionBuilder(DbAdapter adapter, EntityResolver resolver) {
        this.adapter = adapter;
        this.entityResolver = resolver;
    }

    public SQLAction batchAction(BatchQuery query) {
        boolean useOptimisticLock = query.isUsingOptimisticLocking();
        boolean runningAsBatch = !useOptimisticLock && this.adapter.supportsBatchUpdates();
        BatchAction action = new BatchAction(query, this.adapter, this.entityResolver);
        action.setBatch(runningAsBatch);
        return action;
    }

    public SQLAction procedureAction(ProcedureQuery query) {
        return new ProcedureAction(query, this.adapter, this.entityResolver);
    }

    public SQLAction objectSelectAction(SelectQuery query) {
        return new SelectAction(query, this.adapter, this.entityResolver);
    }

    public SQLAction sqlAction(SQLTemplate query) {
        return new SQLTemplateAction(query, this.adapter);
    }

    public SQLAction updateAction(Query query) {
        if (query instanceof SQLTemplate) {
            return new SQLTemplateAction((SQLTemplate)query, this.adapter);
        }
        return new UpdateAction(query, this.adapter, this.entityResolver);
    }

    public DbAdapter getAdapter() {
        return this.adapter;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }
}

