/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.dba.db2;

import org.objectstyle.cayenne.CayenneRuntimeException;
import org.objectstyle.cayenne.access.trans.QueryAssembler;
import org.objectstyle.cayenne.access.trans.TrimmingQualifierTranslator;
import org.objectstyle.cayenne.dba.TypesMapping;
import org.objectstyle.cayenne.exp.Expression;
import org.objectstyle.cayenne.map.DbAttribute;

public class DB2QualifierTranslator
extends TrimmingQualifierTranslator {
    public DB2QualifierTranslator() {
    }

    public DB2QualifierTranslator(QueryAssembler queryAssembler, String trimFunction) {
        super(queryAssembler, trimFunction);
    }

    protected void appendLiteralDirect(StringBuffer buf, Object val, DbAttribute attr, Expression parentExpression) {
        boolean castNeeded = false;
        if (parentExpression != null) {
            int type = parentExpression.getType();
            boolean bl = castNeeded = attr != null && (type == 11 || type == 12 || type == 37 || type == 38);
        }
        if (castNeeded) {
            buf.append("CAST (");
        }
        super.appendLiteralDirect(buf, val, attr, parentExpression);
        if (castNeeded) {
            int jdbcType = attr.getType();
            int len = attr.getMaxLength();
            if (jdbcType == 1 || jdbcType == -1) {
                jdbcType = 12;
                if (len <= 0) {
                    len = 254;
                }
            }
            buf.append(" AS ");
            String[] types = this.getQueryAssembler().getAdapter().externalTypesForJdbcType(jdbcType);
            if (types == null || types.length == 0) {
                throw new CayenneRuntimeException("Can't find database type for JDBC type '" + TypesMapping.getSqlNameByType(jdbcType));
            }
            buf.append(types[0]);
            if (len > 0 && TypesMapping.supportsLength(jdbcType)) {
                buf.append("(").append(len).append(")");
            }
            buf.append(")");
        }
    }
}

