/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.dba.derby;

import org.objectstyle.cayenne.CayenneRuntimeException;
import org.objectstyle.cayenne.access.trans.QualifierTranslator;
import org.objectstyle.cayenne.access.trans.QueryAssembler;
import org.objectstyle.cayenne.access.trans.TrimmingQualifierTranslator;
import org.objectstyle.cayenne.access.types.ByteType;
import org.objectstyle.cayenne.access.types.CharType;
import org.objectstyle.cayenne.access.types.ExtendedTypeMap;
import org.objectstyle.cayenne.access.types.ShortType;
import org.objectstyle.cayenne.dba.JdbcAdapter;
import org.objectstyle.cayenne.dba.PkGenerator;
import org.objectstyle.cayenne.dba.TypesMapping;
import org.objectstyle.cayenne.dba.derby.DerbyPkGenerator;
import org.objectstyle.cayenne.map.DbAttribute;
import org.objectstyle.cayenne.map.DbEntity;

public class DerbyAdapter
extends JdbcAdapter {
    static final String FOR_BIT_DATA_SUFFIX = " FOR BIT DATA";

    public DerbyAdapter() {
        this.setSupportsGeneratedKeys(true);
    }

    protected PkGenerator createPkGenerator() {
        return new DerbyPkGenerator();
    }

    protected void configureExtendedTypes(ExtendedTypeMap map) {
        super.configureExtendedTypes(map);
        map.registerType(new CharType(true, false));
        map.registerType(new ShortType(true));
        map.registerType(new ByteType(true));
    }

    protected void createTableAppendColumn(StringBuffer sqlBuffer, DbAttribute column) {
        String[] types = this.externalTypesForJdbcType(column.getType());
        if (types == null || types.length == 0) {
            String entityName = column.getEntity() != null ? ((DbEntity)column.getEntity()).getFullyQualifiedName() : "<null>";
            throw new CayenneRuntimeException("Undefined type for attribute '" + entityName + "." + column.getName() + "': " + column.getType());
        }
        String type = types[0];
        String length = "";
        if (TypesMapping.supportsLength(column.getType())) {
            int prec;
            int len = column.getMaxLength();
            int n = prec = TypesMapping.isDecimal(column.getType()) ? column.getPrecision() : -1;
            if (prec > len) {
                prec = -1;
            }
            if (len > 0) {
                length = " (" + len;
                if (prec >= 0) {
                    length = length + ", " + prec;
                }
                length = length + ")";
            }
        }
        sqlBuffer.append(column.getName()).append(' ');
        if (length.length() > 0 && type.endsWith(FOR_BIT_DATA_SUFFIX)) {
            sqlBuffer.append(type.substring(0, type.length() - FOR_BIT_DATA_SUFFIX.length()));
            sqlBuffer.append(length);
            sqlBuffer.append(FOR_BIT_DATA_SUFFIX);
        } else {
            sqlBuffer.append(type).append(length);
        }
        if (column.isMandatory()) {
            sqlBuffer.append(" NOT NULL");
        }
        if (column.isGenerated()) {
            sqlBuffer.append(" GENERATED BY DEFAULT AS IDENTITY");
        }
    }

    public QualifierTranslator getQualifierTranslator(QueryAssembler queryAssembler) {
        return new TrimmingQualifierTranslator(queryAssembler, "RTRIM");
    }
}

