/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.dba.frontbase;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.objectstyle.cayenne.CayenneRuntimeException;
import org.objectstyle.cayenne.access.DataNode;
import org.objectstyle.cayenne.access.QueryResult;
import org.objectstyle.cayenne.dba.JdbcPkGenerator;
import org.objectstyle.cayenne.map.DbEntity;
import org.objectstyle.cayenne.query.SQLTemplate;

public class FrontBasePkGenerator
extends JdbcPkGenerator {
    public int getPkCacheSize() {
        return 0;
    }

    public void createAutoPk(DataNode node, List dbEntities) throws Exception {
        Iterator it = dbEntities.iterator();
        while (it.hasNext()) {
            DbEntity ent = (DbEntity)it.next();
            this.runUpdate(node, this.pkCreateString(ent.getName()));
        }
    }

    public List createAutoPkStatements(List dbEntities) {
        ArrayList<String> list = new ArrayList<String>();
        Iterator it = dbEntities.iterator();
        while (it.hasNext()) {
            DbEntity ent = (DbEntity)it.next();
            list.add(this.pkCreateString(ent.getName()));
        }
        return list;
    }

    public void dropAutoPk(DataNode node, List dbEntities) throws Exception {
    }

    protected String pkTableCreateString() {
        return "";
    }

    protected String pkDeleteString(List dbEntities) {
        return "-- The 'Drop Primary Key Support' option is unavailable";
    }

    protected String pkCreateString(String entName) {
        StringBuffer buf = new StringBuffer();
        buf.append("SET UNIQUE = 1000000 FOR \"" + entName + "\"");
        return buf.toString();
    }

    protected String pkSelectString(String entName) {
        StringBuffer buf = new StringBuffer();
        buf.append("SELECT UNIQUE FROM \"" + entName + "\"");
        return buf.toString();
    }

    protected String pkUpdateString(String entName) {
        return "";
    }

    protected String dropAutoPkString() {
        return "";
    }

    protected int pkFromDatabase(DataNode node, DbEntity entity) throws Exception {
        String template = "SELECT #result('UNIQUE' 'int') FROM " + entity.getName();
        SQLTemplate query = new SQLTemplate(entity, template);
        QueryResult observer = new QueryResult();
        node.performQueries(Collections.singleton(query), observer);
        List results = observer.getFirstRows(query);
        if (results.size() != 1) {
            throw new CayenneRuntimeException("Error fetching PK. Expected one row, got " + results.size());
        }
        Map row = (Map)results.get(0);
        Number pk = (Number)row.get("UNIQUE");
        return pk.intValue();
    }
}

