/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.dba.ingres;

import java.util.Iterator;
import org.objectstyle.cayenne.CayenneRuntimeException;
import org.objectstyle.cayenne.access.trans.QualifierTranslator;
import org.objectstyle.cayenne.access.trans.QueryAssembler;
import org.objectstyle.cayenne.access.trans.TrimmingQualifierTranslator;
import org.objectstyle.cayenne.access.types.ExtendedTypeMap;
import org.objectstyle.cayenne.dba.JdbcAdapter;
import org.objectstyle.cayenne.dba.PkGenerator;
import org.objectstyle.cayenne.dba.TypesMapping;
import org.objectstyle.cayenne.dba.ingres.IngresCharType;
import org.objectstyle.cayenne.dba.ingres.IngresPkGenerator;
import org.objectstyle.cayenne.map.DbAttribute;
import org.objectstyle.cayenne.map.DbEntity;
import org.objectstyle.cayenne.map.DerivedDbEntity;

public class IngresAdapter
extends JdbcAdapter {
    public static final String TRIM_FUNCTION = "TRIM";

    public QualifierTranslator getQualifierTranslator(QueryAssembler queryAssembler) {
        return new TrimmingQualifierTranslator(queryAssembler, TRIM_FUNCTION);
    }

    public String createTable(DbEntity ent) {
        if (ent instanceof DerivedDbEntity) {
            throw new CayenneRuntimeException("Can't create table for derived DbEntity '" + ent.getName() + "'.");
        }
        StringBuffer buf = new StringBuffer();
        buf.append("CREATE TABLE ").append(ent.getFullyQualifiedName()).append(" (");
        Iterator it = ent.getAttributes().iterator();
        boolean first = true;
        while (it.hasNext()) {
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            DbAttribute at = (DbAttribute)it.next();
            if (at.getType() == Integer.MAX_VALUE) {
                throw new CayenneRuntimeException("Undefined type for attribute '" + ent.getFullyQualifiedName() + "." + at.getName() + "'.");
            }
            String[] types = this.externalTypesForJdbcType(at.getType());
            if (types == null || types.length == 0) {
                throw new CayenneRuntimeException("Undefined type for attribute '" + ent.getFullyQualifiedName() + "." + at.getName() + "': " + at.getType());
            }
            String type = types[0];
            buf.append(at.getName()).append(' ').append(type);
            if (TypesMapping.supportsLength(at.getType())) {
                int prec;
                int len = at.getMaxLength();
                int n = prec = TypesMapping.isDecimal(at.getType()) ? at.getPrecision() : -1;
                if (prec > len) {
                    prec = -1;
                }
                if (len > 0) {
                    buf.append('(').append(len);
                    if (prec >= 0) {
                        buf.append(", ").append(prec);
                    }
                    buf.append(')');
                }
            }
            if (!at.isMandatory()) continue;
            buf.append(" NOT NULL");
        }
        Iterator pkit = ent.getPrimaryKey().iterator();
        if (pkit.hasNext()) {
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            buf.append("PRIMARY KEY (");
            boolean firstPk = true;
            while (pkit.hasNext()) {
                if (firstPk) {
                    firstPk = false;
                } else {
                    buf.append(", ");
                }
                DbAttribute at = (DbAttribute)pkit.next();
                buf.append(at.getName());
            }
            buf.append(')');
        }
        buf.append(')');
        return buf.toString();
    }

    protected void configureExtendedTypes(ExtendedTypeMap map) {
        super.configureExtendedTypes(map);
        map.registerType(new IngresCharType());
    }

    protected PkGenerator createPkGenerator() {
        return new IngresPkGenerator();
    }
}

