/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.dba.mysql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import org.objectstyle.cayenne.access.DataNode;
import org.objectstyle.cayenne.access.QueryLogger;
import org.objectstyle.cayenne.dba.JdbcPkGenerator;
import org.objectstyle.cayenne.map.DbEntity;

public class MySQLPkGenerator
extends JdbcPkGenerator {
    protected String dropAutoPkString() {
        return "DROP TABLE IF EXISTS AUTO_PK_SUPPORT";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected int pkFromDatabase(DataNode node, DbEntity ent) throws Exception {
        SQLException exception = null;
        int pk = -1;
        Connection con = node.getDataSource().getConnection();
        try {
            Statement st = con.createStatement();
            try {
                pk = this.getPrimaryKey(st, ent.getName());
            }
            catch (SQLException pkEx) {
                exception = this.processSQLException(pkEx, exception);
            }
            finally {
                block48: {
                    String unlockString = "UNLOCK TABLES";
                    QueryLogger.logQuery(unlockString, Collections.EMPTY_LIST);
                    st.execute(unlockString);
                    try {
                        st.close();
                    }
                    catch (SQLException stClosingEx) {}
                    break block48;
                    catch (SQLException unlockEx) {
                        try {
                            exception = this.processSQLException(unlockEx, exception);
                        }
                        catch (Throwable throwable) {
                            try {
                                st.close();
                            }
                            catch (SQLException stClosingEx) {}
                            throw throwable;
                        }
                        try {
                            st.close();
                        }
                        catch (SQLException stClosingEx) {}
                    }
                }
            }
        }
        catch (SQLException otherEx) {
            exception = this.processSQLException(otherEx, exception);
        }
        finally {
            try {
                con.close();
            }
            catch (SQLException closingEx) {}
        }
        if (exception != null) {
            throw exception;
        }
        return pk;
    }

    protected SQLException processSQLException(SQLException exception, SQLException parent) {
        if (parent == null) {
            return exception;
        }
        parent.setNextException(exception);
        return parent;
    }

    protected String pkTableCreateString() {
        StringBuffer buf = new StringBuffer();
        buf.append("CREATE TABLE AUTO_PK_SUPPORT (").append("  TABLE_NAME CHAR(100) NOT NULL,").append("  NEXT_ID INTEGER NOT NULL, UNIQUE (TABLE_NAME)").append(")");
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getPrimaryKey(Statement statement, String entityName) throws SQLException {
        String lockString = "LOCK TABLES AUTO_PK_SUPPORT WRITE";
        QueryLogger.logQuery(lockString, Collections.EMPTY_LIST);
        statement.execute(lockString);
        int pk = -1;
        String selectString = super.pkSelectString(entityName);
        QueryLogger.logQuery(selectString, Collections.EMPTY_LIST);
        ResultSet rs = statement.executeQuery(selectString);
        try {
            if (!rs.next()) {
                throw new SQLException("No rows for '" + entityName + "'");
            }
            pk = rs.getInt(1);
            if (rs.next()) {
                throw new SQLException("More than one row for '" + entityName + "'");
            }
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception ex) {}
        }
        String updateString = super.pkUpdateString(entityName) + " AND NEXT_ID = " + pk;
        QueryLogger.logQuery(updateString, Collections.EMPTY_LIST);
        int updated = statement.executeUpdate(updateString);
        if (updated != 1) {
            throw new SQLException("Error updating PK count '" + entityName + "': " + updated);
        }
        return pk;
    }
}

